/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.MappedByteBufferInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MappedByteBufferOutputStream
extends OutputStream {
    private final MappedByteBufferInputStream parent;

    MappedByteBufferOutputStream(MappedByteBufferInputStream mappedByteBufferInputStream, MappedByteBufferInputStream.FileResizeOp fileResizeOp) throws IOException {
        if (FileChannel.MapMode.READ_ONLY == mappedByteBufferInputStream.getMapMode()) {
            throw new IOException("FileChannel map-mode is read-only");
        }
        this.parent = mappedByteBufferInputStream;
        this.parent.setFileResizeOp(fileResizeOp);
    }

    public MappedByteBufferOutputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, MappedByteBufferInputStream.CacheMode cacheMode, int n2, MappedByteBufferInputStream.FileResizeOp fileResizeOp) throws IOException {
        this(new MappedByteBufferInputStream(fileChannel, mapMode, cacheMode, n2, fileChannel.size(), 0), fileResizeOp);
    }

    public final synchronized void setSynchronous(boolean bl) {
        this.parent.setSynchronous(bl);
    }

    public final synchronized boolean getSynchronous() {
        return this.parent.getSynchronous();
    }

    public final synchronized void setLength(long l2) throws IOException {
        this.parent.setLength(l2);
    }

    public final synchronized void notifyLengthChange(long l2) throws IOException {
        this.parent.notifyLengthChange(l2);
    }

    public final synchronized long length() {
        return this.parent.length();
    }

    public final synchronized long remaining() throws IOException {
        return this.parent.remaining();
    }

    public final synchronized long position() throws IOException {
        return this.parent.position();
    }

    public final synchronized MappedByteBufferInputStream position(long l2) throws IOException {
        return this.parent.position(l2);
    }

    public final synchronized long skip(long l2) throws IOException {
        return this.parent.skip(l2);
    }

    @Override
    public final synchronized void flush() throws IOException {
        this.parent.flush(true);
    }

    public final synchronized void flush(boolean bl) throws IOException {
        this.parent.flush(bl);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.parent.close();
    }

    @Override
    public final synchronized void write(int n2) throws IOException {
        ByteBuffer byteBuffer;
        int n3;
        this.parent.checkOpen();
        long l2 = this.parent.remaining();
        if (l2 < 1L) {
            this.parent.setLength(this.parent.length() + 1L);
        }
        if (0 == (n3 = (byteBuffer = this.parent.currentSlice()).remaining()) && null == (byteBuffer = this.parent.nextSlice())) {
            if (MappedByteBufferInputStream.DEBUG) {
                System.err.println("EOT write: " + this.parent.currentSlice());
                this.parent.dbgDump("EOT write:", System.err);
            }
            throw new IOException("EOT");
        }
        byteBuffer.put((byte)(n2 & 0xFF));
        if (null != byteBuffer) {
            this.parent.syncSlice(byteBuffer);
        }
    }

    @Override
    public final synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.parent.checkOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("offset " + n2 + ", length " + n3 + ", b.length " + byArray.length);
        }
        if (0 == n3) {
            return;
        }
        long l2 = this.parent.remaining();
        if (l2 < (long)n3) {
            this.parent.setLength(this.parent.length() + (long)n3 - l2);
        }
        ByteBuffer byteBuffer = null;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            byteBuffer = this.parent.currentSlice();
            int n5 = byteBuffer.remaining();
            if (0 == n5) {
                byteBuffer = this.parent.nextSlice();
                if (null == byteBuffer) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        System.err.println("EOT write: offset " + n2 + ", length " + n3 + ", b.length " + byArray.length);
                        System.err.println("EOT write: written " + i2 + " / " + n3 + ", currRem " + n5);
                        System.err.println("EOT write: " + this.parent.currentSlice());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n5 = byteBuffer.remaining();
            }
            n4 = Math.min(n3 - i2, n5);
            byteBuffer.put(byArray, n2 + i2, n4);
        }
        if (null != byteBuffer) {
            this.parent.syncSlice(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void write(ByteBuffer byteBuffer, int n2) throws IOException {
        int n3;
        this.parent.checkOpen();
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException("length " + n2 + ", b " + byteBuffer);
        }
        if (0 == n2) {
            return;
        }
        long l2 = this.parent.remaining();
        if (l2 < (long)n2) {
            this.parent.setLength(this.parent.length() + (long)n2 - l2);
        }
        ByteBuffer byteBuffer2 = null;
        for (int i2 = 0; i2 < n2; i2 += n3) {
            byteBuffer2 = this.parent.currentSlice();
            int n4 = byteBuffer2.remaining();
            if (0 == n4) {
                byteBuffer2 = this.parent.nextSlice();
                if (null == byteBuffer2) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        System.err.println("EOT write: length " + n2 + ", b " + byteBuffer);
                        System.err.println("EOT write: written " + i2 + " / " + n2 + ", currRem " + n4);
                        System.err.println("EOT write: " + this.parent.currentSlice());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n4 = byteBuffer2.remaining();
            }
            n3 = Math.min(n2 - i2, n4);
            if (byteBuffer2.hasArray() && byteBuffer.hasArray()) {
                System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), n3);
                byteBuffer.position(byteBuffer.position() + n3);
                byteBuffer2.position(byteBuffer2.position() + n3);
                continue;
            }
            if (n3 == n4) {
                byteBuffer2.put(byteBuffer);
                continue;
            }
            int n5 = byteBuffer.limit();
            byteBuffer.limit(n3);
            try {
                byteBuffer2.put(byteBuffer);
                continue;
            }
            finally {
                byteBuffer.limit(n5);
            }
        }
        if (null != byteBuffer2) {
            this.parent.syncSlice(byteBuffer2);
        }
    }

    public final synchronized void write(MappedByteBufferInputStream mappedByteBufferInputStream, long l2) throws IOException {
        int n2;
        this.parent.checkOpen();
        if (mappedByteBufferInputStream == null) {
            throw new NullPointerException();
        }
        if (l2 < 0L || l2 > mappedByteBufferInputStream.remaining()) {
            throw new IndexOutOfBoundsException("length " + l2 + ", b " + mappedByteBufferInputStream);
        }
        if (0L == l2) {
            return;
        }
        long l3 = this.parent.remaining();
        if (l3 < l2) {
            this.parent.setLength(this.parent.length() + l2 - l3);
        }
        ByteBuffer byteBuffer = null;
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            byteBuffer = this.parent.currentSlice();
            int n3 = byteBuffer.remaining();
            if (0 == n3) {
                byteBuffer = this.parent.nextSlice();
                if (null == byteBuffer) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        System.err.println("EOT write: length " + l2 + ", b " + mappedByteBufferInputStream);
                        System.err.println("EOT write: written " + i2 + " / " + l2 + ", currRem " + n3);
                        System.err.println("EOT write: " + this.parent.currentSlice());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n3 = byteBuffer.remaining();
            }
            if (0 <= (n2 = mappedByteBufferInputStream.read(byteBuffer, (int)Math.min(l2 - i2, (long)n3)))) continue;
            throw new InternalError("Unexpected InputStream EOT");
        }
        if (null != byteBuffer) {
            this.parent.syncSlice(byteBuffer);
        }
    }
}

