/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.LongObjectHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class PointerBuffer
extends AbstractBuffer<PointerBuffer> {
    public static final int ELEMENT_SIZE = Platform.is32Bit() ? 4 : 8;
    protected LongObjectHashMap dataMap = null;

    static PointerBuffer create(ByteBuffer byteBuffer) {
        return Platform.is32Bit() ? new PointerBuffer(byteBuffer.asIntBuffer()) : new PointerBuffer(byteBuffer.asLongBuffer());
    }

    PointerBuffer(IntBuffer intBuffer) {
        super(intBuffer, ELEMENT_SIZE, intBuffer.capacity());
    }

    PointerBuffer(LongBuffer longBuffer) {
        super(longBuffer, ELEMENT_SIZE, longBuffer.capacity());
    }

    private final void validateDataMap() {
        if (null == this.dataMap) {
            this.dataMap = new LongObjectHashMap();
            this.dataMap.setKeyNotFoundValue(null);
        }
    }

    public static PointerBuffer allocate(int n2) {
        if (Platform.is32Bit()) {
            return new PointerBuffer(IntBuffer.wrap(new int[n2]));
        }
        return new PointerBuffer(LongBuffer.wrap(new long[n2]));
    }

    public static PointerBuffer allocateDirect(int n2) {
        return PointerBuffer.create(Buffers.newDirectByteBuffer(ELEMENT_SIZE * n2));
    }

    public static PointerBuffer wrap(ByteBuffer byteBuffer) {
        return PointerBuffer.create(byteBuffer);
    }

    public final PointerBuffer duplicate() {
        PointerBuffer pointerBuffer = Platform.is32Bit() ? new PointerBuffer((IntBuffer)this.buffer) : new PointerBuffer((LongBuffer)this.buffer);
        if (null != this.dataMap) {
            pointerBuffer.dataMap = (LongObjectHashMap)this.dataMap.clone();
        }
        pointerBuffer.position = this.position;
        return pointerBuffer;
    }

    @Override
    public final PointerBuffer put(PointerBuffer pointerBuffer) {
        if (this.remaining() < pointerBuffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (null == pointerBuffer.dataMap && null == this.dataMap) {
            while (pointerBuffer.hasRemaining()) {
                this.put(pointerBuffer.get());
            }
        } else {
            while (pointerBuffer.hasRemaining()) {
                long l2 = pointerBuffer.get();
                this.put(l2);
                if (null != pointerBuffer.dataMap) {
                    Buffer buffer = (Buffer)pointerBuffer.dataMap.get(l2);
                    if (null != buffer) {
                        this.validateDataMap();
                        this.dataMap.put(l2, buffer);
                        continue;
                    }
                    if (null == this.dataMap) continue;
                    this.dataMap.remove(l2);
                    continue;
                }
                if (null == this.dataMap) continue;
                this.dataMap.remove(l2);
            }
        }
        return this;
    }

    @Override
    public final long get() {
        long l2 = this.get(this.position);
        ++this.position;
        return l2;
    }

    @Override
    public final long get(int n2) {
        if (0 > n2 || n2 >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (Platform.is32Bit()) {
            return (long)((IntBuffer)this.buffer).get(n2) & 0xFFFFFFFFL;
        }
        return ((LongBuffer)this.buffer).get(n2);
    }

    public final PointerBuffer get(long[] lArray, int n2, int n3) {
        if (lArray.length < n2 + n3) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < n3) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            lArray[n2++] = this.get(this.position++);
            --n3;
        }
        return this;
    }

    @Override
    public final PointerBuffer put(int n2, long l2) {
        if (0 > n2 || n2 >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (Platform.is32Bit()) {
            ((IntBuffer)this.buffer).put(n2, (int)l2);
        } else {
            ((LongBuffer)this.buffer).put(n2, l2);
        }
        return this;
    }

    @Override
    public final PointerBuffer put(long l2) {
        this.put(this.position, l2);
        ++this.position;
        return this;
    }

    public final PointerBuffer put(long[] lArray, int n2, int n3) {
        if (lArray.length < n2 + n3) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < n3) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            this.put(this.position++, lArray[n2++]);
            --n3;
        }
        return this;
    }

    public final PointerBuffer referenceBuffer(int n2, Buffer buffer) {
        if (null == buffer) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Buffer is not direct");
        }
        long l2 = Platform.is32Bit() ? 0xFFFFFFFFL : -1L;
        long l3 = this.getDirectBufferAddressImpl(buffer) & l2;
        if (0L == l3) {
            throw new RuntimeException("Couldn't determine native address of given Buffer: " + buffer);
        }
        this.validateDataMap();
        this.put(n2, l3);
        this.dataMap.put(l3, buffer);
        return this;
    }

    public final PointerBuffer referenceBuffer(Buffer buffer) {
        this.referenceBuffer(this.position, buffer);
        ++this.position;
        return this;
    }

    public final Buffer getReferencedBuffer(int n2) {
        if (null != this.dataMap) {
            long l2 = this.get(n2);
            return (Buffer)this.dataMap.get(l2);
        }
        return null;
    }

    public final Buffer getReferencedBuffer() {
        Buffer buffer = this.getReferencedBuffer(this.position);
        ++this.position;
        return buffer;
    }

    private native long getDirectBufferAddressImpl(Object var1);

    @Override
    public String toString() {
        return "PointerBuffer:" + super.toString();
    }

    static {
        Platform.initSingleton();
    }
}

