/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.PrimitiveStack;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.FloatBuffer;

public class FloatStack
implements PrimitiveStack {
    private int position = 0;
    private float[] buffer;
    private int growSize;

    public FloatStack(int n2, int n3) {
        this.growSize = n3;
        this.buffer = new float[n2];
    }

    @Override
    public final int capacity() {
        return this.buffer.length;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final void position(int n2) throws IndexOutOfBoundsException {
        if (0 > this.position || this.position >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Invalid new position " + n2 + ", " + this.toString());
        }
        this.position = n2;
    }

    @Override
    public final int remaining() {
        return this.buffer.length - this.position;
    }

    @Override
    public final int getGrowSize() {
        return this.growSize;
    }

    @Override
    public final void setGrowSize(int n2) {
        this.growSize = n2;
    }

    public final String toString() {
        return "FloatStack[0..(pos " + this.position + ").." + this.buffer.length + ", remaining " + this.remaining() + "]";
    }

    public final float[] buffer() {
        return this.buffer;
    }

    private final void growIfNecessary(int n2) throws IndexOutOfBoundsException {
        if (this.position + n2 > this.buffer.length) {
            if (0 >= this.growSize) {
                throw new IndexOutOfBoundsException("Out of fixed stack size: " + this);
            }
            float[] fArray = new float[this.buffer.length + this.growSize];
            System.arraycopy(this.buffer, 0, fArray, 0, this.position);
            this.buffer = fArray;
        }
    }

    public final float[] putOnTop(float[] fArray, int n2, int n3) throws IndexOutOfBoundsException {
        this.growIfNecessary(n3);
        System.arraycopy(fArray, n2, this.buffer, this.position, n3);
        this.position += n3;
        return fArray;
    }

    public final FloatBuffer putOnTop(FloatBuffer floatBuffer, int n2) throws IndexOutOfBoundsException, BufferUnderflowException {
        this.growIfNecessary(n2);
        floatBuffer.get(this.buffer, this.position, n2);
        this.position += n2;
        return floatBuffer;
    }

    public final float[] getFromTop(float[] fArray, int n2, int n3) throws IndexOutOfBoundsException {
        System.arraycopy(this.buffer, this.position - n3, fArray, n2, n3);
        this.position -= n3;
        return fArray;
    }

    public final FloatBuffer getFromTop(FloatBuffer floatBuffer, int n2) throws IndexOutOfBoundsException, BufferOverflowException {
        floatBuffer.put(this.buffer, this.position - n2, n2);
        this.position -= n2;
        return floatBuffer;
    }
}

