/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jogamp.common.os.PlatformPropsImpl;

public class VersionUtil {
    public static final String SEPERATOR = "-----------------------------------------------------------------------------------------------------";

    public static StringBuilder getPlatformInfo(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(SEPERATOR).append(Platform.getNewline());
        stringBuilder.append("Platform: ").append((Object)Platform.getOSType()).append(" / ").append(Platform.getOSName()).append(' ').append(Platform.getOSVersion()).append(" (").append(Platform.getOSVersionNumber()).append("), ");
        stringBuilder.append(Platform.getArchName()).append(" (").append((Object)Platform.getCPUType()).append(", ").append((Object)Platform.getABIType()).append("), ");
        stringBuilder.append(Runtime.getRuntime().availableProcessors()).append(" cores, ").append("littleEndian ").append(PlatformPropsImpl.LITTLE_ENDIAN);
        stringBuilder.append(Platform.getNewline());
        if (Platform.OSType.ANDROID == PlatformPropsImpl.OS_TYPE) {
            stringBuilder.append("Platform: Android Version: ").append(AndroidVersion.CODENAME).append(", ");
            stringBuilder.append(AndroidVersion.RELEASE).append(" [").append(AndroidVersion.RELEASE).append("], SDK: ").append(AndroidVersion.SDK_INT).append(", ").append(AndroidVersion.SDK_NAME);
            stringBuilder.append(Platform.getNewline());
        }
        Platform.getMachineDataInfo().toString(stringBuilder).append(Platform.getNewline());
        stringBuilder.append("Platform: Java Version: ").append(Platform.getJavaVersion()).append(" (").append(Platform.getJavaVersionNumber()).append("u").append(PlatformPropsImpl.JAVA_VERSION_UPDATE).append("), VM: ").append(Platform.getJavaVMName());
        stringBuilder.append(", Runtime: ").append(Platform.getJavaRuntimeName()).append(Platform.getNewline());
        stringBuilder.append("Platform: Java Vendor: ").append(Platform.getJavaVendor()).append(", ").append(Platform.getJavaVendorURL());
        stringBuilder.append(", JavaSE: ").append(PlatformPropsImpl.JAVA_SE);
        stringBuilder.append(", Java6: ").append(PlatformPropsImpl.JAVA_6);
        stringBuilder.append(", AWT enabled: ").append(Platform.AWT_AVAILABLE);
        stringBuilder.append(Platform.getNewline()).append(SEPERATOR);
        return stringBuilder;
    }

    public static String getPlatformInfo() {
        return VersionUtil.getPlatformInfo(null).toString();
    }

    public static Manifest getManifest(ClassLoader classLoader, String string) {
        return VersionUtil.getManifest(classLoader, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(ClassLoader classLoader, String[] stringArray) {
        Manifest[] manifestArray = new Manifest[stringArray.length];
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                Manifest manifest;
                InputStream inputStream = enumeration.nextElement().openStream();
                try {
                    manifest = new Manifest(inputStream);
                }
                finally {
                    IOUtil.close(inputStream, false);
                }
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null) continue;
                for (int i2 = 0; i2 < stringArray.length && null == manifestArray[i2]; ++i2) {
                    String string = stringArray[i2];
                    if (!string.equals(attributes.getValue(Attributes.Name.EXTENSION_NAME))) continue;
                    if (0 == i2) {
                        return manifest;
                    }
                    manifestArray[i2] = manifest;
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read manifest.", iOException);
        }
        for (int i3 = 1; i3 < manifestArray.length; ++i3) {
            if (null == manifestArray[i3]) continue;
            return manifestArray[i3];
        }
        return null;
    }

    public static StringBuilder getFullManifestInfo(Manifest manifest, StringBuilder stringBuilder) {
        if (null == manifest) {
            return stringBuilder;
        }
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Attributes attributes = manifest.getMainAttributes();
        Set<Object> set = attributes.keySet();
        for (Attributes.Name name : set) {
            String string = attributes.getValue(name);
            stringBuilder.append(" ");
            stringBuilder.append(name);
            stringBuilder.append(" = ");
            stringBuilder.append(string);
            stringBuilder.append(Platform.getNewline());
        }
        return stringBuilder;
    }
}

