/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.FloatBuffer;
import jogamp.common.os.PlatformPropsImpl;

public class RenderState {
    private static final String thisKey = "jogamp.graph.curve.RenderState";
    public static final int BITHINT_BLENDING_ENABLED = 1;
    public static final int BITHINT_GLOBAL_DEPTH_TEST_ENABLED = 2;
    private final Vertex.Factory<? extends Vertex> vertexFactory;
    private final PMVMatrix pmvMatrix;
    private final float[] weight;
    private final FloatBuffer weightBuffer;
    private final float[] colorStatic;
    private final FloatBuffer colorStaticBuffer;
    private ShaderProgram sp = null;
    private int hintBitfield;
    private final int id = RenderState.getNextID();
    private static int nextID = 1;

    public static RenderState createRenderState(Vertex.Factory<? extends Vertex> factory) {
        return new RenderState(factory, null);
    }

    public static RenderState createRenderState(Vertex.Factory<? extends Vertex> factory, PMVMatrix pMVMatrix) {
        return new RenderState(factory, pMVMatrix);
    }

    public static final RenderState getRenderState(GL2ES2 gL2ES2) {
        return (RenderState)gL2ES2.getContext().getAttachedObject(thisKey);
    }

    private static synchronized int getNextID() {
        return nextID++;
    }

    protected RenderState(Vertex.Factory<? extends Vertex> factory, PMVMatrix pMVMatrix) {
        this.vertexFactory = factory;
        this.pmvMatrix = null != pMVMatrix ? pMVMatrix : new PMVMatrix();
        this.weight = new float[1];
        this.weightBuffer = FloatBuffer.wrap(this.weight);
        this.colorStatic = new float[4];
        this.colorStaticBuffer = FloatBuffer.wrap(this.colorStatic);
        this.hintBitfield = 0;
    }

    public final int id() {
        return this.id;
    }

    public final ShaderProgram getShaderProgram() {
        return this.sp;
    }

    public final boolean isShaderProgramInUse() {
        return null != this.sp ? this.sp.inUse() : false;
    }

    public final boolean setShaderProgram(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
        if (shaderProgram.equals(this.sp)) {
            shaderProgram.useProgram(gL2ES2, true);
            return false;
        }
        if (null != this.sp) {
            this.sp.notifyNotInUse();
        }
        this.sp = shaderProgram;
        shaderProgram.useProgram(gL2ES2, true);
        return true;
    }

    public final Vertex.Factory<? extends Vertex> getVertexFactory() {
        return this.vertexFactory;
    }

    public final PMVMatrix getMatrix() {
        return this.pmvMatrix;
    }

    public static boolean isWeightValid(float f2) {
        return 0.0f <= f2 && f2 <= 1.9f;
    }

    public final float getWeight() {
        return this.weight[0];
    }

    public final void setWeight(float f2) {
        if (!RenderState.isWeightValid(f2)) {
            throw new IllegalArgumentException("Weight out of range");
        }
        this.weight[0] = f2;
    }

    public final float[] getColorStatic(float[] fArray) {
        System.arraycopy(this.colorStatic, 0, fArray, 0, 4);
        return fArray;
    }

    public final void setColorStatic(float f2, float f3, float f4, float f5) {
        this.colorStatic[0] = f2;
        this.colorStatic[1] = f3;
        this.colorStatic[2] = f4;
        this.colorStatic[3] = f5;
    }

    public final boolean updateUniformLoc(GL2ES2 gL2ES2, boolean bl, GLUniformData gLUniformData, boolean bl2) {
        if (bl || 0 > gLUniformData.getLocation()) {
            boolean bl3;
            boolean bl4 = bl3 = 0 <= gLUniformData.setLocation(gL2ES2, this.sp.program());
            if (bl2 && !bl3) {
                throw new GLException("Could not locate " + gLUniformData);
            }
            return bl3;
        }
        return true;
    }

    public final boolean updateUniformDataLoc(GL2ES2 gL2ES2, boolean bl, boolean bl2, GLUniformData gLUniformData, boolean bl3) {
        boolean bl4 = bl = bl || 0 > gLUniformData.getLocation();
        if (bl) {
            boolean bl5 = bl2 = 0 <= gLUniformData.setLocation(gL2ES2, this.sp.program());
            if (bl3 && !bl2) {
                throw new GLException("Could not locate " + gLUniformData);
            }
        }
        if (bl2) {
            gL2ES2.glUniform(gLUniformData);
            return true;
        }
        return !bl;
    }

    public final boolean updateAttributeLoc(GL2ES2 gL2ES2, boolean bl, GLArrayDataServer gLArrayDataServer, boolean bl2) {
        if (bl || 0 > gLArrayDataServer.getLocation()) {
            boolean bl3;
            boolean bl4 = bl3 = 0 <= gLArrayDataServer.setLocation(gL2ES2, this.sp.program());
            if (bl2 && !bl3) {
                throw new GLException("Could not locate " + gLArrayDataServer);
            }
            return bl3;
        }
        return true;
    }

    public final boolean isHintMaskSet(int n2) {
        return n2 == (this.hintBitfield & n2);
    }

    public final void setHintMask(int n2) {
        this.hintBitfield |= n2;
    }

    public final void clearHintMask(int n2) {
        this.hintBitfield &= ~n2;
    }

    public void destroy(GL2ES2 gL2ES2) {
        if (null != this.sp) {
            this.sp.destroy(gL2ES2);
            this.sp = null;
        }
    }

    public final RenderState attachTo(GL2ES2 gL2ES2) {
        return (RenderState)gL2ES2.getContext().attachObject(thisKey, this);
    }

    public final boolean detachFrom(GL2ES2 gL2ES2) {
        RenderState renderState = (RenderState)gL2ES2.getContext().getAttachedObject(thisKey);
        if (renderState == this) {
            gL2ES2.getContext().detachObject(thisKey);
            return true;
        }
        return false;
    }

    public String toString() {
        return "RenderState[" + this.sp + "]";
    }

    public static class ProgramLocal {
        public final GLUniformData gcu_PMVMatrix01 = GLUniformData.creatEmptyMatrix("gcu_PMVMatrix01", 4, 4);
        public final GLUniformData gcu_Weight = GLUniformData.creatEmptyVector("gcu_Weight", 1);
        public final GLUniformData gcu_ColorStatic = GLUniformData.creatEmptyVector("gcu_ColorStatic", 4);
        private int rsId = -1;

        public final int getRenderStateId() {
            return this.rsId;
        }

        public final boolean update(GL2ES2 gL2ES2, RenderState renderState, boolean bl, int n2, boolean bl2, boolean bl3) {
            if (renderState.id() != this.rsId) {
                this.gcu_PMVMatrix01.setData(renderState.pmvMatrix.glGetPMvMatrixf());
                this.gcu_Weight.setData(renderState.weightBuffer);
                this.gcu_ColorStatic.setData(renderState.colorStaticBuffer);
                this.rsId = renderState.id();
            }
            boolean bl4 = true;
            if (null != renderState.sp && renderState.sp.inUse()) {
                boolean bl5;
                if (!Region.isTwoPass(n2) || !bl2) {
                    bl5 = renderState.updateUniformDataLoc(gL2ES2, bl, true, this.gcu_PMVMatrix01, bl3);
                    boolean bl6 = bl4 = bl4 && bl5;
                }
                if (bl2) {
                    if (Region.hasVariableWeight(n2)) {
                        bl5 = renderState.updateUniformDataLoc(gL2ES2, bl, true, this.gcu_Weight, bl3);
                        bl4 = bl4 && bl5;
                    }
                    bl5 = renderState.updateUniformDataLoc(gL2ES2, bl, true, this.gcu_ColorStatic, bl3);
                    bl4 = bl4 && bl5;
                }
            }
            return bl4;
        }

        public StringBuilder toString(StringBuilder stringBuilder, boolean bl) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("ProgramLocal[rsID ").append(this.rsId).append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append(this.gcu_PMVMatrix01).append(", ").append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append(this.gcu_ColorStatic).append(", ");
            stringBuilder.append(this.gcu_Weight).append("]");
            return stringBuilder;
        }

        public String toString() {
            return this.toString(null, false).toString();
        }
    }
}

