/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.event.MonitorModeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jogamp.newt.Debug;

public abstract class Screen {
    public static final int SCREEN_MODE_CHANGE_TIMEOUT = 10000;
    public static final boolean DEBUG = Debug.debug("Screen");
    protected static final ArrayList<WeakReference<Screen>> screenList = new ArrayList();
    protected static int screensActive = 0;

    public abstract int hashCode();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Screen) {
            Screen screen = (Screen)object;
            return screen.getFQName().equals(this.getFQName());
        }
        return false;
    }

    public abstract void createNative() throws NativeWindowException;

    public abstract void destroy();

    public abstract boolean isNativeValid();

    public abstract int getReferenceCount();

    public abstract int addReference() throws NativeWindowException;

    public abstract int removeReference();

    public abstract AbstractGraphicsScreen getGraphicsScreen();

    public abstract int getIndex();

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract RectangleImmutable getViewport();

    public abstract RectangleImmutable getViewportInWindowUnits();

    public abstract Display getDisplay();

    public abstract String getFQName();

    public abstract List<MonitorMode> getMonitorModes();

    public abstract List<MonitorDevice> getMonitorDevices();

    public abstract MonitorDevice getPrimaryMonitor();

    public final MonitorDevice getMainMonitor(RectangleImmutable rectangleImmutable) {
        MonitorDevice monitorDevice = null;
        float f2 = Float.MIN_VALUE;
        List<MonitorDevice> list = this.getMonitorDevices();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            float f3;
            MonitorDevice monitorDevice2 = list.get(i2);
            if (monitorDevice2.isClone() || !((f3 = monitorDevice2.getViewportInWindowUnits().coverage(rectangleImmutable)) > f2)) continue;
            f2 = f3;
            monitorDevice = monitorDevice2;
        }
        if (f2 > 0.0f && null != monitorDevice) {
            return monitorDevice;
        }
        return list.get(0);
    }

    public final MonitorDevice getMonitor(int n2) {
        List<MonitorDevice> list = this.getMonitorDevices();
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            MonitorDevice monitorDevice = list.get(i2);
            if (monitorDevice.getId() != n2) continue;
            return monitorDevice;
        }
        return null;
    }

    public final void unionOfMonitorViewports(Rectangle rectangle, Rectangle rectangle2) {
        MonitorDevice.unionOfViewports(rectangle, rectangle2, this.getMonitorDevices());
    }

    public abstract void addMonitorModeListener(MonitorModeListener var1);

    public abstract void removeMonitorModeListener(MonitorModeListener var1);

    public static Screen getFirstScreenOf(Display display, int n2, int n3) {
        return Screen.getScreenOfImpl(display, n2, n3, 1);
    }

    public static Screen getLastScreenOf(Display display, int n2, int n3) {
        return Screen.getScreenOfImpl(display, n2, n3, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Screen getScreenOfImpl(Display display, int n2, int n3, int n4) {
        ArrayList<WeakReference<Screen>> arrayList = screenList;
        synchronized (arrayList) {
            int n5;
            int n6 = n5 = n3 >= 0 ? n3 : screenList.size() - 1;
            while (n4 > 0 ? n5 < screenList.size() : n5 >= 0) {
                Screen screen = (Screen)screenList.get(n5).get();
                if (null == screen) {
                    screenList.remove(n5);
                    if (n4 >= 0) continue;
                    n5 += n4;
                    continue;
                }
                if (screen.getDisplay().equals(display) && screen.getIndex() == n2) {
                    return screen;
                }
                n5 += n4;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addScreen2List(Screen screen) {
        ArrayList<WeakReference<Screen>> arrayList = screenList;
        synchronized (arrayList) {
            int n2 = 0;
            while (n2 < screenList.size()) {
                if (null == screenList.get(n2).get()) {
                    screenList.remove(n2);
                    continue;
                }
                ++n2;
            }
            screenList.add(new WeakReference<Screen>(screen));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Screen> getAllScreens() {
        ArrayList<Screen> arrayList;
        ArrayList<WeakReference<Screen>> arrayList2 = screenList;
        synchronized (arrayList2) {
            arrayList = new ArrayList<Screen>();
            int n2 = 0;
            while (n2 < screenList.size()) {
                Screen screen = (Screen)screenList.get(n2).get();
                if (null == screen) {
                    screenList.remove(n2);
                    continue;
                }
                arrayList.add((Screen)screenList.get(n2).get());
                ++n2;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveScreenNumber() {
        ArrayList<WeakReference<Screen>> arrayList = screenList;
        synchronized (arrayList) {
            return screensActive;
        }
    }
}

