/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.SurfaceSize;
import com.jogamp.newt.MonitorMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MonitorModeUtil {
    public static int getIndex(List<MonitorMode> list, MonitorMode monitorMode) {
        return list.indexOf(monitorMode);
    }

    public static int getIndexByHashCode(List<MonitorMode> list, MonitorMode monitorMode) {
        if (null != list && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (monitorMode.hashCode() != list.get(i2).hashCode()) continue;
                return i2;
            }
        }
        return -1;
    }

    public static MonitorMode getByNativeSizeRateIdAndRotation(List<MonitorMode> list, MonitorMode.SizeAndRRate sizeAndRRate, int n2, int n3) {
        if (null != list && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                if (!monitorMode.getSizeAndRRate().equals(sizeAndRRate) || monitorMode.getId() != n2 || monitorMode.getRotation() != n3) continue;
                return monitorMode;
            }
        }
        return null;
    }

    public static void sort(List<MonitorMode> list, boolean bl) {
        if (bl) {
            Collections.sort(list);
        } else {
            Collections.sort(list, MonitorMode.monitorModeComparatorInv);
        }
    }

    public static List<MonitorMode> filterBySurfaceSize(List<MonitorMode> list, SurfaceSize surfaceSize) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                if (!monitorMode.getSurfaceSize().equals(surfaceSize)) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByRotation(List<MonitorMode> list, int n2) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                if (monitorMode.getRotation() != n2) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByBpp(List<MonitorMode> list, int n2) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                if (monitorMode.getSurfaceSize().getBitsPerPixel() != n2) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByFlags(List<MonitorMode> list, int n2) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                if (monitorMode.getFlags() != n2) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByResolution(List<MonitorMode> list, DimensionImmutable dimensionImmutable) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            int n2 = dimensionImmutable.getHeight() * dimensionImmutable.getWidth();
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                DimensionImmutable dimensionImmutable2 = monitorMode.getSurfaceSize().getResolution();
                int n5 = Math.abs(n2 - dimensionImmutable2.getHeight() * dimensionImmutable2.getWidth());
                if (n5 < n3) {
                    n3 = n5;
                    n4 = i2;
                }
                if (!dimensionImmutable2.equals(dimensionImmutable)) continue;
                arrayList.add(monitorMode);
            }
            if (arrayList.size() == 0 && 0 <= n4) {
                arrayList.add(list.get(n4));
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByRate(List<MonitorMode> list, float f2) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            float f3 = Float.MAX_VALUE;
            int n2 = -1;
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                float f4 = Math.abs(f2 - monitorMode.getRefreshRate());
                if (f4 < f3) {
                    f3 = f4;
                    n2 = i2;
                }
                if (0.0f != f4) continue;
                arrayList.add(monitorMode);
            }
            if (arrayList.size() == 0 && 0 <= n2) {
                arrayList.add(list.get(n2));
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> getHighestAvailableBpp(List<MonitorMode> list) {
        if (null != list && list.size() > 0) {
            int n2 = -1;
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                int n3 = monitorMode.getSurfaceSize().getBitsPerPixel();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            return MonitorModeUtil.filterByBpp(list, n2);
        }
        return new ArrayList<MonitorMode>();
    }

    public static List<MonitorMode> getHighestAvailableRate(List<MonitorMode> list) {
        if (null != list && list.size() > 0) {
            float f2 = -1.0f;
            for (int i2 = 0; null != list && i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                float f3 = monitorMode.getRefreshRate();
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            return MonitorModeUtil.filterByRate(list, f2);
        }
        return new ArrayList<MonitorMode>();
    }
}

