/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.util.GLDrawableUtil;
import java.util.ArrayList;
import jogamp.opengl.Debug;

public class GLEventListenerState {
    private static final boolean DEBUG = Debug.debug("GLDrawable") || Debug.debug("GLEventListenerState");
    public final AbstractGraphicsDevice upstreamDevice;
    public final boolean proxyOwnsUpstreamDevice;
    public final AbstractGraphicsDevice device;
    public final GLCapabilitiesImmutable caps;
    public final GLContext context;
    public final GLEventListener[] listeners;
    public final boolean[] listenersInit;
    public final GLAnimatorControl anim;
    public final boolean animStarted;
    private volatile RecursiveLock upstreamLock;
    private volatile NativeSurface lockedSurface;
    private volatile boolean owner;
    private final Runnable unlockOp = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLEventListenerState.this.upstreamLock;
            NativeSurface nativeSurface = GLEventListenerState.this.lockedSurface;
            GLEventListenerState.this.upstreamLock = null;
            GLEventListenerState.this.lockedSurface = null;
            if (null != recursiveLock) {
                recursiveLock.unlock();
            }
            if (null != nativeSurface) {
                nativeSurface.unlockSurface();
            }
        }
    };
    private static final GLRunnable setViewport = new GLRunnable(){

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            return true;
        }
    };
    private static final GLRunnable glFinish = new GLRunnable(){

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.getGL().glFinish();
            return true;
        }
    };

    private GLEventListenerState(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, AbstractGraphicsDevice abstractGraphicsDevice2, GLCapabilitiesImmutable gLCapabilitiesImmutable, RecursiveLock recursiveLock, NativeSurface nativeSurface, GLContext gLContext, int n2, GLAnimatorControl gLAnimatorControl, boolean bl2) {
        this.upstreamDevice = abstractGraphicsDevice;
        this.proxyOwnsUpstreamDevice = bl;
        this.device = abstractGraphicsDevice2;
        this.caps = gLCapabilitiesImmutable;
        this.upstreamLock = recursiveLock;
        this.lockedSurface = nativeSurface;
        this.context = gLContext;
        this.listeners = new GLEventListener[n2];
        this.listenersInit = new boolean[n2];
        this.anim = gLAnimatorControl;
        this.animStarted = bl2;
        this.owner = true;
    }

    public final boolean isOwner() {
        return this.owner;
    }

    public final int listenerCount() {
        return this.listeners.length;
    }

    public Runnable getUnlockSurfaceOp() {
        return this.unlockOp;
    }

    public void destroy() {
        if (this.owner) {
            int n2 = this.listenerCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.listeners[i2] = null;
            }
            this.unlockOp.run();
            this.device.close();
            this.owner = false;
        }
    }

    private static AbstractGraphicsDevice cloneDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (AbstractGraphicsDevice)abstractGraphicsDevice.clone();
    }

    public static GLEventListenerState moveFrom(GLAutoDrawable gLAutoDrawable) {
        return GLEventListenerState.moveFrom(gLAutoDrawable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLEventListenerState moveFrom(GLAutoDrawable gLAutoDrawable, boolean bl) {
        GLEventListenerState gLEventListenerState;
        boolean bl2;
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (null != gLAnimatorControl) {
            bl2 = gLAnimatorControl.isStarted();
            gLAnimatorControl.remove(gLAutoDrawable);
        } else {
            bl2 = false;
        }
        RecursiveLock recursiveLock = gLAutoDrawable.getUpstreamLock();
        recursiveLock.lock();
        try {
            boolean bl3;
            NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
            boolean bl4 = bl3 = 1 < nativeSurface.lockSurface();
            if (gLAutoDrawable.isRealized() && !bl3) {
                throw new GLException("Could not lock realized surface " + gLAutoDrawable);
            }
            try {
                boolean bl5;
                Object object;
                int n2 = gLAutoDrawable.getGLEventListenerCount();
                AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
                AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
                AbstractGraphicsDevice abstractGraphicsDevice2 = GLEventListenerState.cloneDevice(abstractGraphicsDevice);
                abstractGraphicsDevice.clearHandleOwner();
                if (DEBUG) {
                    System.err.println("GLEventListenerState.moveFrom.0a: orig 0x" + Integer.toHexString(abstractGraphicsDevice.hashCode()) + ", " + abstractGraphicsDevice);
                    System.err.println("GLEventListenerState.moveFrom.0b: pres 0x" + Integer.toHexString(abstractGraphicsDevice2.hashCode()) + ", " + abstractGraphicsDevice2);
                    System.err.println("GLEventListenerState.moveFrom.1: " + nativeSurface.getClass().getName());
                }
                AbstractGraphicsDevice abstractGraphicsDevice3 = null;
                if (nativeSurface instanceof ProxySurface) {
                    object = (ProxySurface)nativeSurface;
                    bl5 = object.containsUpstreamOptionBits(128);
                    NativeSurface nativeSurface2 = object.getUpstreamSurface();
                    if (DEBUG && null != nativeSurface2) {
                        System.err.println("GLEventListenerState.moveFrom.2: " + nativeSurface2.getClass().getName() + ", " + nativeSurface2);
                    }
                    if (null != nativeSurface2) {
                        AbstractGraphicsDevice abstractGraphicsDevice4 = nativeSurface2.getGraphicsConfiguration().getScreen().getDevice();
                        abstractGraphicsDevice3 = GLEventListenerState.cloneDevice(abstractGraphicsDevice4);
                        abstractGraphicsDevice4.clearHandleOwner();
                        if (DEBUG) {
                            System.err.println("GLEventListenerState.moveFrom.3a: up-orig 0x" + Integer.toHexString(abstractGraphicsDevice4.hashCode()) + ", " + abstractGraphicsDevice4);
                            System.err.println("GLEventListenerState.moveFrom.3b: up-pres 0x" + Integer.toHexString(abstractGraphicsDevice3.hashCode()) + ", " + abstractGraphicsDevice3);
                            System.err.println("GLEventListenerState.moveFrom.3c: " + nativeSurface.getClass().getName() + ", " + nativeSurface);
                            System.err.println("GLEventListenerState.moveFrom.3d: " + nativeSurface2.getClass().getName() + object.getUpstreamOptionBits(null).toString());
                        }
                    }
                } else {
                    bl5 = false;
                }
                AbstractGraphicsDevice abstractGraphicsDevice5 = abstractGraphicsDevice3;
                gLEventListenerState = new GLEventListenerState(abstractGraphicsDevice5, bl5, abstractGraphicsDevice2, gLCapabilitiesImmutable, bl ? recursiveLock : null, bl3 && bl ? nativeSurface : null, gLAutoDrawable.getContext(), n2, gLAnimatorControl, bl2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = gLAutoDrawable.getGLEventListener(0);
                    gLEventListenerState.listenersInit[i2] = gLAutoDrawable.getGLEventListenerInitState((GLEventListener)object);
                    gLEventListenerState.listeners[i2] = gLAutoDrawable.removeGLEventListener((GLEventListener)object);
                }
                gLAutoDrawable.setContext(null, false);
            }
            finally {
                if (bl3 && !bl) {
                    nativeSurface.unlockSurface();
                }
            }
        }
        finally {
            if (!bl) {
                recursiveLock.unlock();
            }
        }
        return gLEventListenerState;
    }

    public final void moveTo(GLAutoDrawable gLAutoDrawable) throws GLException {
        this.moveTo(gLAutoDrawable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void moveTo(GLAutoDrawable gLAutoDrawable, Runnable runnable) throws GLException {
        int n2;
        boolean bl;
        boolean bl2;
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (null != gLAnimatorControl) {
            bl2 = gLAnimatorControl.pause();
            gLAnimatorControl.remove(gLAutoDrawable);
        } else {
            bl2 = false;
        }
        ArrayList<GLRunnable> arrayList = new ArrayList<GLRunnable>();
        int n3 = this.listenerCount();
        RecursiveLock recursiveLock = gLAutoDrawable.getUpstreamLock();
        recursiveLock.lock();
        try {
            boolean bl3;
            NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
            boolean bl4 = bl3 = 1 < nativeSurface.lockSurface();
            if (gLAutoDrawable.isRealized() && !bl3) {
                throw new GLException("Could not lock realized surface " + gLAutoDrawable);
            }
            try {
                NativeSurface nativeSurface2;
                ProxySurface proxySurface;
                MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
                DefaultGraphicsDevice defaultGraphicsDevice = (DefaultGraphicsDevice)mutableGraphicsConfiguration.getScreen().getDevice();
                DefaultGraphicsDevice defaultGraphicsDevice2 = (DefaultGraphicsDevice)this.device;
                if (!defaultGraphicsDevice.getUniqueID().equals(defaultGraphicsDevice2.getUniqueID())) {
                    throw new GLException("Incompatible devices: Preserved <" + defaultGraphicsDevice2.getUniqueID() + ">, target <" + defaultGraphicsDevice.getUniqueID() + ">");
                }
                if (nativeSurface instanceof ProxySurface) {
                    proxySurface = (ProxySurface)nativeSurface;
                    nativeSurface2 = proxySurface.getUpstreamSurface();
                } else {
                    proxySurface = null;
                    nativeSurface2 = null;
                }
                if (DEBUG) {
                    System.err.println("GLEventListenerState.moveTo.0 : has aProxy " + (null != proxySurface));
                    System.err.println("GLEventListenerState.moveTo.0 : has aUpSurface " + (null != nativeSurface2));
                }
                if (null == nativeSurface2 && null != this.upstreamDevice) {
                    throw new GLException("Incompatible Surface config - Has Upstream-Surface: Prev-Holder = true, New-Holder = false");
                }
                gLAutoDrawable.setContext(null, true);
                bl = gLAutoDrawable.isRealized();
                if (bl && null != nativeSurface2) {
                    gLAutoDrawable.getDelegatedDrawable().setRealized(false);
                }
                if (DEBUG) {
                    System.err.println("GLEventListenerState.moveTo.0a: orig 0x" + Integer.toHexString(defaultGraphicsDevice.hashCode()) + ", " + defaultGraphicsDevice);
                    System.err.println("GLEventListenerState.moveTo.0b: pres 0x" + Integer.toHexString(defaultGraphicsDevice2.hashCode()) + ", " + defaultGraphicsDevice2);
                }
                DefaultGraphicsDevice.swapDeviceHandleAndOwnership(defaultGraphicsDevice, defaultGraphicsDevice2);
                defaultGraphicsDevice2.close();
                if (DEBUG) {
                    System.err.println("GLEventListenerState.moveTo.1a: orig 0x" + Integer.toHexString(defaultGraphicsDevice.hashCode()) + ", " + defaultGraphicsDevice);
                    System.err.println("GLEventListenerState.moveTo.1b: pres 0x" + Integer.toHexString(defaultGraphicsDevice2.hashCode()) + ", " + defaultGraphicsDevice2);
                }
                if (null != nativeSurface2) {
                    MutableGraphicsConfiguration mutableGraphicsConfiguration2 = (MutableGraphicsConfiguration)nativeSurface2.getGraphicsConfiguration();
                    if (null != this.upstreamDevice) {
                        DefaultGraphicsDevice defaultGraphicsDevice3 = (DefaultGraphicsDevice)mutableGraphicsConfiguration2.getScreen().getDevice();
                        DefaultGraphicsDevice defaultGraphicsDevice4 = (DefaultGraphicsDevice)this.upstreamDevice;
                        if (!defaultGraphicsDevice3.getUniqueID().equals(defaultGraphicsDevice4.getUniqueID())) {
                            throw new GLException("Incompatible updtream devices: Preserved <" + defaultGraphicsDevice4.getUniqueID() + ">, target <" + defaultGraphicsDevice3.getUniqueID() + ">");
                        }
                        if (DEBUG) {
                            System.err.println("GLEventListenerState.moveTo.2a: up-orig 0x" + Integer.toHexString(defaultGraphicsDevice3.hashCode()) + ", " + defaultGraphicsDevice3);
                            System.err.println("GLEventListenerState.moveTo.2b: up-pres 0x" + Integer.toHexString(defaultGraphicsDevice4.hashCode()) + ", " + defaultGraphicsDevice4);
                            System.err.println("GLEventListenerState.moveTo.2c:  " + nativeSurface2.getClass().getName() + proxySurface.getUpstreamOptionBits(null).toString());
                        }
                        DefaultGraphicsDevice.swapDeviceHandleAndOwnership(defaultGraphicsDevice3, defaultGraphicsDevice4);
                        defaultGraphicsDevice4.close();
                        if (this.proxyOwnsUpstreamDevice) {
                            proxySurface.addUpstreamOptionBits(128);
                        }
                        if (DEBUG) {
                            System.err.println("GLEventListenerState.moveTo.3a: up-orig 0x" + Integer.toHexString(defaultGraphicsDevice3.hashCode()) + ", " + defaultGraphicsDevice3);
                            System.err.println("GLEventListenerState.moveTo.3b: up-pres 0x" + Integer.toHexString(defaultGraphicsDevice4.hashCode()) + ", " + defaultGraphicsDevice4);
                            System.err.println("GLEventListenerState.moveTo.3c:  " + nativeSurface2.getClass().getName() + proxySurface.getUpstreamOptionBits(null).toString());
                        }
                    } else {
                        throw new GLException("Incompatible Surface config - Has Upstream-Surface: Prev-Holder = false, New-Holder = true");
                    }
                }
                if (bl && null != nativeSurface2) {
                    gLAutoDrawable.getDelegatedDrawable().setRealized(true);
                }
                if (DEBUG) {
                    System.err.println("GLEventListenerState.moveTo.X : has aProxy " + (null != proxySurface));
                    System.err.println("GLEventListenerState.moveTo.X : has aUpSurface " + (null != nativeSurface2));
                }
                gLAutoDrawable.setContext(this.context, false);
            }
            finally {
                if (bl3) {
                    nativeSurface.unlockSurface();
                }
            }
        }
        finally {
            recursiveLock.unlock();
        }
        if (null != runnable) {
            runnable.run();
        }
        this.owner = false;
        arrayList.add(setViewport);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.listenersInit[n2]) continue;
            arrayList.add(new GLDrawableUtil.ReshapeGLEventListener(this.listeners[n2], false));
        }
        arrayList.add(glFinish);
        gLAutoDrawable.invoke(bl, arrayList);
        for (n2 = 0; n2 < n3; ++n2) {
            GLEventListener gLEventListener = this.listeners[n2];
            gLAutoDrawable.addGLEventListener(gLEventListener);
            gLAutoDrawable.setGLEventListenerInitState(gLEventListener, this.listenersInit[n2]);
            this.listeners[n2] = null;
        }
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add(gLAutoDrawable);
            if (bl2) {
                gLAnimatorControl.resume();
            }
        } else if (null != this.anim) {
            this.anim.add(gLAutoDrawable);
            if (this.animStarted) {
                this.anim.start();
            }
        }
    }
}

