/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import java.util.IdentityHashMap;

public class GLRendererQuirks {
    public static final int NoDoubleBufferedPBuffer = 0;
    public static final int NoDoubleBufferedBitmap = 1;
    public static final int NoSetSwapInterval = 2;
    public static final int NoOffscreenBitmap = 3;
    public static final int NoSetSwapIntervalPostRetarget = 4;
    public static final int GLSLBuggyDiscard = 5;
    public static final int GLNonCompliant = 6;
    public static final int GLFlushBeforeRelease = 7;
    public static final int DontCloseX11Display = 8;
    public static final int NeedCurrCtx4ARBPixFmtQueries = 9;
    public static final int NeedCurrCtx4ARBCreateContext = 10;
    public static final int NoFullFBOSupport = 11;
    public static final int GLSLNonCompliant = 12;
    public static final int GL4NeedsGL3Request = 13;
    public static final int GLSharedContextBuggy = 14;
    public static final int GLES3ViaEGLES2Config = 15;
    public static final int SingletonEGLDisplayOnly = 16;
    public static final int NoMultiSamplingBuffers = 17;
    public static final int BuggyColorRenderbuffer = 18;
    public static final int NoPBufferWithAccum = 19;
    public static final int NeedSharedObjectSync = 20;
    public static final int NoARBCreateContext = 21;
    public static final int NoSurfacelessCtx = 22;
    private static final String[] _names = new String[]{"NoDoubleBufferedPBuffer", "NoDoubleBufferedBitmap", "NoSetSwapInterval", "NoOffscreenBitmap", "NoSetSwapIntervalPostRetarget", "GLSLBuggyDiscard", "GLNonCompliant", "GLFlushBeforeRelease", "DontCloseX11Display", "NeedCurrCtx4ARBPixFmtQueries", "NeedCurrCtx4ARBCreateContext", "NoFullFBOSupport", "GLSLNonCompliant", "GL4NeedsGL3Request", "GLSharedContextBuggy", "GLES3ViaEGLES2Config", "SingletonEGLDisplayOnly", "NoMultiSamplingBuffers", "BuggyColorRenderbuffer", "NoPBufferWithAccum", "NeedSharedObjectSync", "NoARBCreateContext", "NoSurfacelessCtx"};
    private static final IdentityHashMap<String, GLRendererQuirks> stickyDeviceQuirks = new IdentityHashMap();
    private int _bitmask = 0;

    public static final int getCount() {
        return 23;
    }

    public static GLRendererQuirks getStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLRendererQuirks gLRendererQuirks;
        String string = abstractGraphicsDevice.getUniqueID();
        GLRendererQuirks gLRendererQuirks2 = stickyDeviceQuirks.get(string);
        if (null == gLRendererQuirks2) {
            gLRendererQuirks = new GLRendererQuirks();
            stickyDeviceQuirks.put(string, gLRendererQuirks);
        } else {
            gLRendererQuirks = gLRendererQuirks2;
        }
        return gLRendererQuirks;
    }

    public static boolean areSameStickyDevice(AbstractGraphicsDevice abstractGraphicsDevice, AbstractGraphicsDevice abstractGraphicsDevice2) {
        return abstractGraphicsDevice.getUniqueID() == abstractGraphicsDevice2.getUniqueID();
    }

    public static void addStickyDeviceQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n2) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks.addQuirk(n2);
    }

    public static void addStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, int[] nArray, int n2, int n3) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks.addQuirks(nArray, n2, n3);
    }

    public static void addStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks) throws IllegalArgumentException {
        GLRendererQuirks gLRendererQuirks2 = GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice);
        gLRendererQuirks2.addQuirks(gLRendererQuirks);
    }

    public static boolean existStickyDeviceQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n2) {
        return GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice).exist(n2);
    }

    public static void pushStickyDeviceQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks) {
        gLRendererQuirks.addQuirks(GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice));
    }

    public GLRendererQuirks() {
    }

    public GLRendererQuirks(int[] nArray, int n2, int n3) throws IllegalArgumentException {
        this();
        this.addQuirks(nArray, n2, n3);
    }

    public final void addQuirk(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        this._bitmask |= 1 << n2;
    }

    public final void addQuirks(int[] nArray, int n2, int n3) throws IllegalArgumentException {
        int n4 = 0;
        if (0 > n2 + n3 || n2 + n3 > nArray.length) {
            throw new IllegalArgumentException("offset and len out of bounds: offset " + n2 + ", len " + n3 + ", array-len " + nArray.length);
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            int n5 = nArray[i2];
            GLRendererQuirks.validateQuirk(n5);
            n4 |= 1 << n5;
        }
        this._bitmask |= n4;
    }

    public final void addQuirks(GLRendererQuirks gLRendererQuirks) {
        this._bitmask |= gLRendererQuirks._bitmask;
    }

    public final boolean exist(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        return 0 != (1 << n2 & this._bitmask);
    }

    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        boolean bl = true;
        for (int i2 = 0; i2 < GLRendererQuirks.getCount(); ++i2) {
            int n2 = 1 << i2;
            if (0 == (this._bitmask & n2)) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(GLRendererQuirks.toString(i2));
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public final String toString() {
        return this.toString(null).toString();
    }

    public static void validateQuirk(int n2) throws IllegalArgumentException {
        if (0 > n2 || n2 >= GLRendererQuirks.getCount()) {
            throw new IllegalArgumentException("Quirks must be in range [0.." + GLRendererQuirks.getCount() + "[, but quirk: " + n2);
        }
    }

    public static final String toString(int n2) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n2);
        return _names[n2];
    }
}

