/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl.sdk;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.glsl.ShaderCode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public abstract class CompileShader {
    public abstract int getBinaryFormat();

    public abstract File getSDKCompilerDir();

    public abstract String getVertexShaderCompiler();

    public abstract String getFragmentShaderCompiler();

    public void processOneShader(String string) throws IOException, UnsupportedEncodingException, InterruptedException {
        int n2 = -1;
        String string2 = null;
        int n3 = -1;
        if (string.endsWith(ShaderCode.getFileSuffix(false, 35632))) {
            n3 = 2;
            n2 = 35632;
        } else if (string.endsWith(".frag")) {
            n3 = 4;
            n2 = 35632;
        } else if (string.endsWith(ShaderCode.getFileSuffix(false, 35633))) {
            n3 = 2;
            n2 = 35633;
        } else if (string.endsWith(".vert")) {
            n3 = 4;
            n2 = 35633;
        }
        String string3 = CompileShader.basename(string);
        string2 = string3.substring(0, string3.length() - n3) + ShaderCode.getFileSuffix(true, n2);
        URL uRL = IOUtil.getResource(null, string).getURL();
        String string4 = CompileShader.dirname(uRL.getPath());
        string2 = string4 + File.separator + "bin" + File.separator + ShaderCode.getBinarySubPath(this.getBinaryFormat()) + File.separator + string2;
        this.processOneShader(string, string2, n2);
    }

    public void processOneShader(String string, String string2, int n2) throws IOException, UnsupportedEncodingException, InterruptedException {
        String string3;
        URL uRL = IOUtil.getResource(null, string).getURL();
        String string4 = CompileShader.dirname(uRL.getPath());
        CharSequence charSequence = ShaderCode.readShaderSource(null, string, false);
        if (null == charSequence) {
            System.err.println("Can't find shader source " + string + " - ignored");
            return;
        }
        System.err.println("Preprocessing: " + string + ", in dir: " + string4);
        String string5 = CompileShader.basename(string);
        switch (n2) {
            case 35633: {
                string3 = this.getVertexShaderCompiler();
                break;
            }
            case 35632: {
                string3 = this.getFragmentShaderCompiler();
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n2);
            }
        }
        File file = new File(string2);
        File file2 = new File(string4 + File.separator + "tmp");
        file2.mkdirs();
        File file3 = new File(file2, string5);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
        ((Writer)bufferedWriter).write(charSequence.toString(), 0, charSequence.length());
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        System.err.println("Preprocessed: " + file3.getAbsolutePath());
        File file4 = this.getSDKCompilerDir();
        System.err.println("SDK: " + file4.getAbsolutePath() + ", compiler: " + string3);
        System.err.println("Output: " + file.getAbsolutePath());
        Process process = Runtime.getRuntime().exec(new String[]{file4.getAbsolutePath() + File.separator + string3, file3.getAbsolutePath(), file.getAbsolutePath()});
        new IOUtil.StreamMonitor(new InputStream[]{process.getInputStream(), process.getErrorStream()}, System.out, null);
        process.waitFor();
    }

    protected static String basename(String string) {
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            n2 = string.lastIndexOf("\\");
        }
        String string2 = n2 < 0 ? string : string.substring(n2 + 1);
        return string2;
    }

    protected static String dirname(String string) {
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            n2 = string.lastIndexOf("\\");
        }
        String string2 = n2 < 0 ? "" : string.substring(0, n2 + 1);
        return string2;
    }

    public void run(String[] stringArray) {
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.processOneShader(stringArray[i2]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

