/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoGLEventListener;
import jogamp.opengl.GLDrawableHelper;

public class StereoClientRenderer
implements GLEventListener {
    private final GLDrawableHelper helper;
    private final StereoDeviceRenderer deviceRenderer;
    private final boolean ownsDevice;
    private final FBObject[] fbos;
    private final int magFilter;
    private final int minFilter;
    private int numSamples;
    private final FBObject.TextureAttachment[] fboTexs;

    public StereoClientRenderer(StereoDeviceRenderer stereoDeviceRenderer, boolean bl, int n2, int n3, int n4) {
        int n5 = stereoDeviceRenderer.getTextureCount();
        if (0 > n5 || 2 < n5) {
            throw new IllegalArgumentException("fboCount must be within [0..2], has " + n5 + ", due to " + stereoDeviceRenderer);
        }
        this.helper = new GLDrawableHelper();
        this.deviceRenderer = stereoDeviceRenderer;
        this.ownsDevice = bl;
        this.magFilter = n2;
        this.minFilter = n3;
        this.numSamples = n4;
        this.fbos = new FBObject[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            this.fbos[i2] = new FBObject();
        }
        this.fboTexs = new FBObject.TextureAttachment[n5];
    }

    private void initFBOs(GL gL, DimensionImmutable[] dimensionImmutableArray) {
        for (int i2 = 0; i2 < this.fbos.length; ++i2) {
            this.fbos[i2].init(gL, dimensionImmutableArray[i2].getWidth(), dimensionImmutableArray[i2].getHeight(), this.numSamples);
            if (i2 > 0 && this.fbos[i2 - 1].getNumSamples() != this.fbos[i2].getNumSamples()) {
                throw new InternalError("sample size mismatch: \n\t0: " + this.fbos[i2 - 1] + "\n\t1: " + this.fbos[i2]);
            }
            this.numSamples = this.fbos[i2].getNumSamples();
            if (this.numSamples > 0) {
                this.fbos[i2].attachColorbuffer(gL, 0, true);
                this.fbos[i2].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 0);
                FBObject fBObject = new FBObject();
                fBObject.init(gL, dimensionImmutableArray[i2].getWidth(), dimensionImmutableArray[i2].getHeight(), 0);
                fBObject.attachTexture2D(gL, 0, false, this.magFilter, this.minFilter, 33071, 33071);
                fBObject.attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 0);
                this.fbos[i2].setSamplingSink(fBObject);
                this.fbos[i2].resetSamplingSink(gL);
                this.fboTexs[i2] = this.fbos[i2].getSamplingSink().getTextureAttachment();
            } else {
                this.fboTexs[i2] = this.fbos[i2].attachTexture2D(gL, 0, false, this.magFilter, this.minFilter, 33071, 33071);
                this.fbos[i2].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 0);
            }
            this.fbos[i2].unbind(gL);
            System.err.println("FBO[" + i2 + "]: " + this.fbos[i2]);
        }
    }

    private void resetFBOs(GL gL, DimensionImmutable dimensionImmutable) {
        for (int i2 = 0; i2 < this.fbos.length; ++i2) {
            this.fbos[i2].reset(gL, dimensionImmutable.getWidth(), dimensionImmutable.getHeight(), this.numSamples);
            if (i2 > 0 && this.fbos[i2 - 1].getNumSamples() != this.fbos[i2].getNumSamples()) {
                throw new InternalError("sample size mismatch: \n\t0: " + this.fbos[i2 - 1] + "\n\t1: " + this.fbos[i2]);
            }
            this.numSamples = this.fbos[i2].getNumSamples();
            this.fboTexs[i2] = this.numSamples > 0 ? this.fbos[i2].getSamplingSink().getTextureAttachment() : this.fbos[i2].getColorbuffer(0).getTextureAttachment();
        }
    }

    public final StereoDeviceRenderer getStereoDeviceRenderer() {
        return this.deviceRenderer;
    }

    public final void addGLEventListener(StereoGLEventListener stereoGLEventListener) {
        this.helper.addGLEventListener(stereoGLEventListener);
    }

    public final void removeGLEventListener(StereoGLEventListener stereoGLEventListener) {
        this.helper.removeGLEventListener(stereoGLEventListener);
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        DimensionImmutable[] dimensionImmutableArray;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.deviceRenderer.init(gL2ES2);
        if (this.deviceRenderer.getTextureCount() > 1) {
            dimensionImmutableArray = this.deviceRenderer.getEyeSurfaceSize();
        } else {
            DimensionImmutable[] dimensionImmutableArray2 = new DimensionImmutable[1];
            dimensionImmutableArray = dimensionImmutableArray2;
            dimensionImmutableArray2[0] = this.deviceRenderer.getTotalSurfaceSize();
        }
        DimensionImmutable[] dimensionImmutableArray3 = dimensionImmutableArray;
        this.initFBOs(gL2ES2, dimensionImmutableArray3);
        this.helper.init(gLAutoDrawable, false);
        gL2ES2.setSwapInterval(1);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.helper.disposeAllGLEventListener(gLAutoDrawable, false);
        for (int i2 = 0; i2 < this.fbos.length; ++i2) {
            this.fbos[i2].destroy(gL2ES2);
            this.fboTexs[i2] = null;
        }
        if (this.ownsDevice) {
            this.deviceRenderer.dispose(gL2ES2);
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        int n2;
        int n3;
        int n4;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.deviceRenderer.beginFrame(gL2ES2);
        if (0 < this.numSamples) {
            gL2ES2.glEnable(32925);
        }
        int n5 = 1 >= (n4 = this.fbos.length) ? 2 : 0;
        int[] nArray = this.deviceRenderer.getDevice().getEyeRenderOrder();
        int n6 = nArray.length;
        for (n3 = 0; n3 < n6; ++n3) {
            this.deviceRenderer.updateEyePose(n3);
        }
        if (1 == n4) {
            this.fbos[0].bind(gL2ES2);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = nArray[n3];
            if (1 < n4) {
                this.fbos[n2].bind(gL2ES2);
            }
            final StereoDeviceRenderer.Eye eye = this.deviceRenderer.getEye(n2);
            final RectangleImmutable rectangleImmutable = eye.getViewport();
            gL2ES2.glViewport(rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getWidth(), rectangleImmutable.getHeight());
            final int n7 = n3 > 0 ? 1 | n5 : 0;
            GLDrawableHelper.GLEventListenerAction gLEventListenerAction = new GLDrawableHelper.GLEventListenerAction(){

                @Override
                public void run(GLAutoDrawable gLAutoDrawable, GLEventListener gLEventListener) {
                    StereoGLEventListener stereoGLEventListener = (StereoGLEventListener)gLEventListener;
                    stereoGLEventListener.reshapeForEye(gLAutoDrawable, rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getWidth(), rectangleImmutable.getHeight(), eye.getEyeParameter(), eye.getLastEyePose());
                    stereoGLEventListener.display(gLAutoDrawable, n7);
                }
            };
            this.helper.runForAllGLEventListener(gLAutoDrawable, gLEventListenerAction);
            if (1 >= n4) continue;
            this.fbos[n2].unbind(gL2ES2);
        }
        if (1 == n4) {
            this.fbos[0].unbind(gL2ES2);
        }
        gL2ES2.glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        if (this.deviceRenderer.ppAvailable()) {
            this.deviceRenderer.ppBegin(gL2ES2);
            if (1 == n4) {
                this.fbos[0].use(gL2ES2, this.fboTexs[0]);
                for (n3 = 0; n3 < n6; ++n3) {
                    this.deviceRenderer.ppOneEye(gL2ES2, nArray[n3]);
                }
                this.fbos[0].unuse(gL2ES2);
            } else {
                for (n3 = 0; n3 < n6; ++n3) {
                    n2 = nArray[n3];
                    this.fbos[n2].use(gL2ES2, this.fboTexs[n2]);
                    this.deviceRenderer.ppOneEye(gL2ES2, n2);
                    this.fbos[n2].unuse(gL2ES2);
                }
            }
            this.deviceRenderer.ppEnd(gL2ES2);
        }
        if (!gLAutoDrawable.getAutoSwapBufferMode()) {
            gLAutoDrawable.swapBuffers();
        }
        this.deviceRenderer.endFrame(gL2ES2);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n2, int n3, int n4, int n5) {
        if (!gLAutoDrawable.getAutoSwapBufferMode()) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glViewport(0, 0, n4, n5);
        }
    }
}

