/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo.generic;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDeviceConfig;
import com.jogamp.opengl.util.stereo.StereoUtil;
import java.util.Arrays;
import jogamp.opengl.util.stereo.DistortionMesh;

public class GenericStereoDeviceConfig
extends StereoDeviceConfig {
    public final String name;
    public final ShutterType shutterType;
    public final DimensionImmutable surfaceSizeInPixels;
    public final float[] screenSizeInMeters;
    public final DimensionImmutable[] eyeTextureSizes;
    public final float pupilCenterFromScreenTopInMeters;
    public final float interpupillaryDistanceInMeters;
    public final float[][] pupilCenterFromTopLeft;
    public final int[] eyeRenderOrder;
    public final EyeParameter[] defaultEyeParam;
    public final DistortionMesh.Producer distortionMeshProducer;
    public final int supportedDistortionBits;
    public final int recommendedDistortionBits;
    public final int minimumDistortionBits;
    private boolean isInitialized = false;

    public GenericStereoDeviceConfig(String string, ShutterType shutterType, DimensionImmutable dimensionImmutable, float[] fArray, DimensionImmutable[] dimensionImmutableArray, float f2, float f3, int[] nArray, EyeParameter[] eyeParameterArray, DistortionMesh.Producer producer, int n2, int n3, int n4) {
        if (nArray.length != eyeParameterArray.length) {
            throw new IllegalArgumentException("eye arrays of different length");
        }
        this.name = string;
        this.shutterType = shutterType;
        this.surfaceSizeInPixels = dimensionImmutable;
        this.screenSizeInMeters = fArray;
        this.eyeTextureSizes = dimensionImmutableArray;
        this.pupilCenterFromScreenTopInMeters = f2;
        this.interpupillaryDistanceInMeters = f3;
        this.eyeRenderOrder = nArray;
        this.defaultEyeParam = eyeParameterArray;
        this.distortionMeshProducer = producer;
        this.supportedDistortionBits = n2;
        this.recommendedDistortionBits = n3;
        this.minimumDistortionBits = n4;
        this.pupilCenterFromTopLeft = new float[2][2];
        this.calcPupilCenterFromTopLeft();
    }

    public GenericStereoDeviceConfig(GenericStereoDeviceConfig genericStereoDeviceConfig, DimensionImmutable dimensionImmutable, float[] fArray, DimensionImmutable[] dimensionImmutableArray) {
        this.name = genericStereoDeviceConfig.name;
        this.shutterType = genericStereoDeviceConfig.shutterType;
        this.surfaceSizeInPixels = dimensionImmutable;
        this.screenSizeInMeters = fArray;
        this.eyeTextureSizes = dimensionImmutableArray;
        this.pupilCenterFromScreenTopInMeters = genericStereoDeviceConfig.pupilCenterFromScreenTopInMeters;
        this.interpupillaryDistanceInMeters = genericStereoDeviceConfig.interpupillaryDistanceInMeters;
        this.eyeRenderOrder = genericStereoDeviceConfig.eyeRenderOrder;
        this.defaultEyeParam = genericStereoDeviceConfig.defaultEyeParam;
        this.distortionMeshProducer = genericStereoDeviceConfig.distortionMeshProducer;
        this.supportedDistortionBits = genericStereoDeviceConfig.supportedDistortionBits;
        this.recommendedDistortionBits = genericStereoDeviceConfig.recommendedDistortionBits;
        this.minimumDistortionBits = genericStereoDeviceConfig.minimumDistortionBits;
        this.pupilCenterFromTopLeft = new float[2][2];
        this.calcPupilCenterFromTopLeft();
    }

    private void calcPupilCenterFromTopLeft() {
        float f2 = 0.5f * this.screenSizeInMeters[0];
        float f3 = (this.screenSizeInMeters[0] - this.interpupillaryDistanceInMeters) * 0.5f;
        float f4 = f3 + this.interpupillaryDistanceInMeters - f2;
        this.pupilCenterFromTopLeft[0][0] = f3 / f2;
        this.pupilCenterFromTopLeft[0][1] = this.pupilCenterFromScreenTopInMeters / this.screenSizeInMeters[1];
        this.pupilCenterFromTopLeft[1][0] = f4 / f2;
        this.pupilCenterFromTopLeft[1][1] = this.pupilCenterFromTopLeft[0][1];
    }

    public synchronized void init() {
        if (!this.isInitialized) {
            if (null != this.distortionMeshProducer) {
                float[] fArray = new float[this.defaultEyeParam.length];
                if (0 < this.defaultEyeParam.length) {
                    fArray[0] = this.defaultEyeParam[0].eyeReliefZ;
                }
                if (1 < this.defaultEyeParam.length) {
                    fArray[1] = this.defaultEyeParam[1].eyeReliefZ;
                }
                this.distortionMeshProducer.init(this, fArray);
            }
            this.isInitialized = true;
        }
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public String toString() {
        return "StereoConfig[" + this.name + ", shutter " + (Object)((Object)this.shutterType) + ", surfaceSize " + this.surfaceSizeInPixels + ", screenSize " + this.screenSizeInMeters[0] + " x " + this.screenSizeInMeters[0] + " [m], eyeTexSize " + Arrays.toString(this.eyeTextureSizes) + ", IPD " + this.interpupillaryDistanceInMeters + " [m], eyeParam " + Arrays.toString(this.defaultEyeParam) + ", distortionBits[supported [" + StereoUtil.distortionBitsToString(this.supportedDistortionBits) + "], recommended [" + StereoUtil.distortionBitsToString(this.recommendedDistortionBits) + "], minimum [" + StereoUtil.distortionBitsToString(this.minimumDistortionBits) + "]]]";
    }

    public static enum ShutterType {
        Global,
        RollingLeftToRight,
        RollingRightToLeft,
        RollingTopToBottom;

    }
}

