/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.TextureWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class NetPbmTextureWriter
implements TextureWriter {
    int magic;
    public static final String PPM = "ppm";
    public static final String PAM = "pam";

    public NetPbmTextureWriter() {
        this(0);
    }

    public NetPbmTextureWriter(int n2) {
        switch (n2) {
            case 0: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new GLException("Unsupported magic: " + n2 + ", should be 0 (auto), 6 (PPM) or 7 (PAM)");
            }
        }
        this.magic = n2;
    }

    public int getMagic() {
        return this.magic;
    }

    public String getSuffix() {
        return this.magic == 6 ? PPM : PAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(File file, TextureData textureData) throws IOException {
        boolean bl;
        int n2 = this.magic;
        if (0 == this.magic) {
            if (PPM.equals(IOUtil.getFileSuffix(file))) {
                this.magic = 6;
            } else if (PAM.equals(IOUtil.getFileSuffix(file))) {
                this.magic = 7;
            } else {
                return false;
            }
        }
        try {
            bl = this.writeImpl(file, textureData);
        }
        finally {
            this.magic = n2;
        }
        return bl;
    }

    private boolean writeImpl(File file, TextureData textureData) throws IOException {
        int n2 = textureData.getPixelFormat();
        int n3 = textureData.getPixelType();
        if (!(n2 != 6407 && n2 != 6408 && n2 != 32992 && n2 != 32993 || n3 != 5120 && n3 != 5121)) {
            int n4;
            ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
            if (null == byteBuffer) {
                byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
            }
            byteBuffer.rewind();
            int n5 = n4 = n2 == 6408 || n2 == 32993 ? 4 : 3;
            if (n2 == 32992 || n2 == 32993) {
                for (int i2 = 0; i2 < byteBuffer.remaining(); i2 += n4) {
                    byte by = byteBuffer.get(i2 + 0);
                    byte by2 = byteBuffer.get(i2 + 2);
                    byteBuffer.put(i2 + 0, by2);
                    byteBuffer.put(i2 + 2, by);
                }
                n2 = 4 == n4 ? 6408 : 6407;
                textureData.setPixelFormat(n2);
            }
            if (this.magic == 6 && n4 == 4) {
                throw new IOException("NetPbmTextureWriter magic 6 (PPM) doesn't RGBA pixel format, use magic 7 (PAM)");
            }
            FileOutputStream fileOutputStream = IOUtil.getFileOutputStream(file, true);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("P");
            stringBuilder.append(this.magic);
            stringBuilder.append("\n");
            if (7 == this.magic) {
                stringBuilder.append("WIDTH ");
            }
            stringBuilder.append(textureData.getWidth());
            if (7 == this.magic) {
                stringBuilder.append("\nHEIGHT ");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(textureData.getHeight());
            if (7 == this.magic) {
                stringBuilder.append("\nDEPTH ");
                stringBuilder.append(n4);
                stringBuilder.append("\nMAXVAL 255\nTUPLTYPE ");
                if (n2 == 6408) {
                    stringBuilder.append("RGB_ALPHA");
                } else {
                    stringBuilder.append("RGB");
                }
                stringBuilder.append("\nENDHDR\n");
            } else {
                stringBuilder.append("\n255\n");
            }
            fileOutputStream.write(stringBuilder.toString().getBytes());
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            fileChannel.close();
            fileOutputStream.close();
            byteBuffer.rewind();
            return true;
        }
        throw new IOException("NetPbmTextureWriter writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
    }
}

