/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi.awt;

import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureData;
import com.jogamp.opengl.util.texture.spi.TextureProvider;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import jogamp.opengl.Debug;

public class IIOTextureProvider
implements TextureProvider {
    private static final boolean DEBUG = Debug.debug("TextureIO");

    @Override
    public TextureData newTextureData(GLProfile gLProfile, File file, int n2, int n3, boolean bl, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("TextureIO.newTextureData(): BufferedImage type for " + file + " = " + bufferedImage.getType());
        }
        return new AWTTextureData(gLProfile, n2, n3, bl, bufferedImage);
    }

    @Override
    public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("TextureIO.newTextureData(): BufferedImage type for stream = " + bufferedImage.getType());
        }
        return new AWTTextureData(gLProfile, n2, n3, bl, bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextureData newTextureData(GLProfile gLProfile, URL uRL, int n2, int n3, boolean bl, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            TextureData textureData = this.newTextureData(gLProfile, inputStream, n2, n3, bl, string);
            return textureData;
        }
        finally {
            inputStream.close();
        }
    }
}

