/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTCPAPPPacket;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPRawReceiver;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketForwarder;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ApplicationEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.SenderReport;

public class RTCPReceiver
implements PacketConsumer {
    private static final int SR = 1;
    private static final int RR = 2;
    private boolean rtcpstarted = false;
    private boolean sentrecvstrmap = false;
    SSRCCache cache;
    private int type = 0;

    public RTCPReceiver(SSRCCache cache) {
        this.cache = cache;
        SSRCInfo sSRCInfo = cache.lookup(cache.ourssrc.ssrc);
    }

    public RTCPReceiver(SSRCCache cache, PacketSource source) {
        this(cache);
        PacketForwarder f2 = new PacketForwarder(source, this);
        f2.startPF();
    }

    public RTCPReceiver(SSRCCache cache, DatagramSocket sock, StreamSynch streamSynch) {
        this(cache, new RTCPRawReceiver(sock, cache.sm.defaultstats, streamSynch));
    }

    public RTCPReceiver(SSRCCache cache, int port, String address, StreamSynch streamSynch) throws UnknownHostException, IOException {
        this(cache, new RTCPRawReceiver(port | 1, address, cache.sm.defaultstats, streamSynch));
    }

    public String consumerString() {
        return "RTCP Packet Receiver/Collector";
    }

    public void closeConsumer() {
    }

    public void sendTo(Packet p) {
        this.sendTo((RTCPPacket)p);
    }

    public void sendTo(RTCPPacket p) {
        SSRCInfo info = null;
        boolean unicast = this.cache.sm.isUnicast();
        if (unicast) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)p.base).remoteAddress);
                this.rtcpstarted = true;
                byte[] lsb = this.cache.sm.controladdress.getAddress();
                int address = lsb[3] & 0xFF;
                if ((address & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    InetAddress localaddr = null;
                    boolean localfound = true;
                    try {
                        localaddr = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e2) {
                        localfound = false;
                    }
                    if (localfound) {
                        this.cache.sm.addUnicastAddr(localaddr);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)p.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)p.base).remoteAddress);
            }
        }
        switch (p.type) {
            case -1: {
                RTCPCompoundPacket cp = (RTCPCompoundPacket)p;
                this.cache.updateavgrtcpsize(cp.length);
                int i2 = 0;
                while (i2 < cp.packets.length) {
                    this.sendTo(cp.packets[i2]);
                    ++i2;
                }
                if (this.cache.sm.cleaner == null) break;
                this.cache.sm.cleaner.setClean();
                break;
            }
            case 200: {
                RTCPSRPacket srp = (RTCPSRPacket)p;
                this.type = 1;
                info = p.base instanceof UDPPacket ? this.cache.get(srp.ssrc, ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort, 1) : this.cache.get(srp.ssrc, null, 0, 1);
                if (info == null) break;
                info.setAlive(true);
                info.lastSRntptimestamp = (srp.ntptimestampmsw << 32) + srp.ntptimestamplsw;
                info.lastSRrtptimestamp = srp.rtptimestamp;
                info.lastSRreceiptTime = srp.receiptTime;
                info.lastRTCPreceiptTime = srp.receiptTime;
                info.lastHeardFrom = srp.receiptTime;
                if (info.quiet) {
                    info.quiet = false;
                    ActiveReceiveStreamEvent event2 = null;
                    event2 = info instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, null);
                    this.cache.eventhandler.postEvent(event2);
                }
                info.lastSRpacketcount = srp.packetcount;
                info.lastSRoctetcount = srp.octetcount;
                int i3 = 0;
                while (i3 < srp.reports.length) {
                    srp.reports[i3].receiptTime = srp.receiptTime;
                    int rbssrc = srp.reports[i3].ssrc;
                    RTCPReportBlock[] reporta = (RTCPReportBlock[])info.reports.get(rbssrc);
                    if (reporta == null) {
                        reporta = new RTCPReportBlock[2];
                        reporta[0] = srp.reports[i3];
                        info.reports.put(rbssrc, reporta);
                    } else {
                        reporta[1] = reporta[0];
                        reporta[0] = srp.reports[i3];
                    }
                    ++i3;
                }
                if (info.probation > 0) break;
                if (!info.newpartsent && info.sourceInfo != null) {
                    NewParticipantEvent evtsdes = new NewParticipantEvent(this.cache.sm, info.sourceInfo);
                    this.cache.eventhandler.postEvent(evtsdes);
                    info.newpartsent = true;
                }
                if (!info.recvstrmap && info.sourceInfo != null) {
                    info.recvstrmap = true;
                    StreamMappedEvent evt = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)info), info.sourceInfo);
                    this.cache.eventhandler.postEvent(evt);
                }
                SenderReportEvent evtsr = new SenderReportEvent(this.cache.sm, (SenderReport)((Object)info));
                this.cache.eventhandler.postEvent(evtsr);
                break;
            }
            case 201: {
                RTCPRRPacket rrp = (RTCPRRPacket)p;
                this.type = 2;
                info = p.base instanceof UDPPacket ? this.cache.get(rrp.ssrc, ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort, 2) : this.cache.get(rrp.ssrc, null, 0, 2);
                if (info == null) break;
                info.setAlive(true);
                info.lastRTCPreceiptTime = rrp.receiptTime;
                info.lastHeardFrom = rrp.receiptTime;
                if (info.quiet) {
                    info.quiet = false;
                    ActiveReceiveStreamEvent event3 = null;
                    event3 = info instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, null);
                    this.cache.eventhandler.postEvent(event3);
                }
                int i4 = 0;
                while (i4 < rrp.reports.length) {
                    rrp.reports[i4].receiptTime = rrp.receiptTime;
                    int rbssrc = rrp.reports[i4].ssrc;
                    RTCPReportBlock[] reporta = (RTCPReportBlock[])info.reports.get(rbssrc);
                    if (reporta == null) {
                        reporta = new RTCPReportBlock[2];
                        reporta[0] = rrp.reports[i4];
                        info.reports.put(rbssrc, reporta);
                    } else {
                        reporta[1] = reporta[0];
                        reporta[0] = rrp.reports[i4];
                    }
                    ++i4;
                }
                if (!info.newpartsent && info.sourceInfo != null) {
                    NewParticipantEvent evtsdes = new NewParticipantEvent(this.cache.sm, info.sourceInfo);
                    this.cache.eventhandler.postEvent(evtsdes);
                    info.newpartsent = true;
                }
                ReceiverReportEvent evt = new ReceiverReportEvent(this.cache.sm, (ReceiverReport)((Object)info));
                this.cache.eventhandler.postEvent(evt);
                break;
            }
            case 202: {
                RTCPSDESPacket sdesp = (RTCPSDESPacket)p;
                int i5 = 0;
                while (i5 < sdesp.sdes.length) {
                    RTCPSDES chunk = sdesp.sdes[i5];
                    if (this.type == 1) {
                        info = p.base instanceof UDPPacket ? this.cache.get(chunk.ssrc, ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort, 1) : this.cache.get(chunk.ssrc, null, 0, 1);
                    }
                    if (this.type == 2) {
                        info = p.base instanceof UDPPacket ? this.cache.get(chunk.ssrc, ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort, 2) : this.cache.get(chunk.ssrc, null, 0, 2);
                    }
                    if (info == null) break;
                    info.setAlive(true);
                    info.lastHeardFrom = sdesp.receiptTime;
                    info.addSDESInfo(chunk);
                    ++i5;
                }
                if (info != null && !info.newpartsent && info.sourceInfo != null) {
                    NewParticipantEvent evtsdes = new NewParticipantEvent(this.cache.sm, info.sourceInfo);
                    this.cache.eventhandler.postEvent(evtsdes);
                    info.newpartsent = true;
                }
                if (info != null && !info.recvstrmap && info.sourceInfo != null && info instanceof RecvSSRCInfo) {
                    info.recvstrmap = true;
                    StreamMappedEvent evtr = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)info), info.sourceInfo);
                    this.cache.eventhandler.postEvent(evtr);
                }
                this.type = 0;
                break;
            }
            case 203: {
                RTCPBYEPacket byep = (RTCPBYEPacket)p;
                info = p.base instanceof UDPPacket ? this.cache.get(byep.ssrc[0], ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort) : this.cache.get(byep.ssrc[0], null, 0);
                int i6 = 0;
                while (i6 < byep.ssrc.length) {
                    info = p.base instanceof UDPPacket ? this.cache.get(byep.ssrc[i6], ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort) : this.cache.get(byep.ssrc[i6], null, 0);
                    if (info == null) break;
                    if (!this.cache.byestate) {
                        info.setAlive(false);
                        info.byeReceived = true;
                        info.byeTime = p.receiptTime;
                        info.lastHeardFrom = byep.receiptTime;
                    }
                    ++i6;
                }
                if (info == null) break;
                if (info.quiet) {
                    info.quiet = false;
                    ActiveReceiveStreamEvent event4 = null;
                    event4 = info instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, null);
                    this.cache.eventhandler.postEvent(event4);
                }
                info.byereason = new String(byep.reason);
                if (info.byeReceived) break;
                boolean byepart = false;
                RTPSourceInfo sourceInfo = info.sourceInfo;
                if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                    byepart = true;
                }
                ByeEvent evtbye = null;
                if (info instanceof RecvSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), new String(byep.reason), byepart);
                }
                if (info instanceof PassiveSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, null, new String(byep.reason), byepart);
                }
                this.cache.eventhandler.postEvent(evtbye);
                break;
            }
            case 204: {
                RTCPAPPPacket appp = (RTCPAPPPacket)p;
                info = p.base instanceof UDPPacket ? this.cache.get(appp.ssrc, ((UDPPacket)p.base).remoteAddress, ((UDPPacket)p.base).remotePort) : this.cache.get(appp.ssrc, null, 0);
                if (info == null) break;
                info.lastHeardFrom = appp.receiptTime;
                if (info.quiet) {
                    info.quiet = false;
                    ActiveReceiveStreamEvent event5 = null;
                    event5 = info instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, info.sourceInfo, null);
                    this.cache.eventhandler.postEvent(event5);
                }
                ApplicationEvent evnt = null;
                if (info instanceof RecvSSRCInfo) {
                    evnt = new ApplicationEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), appp.subtype, null, appp.data);
                }
                if (info instanceof PassiveSSRCInfo) {
                    evnt = new ApplicationEvent(this.cache.sm, info.sourceInfo, null, appp.subtype, null, appp.data);
                }
                this.cache.eventhandler.postEvent(evnt);
            }
        }
    }
}

