/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.RTPMediaThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.TimeoutEvent;

public class SSRCCacheCleaner
implements Runnable {
    private SSRCCache cache;
    private RTPMediaThread thread;
    private static final int DEATHTIME = 1800000;
    private static final int TIMEOUT_MULTIPLIER = 5;
    boolean timeToClean = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean killed = false;
    private StreamSynch streamSynch;
    static /* synthetic */ Class class$com$sun$media$rtp$util$RTPMediaThread;

    public SSRCCacheCleaner(SSRCCache cache, StreamSynch streamSynch) {
        this.cache = cache;
        this.streamSynch = streamSynch;
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor conswithname = jdk12CreateThreadRunnableAction.conswithname;
                this.thread = (RTPMediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, conswithname.newInstance(class$com$sun$media$rtp$util$RTPMediaThread == null ? (class$com$sun$media$rtp$util$RTPMediaThread = SSRCCacheCleaner.class$("com.sun.media.rtp.util.RTPMediaThread")) : class$com$sun$media$rtp$util$RTPMediaThread, this, "SSRC Cache Cleaner"));
                Constructor pcons = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, pcons.newInstance(this.thread, new Integer(MediaThread.getControlPriority())));
            }
            catch (Exception exception) {}
        } else {
            this.thread = new RTPMediaThread(this, "SSRC Cache Cleaner");
            this.thread.useControlPriority();
        }
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        this.killed = true;
        this.notifyAll();
    }

    public synchronized void run() {
        try {
            while (true) {
                if (!this.timeToClean && !this.killed) {
                    this.wait();
                    continue;
                }
                if (this.killed) {
                    return;
                }
                this.cleannow();
                this.timeToClean = false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    public synchronized void setClean() {
        this.timeToClean = true;
        this.notifyAll();
    }

    public synchronized void cleannow() {
        long time = System.currentTimeMillis();
        if (this.cache.ourssrc == null) {
            return;
        }
        double reportInterval = this.cache.calcReportInterval(this.cache.ourssrc.sender, true);
        Enumeration enumeration = this.cache.cache.elements();
        while (enumeration.hasMoreElements()) {
            SSRCInfo info = (SSRCInfo)enumeration.nextElement();
            if (info.ours) continue;
            if (info.byeReceived) {
                if (time - info.byeTime < 1000L) {
                    try {
                        Thread.sleep(1000L - time + info.byeTime);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    time = System.currentTimeMillis();
                }
                info.byeTime = 0L;
                info.byeReceived = false;
                this.cache.remove(info.ssrc);
                this.streamSynch.remove(info.ssrc);
                boolean byepart = false;
                RTPSourceInfo sourceInfo = info.sourceInfo;
                if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                    byepart = true;
                }
                ByeEvent evtbye = null;
                if (info instanceof RecvSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), info.byereason, byepart);
                }
                if (info instanceof PassiveSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, null, info.byereason, byepart);
                }
                this.cache.eventhandler.postEvent(evtbye);
                continue;
            }
            if (!((double)info.lastHeardFrom + reportInterval <= (double)time)) continue;
            InactiveReceiveStreamEvent event2 = null;
            if (!info.inactivesent) {
                boolean laststream = false;
                RTPSourceInfo si = info.sourceInfo;
                if (si != null && si.getStreamCount() == 1) {
                    laststream = true;
                }
                if (info instanceof ReceiveStream) {
                    event2 = new InactiveReceiveStreamEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), laststream);
                } else if ((double)info.lastHeardFrom + (reportInterval *= 5.0) <= (double)time) {
                    event2 = new InactiveReceiveStreamEvent(this.cache.sm, info.sourceInfo, null, laststream);
                }
                if (event2 == null) continue;
                this.cache.eventhandler.postEvent(event2);
                info.quiet = true;
                info.inactivesent = true;
                info.setAlive(false);
                continue;
            }
            if (info.lastHeardFrom + 1800000L > time) continue;
            TimeoutEvent evt = null;
            this.cache.remove(info.ssrc);
            boolean byepart = false;
            RTPSourceInfo sourceInfo = info.sourceInfo;
            if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                byepart = true;
            }
            evt = info instanceof ReceiveStream ? new TimeoutEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), byepart) : new TimeoutEvent(this.cache.sm, info.sourceInfo, null, byepart);
            this.cache.eventhandler.postEvent(evt);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

