/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.AbstractCommunicator;
import com.willwinder.universalgcodesender.listeners.SerialCommunicatorListener;
import com.willwinder.universalgcodesender.utils.CommUtils;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class BufferedCommunicator
extends AbstractCommunicator {
    private Boolean sendPaused = false;
    private LinkedBlockingDeque<String> commandBuffer;
    private LinkedBlockingDeque<String> activeStringList;
    private int sentBufferSize = 0;
    private Boolean singleStepModeEnabled = false;

    public abstract int getBufferSize();

    protected void setQueuesForTesting(LinkedBlockingDeque<String> cb, LinkedBlockingDeque<String> asl) {
        this.commandBuffer = cb;
        this.activeStringList = asl;
    }

    @Override
    public void setSingleStepMode(boolean enable) {
        this.singleStepModeEnabled = enable;
    }

    @Override
    public boolean getSingleStepMode() {
        return this.singleStepModeEnabled;
    }

    @Override
    public void queueStringForComm(String input) {
        String commandString = input;
        if (!commandString.endsWith("\n")) {
            commandString = commandString + "\n";
        }
        this.commandBuffer.add(commandString);
    }

    @Override
    public boolean areActiveCommands() {
        return this.activeStringList.size() > 0;
    }

    private boolean allowMoreCommands() {
        return this.singleStepModeEnabled == false || !this.areActiveCommands();
    }

    @Override
    public void streamCommands() {
        if (this.commandBuffer.size() == 0) {
            return;
        }
        if (this.sendPaused.booleanValue()) {
            return;
        }
        while (CommUtils.checkRoomInBuffer(this.sentBufferSize, this.commandBuffer.peek(), this.getBufferSize()).booleanValue() && this.allowMoreCommands()) {
            String commandString = this.commandBuffer.pop();
            this.activeStringList.add(commandString);
            this.sentBufferSize += commandString.length();
            this.sendMessageToConsoleListener(">>> " + commandString);
            try {
                this.sendingCommand(commandString);
                this.conn.sendStringToComm(commandString);
                BufferedCommunicator.dispatchListenerEvents(1, (ArrayList<SerialCommunicatorListener>)this.commandSentListeners, commandString.trim());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.exit(-1);
            }
        }
    }

    @Override
    public void pauseSend() {
        this.sendPaused = true;
    }

    @Override
    public void resumeSend() {
        this.sendPaused = false;
        this.streamCommands();
    }

    @Override
    public void cancelSend() {
        this.commandBuffer.clear();
    }

    @Override
    public void softReset() {
        this.commandBuffer.clear();
        this.activeStringList.clear();
        this.sentBufferSize = 0;
    }

    protected abstract void sendingCommand(String var1);

    protected abstract boolean processedCommand(String var1);

    @Override
    public void responseMessage(String response) {
        BufferedCommunicator.dispatchListenerEvents(3, (ArrayList<SerialCommunicatorListener>)this.commRawResponseListener, response);
        if (this.processedCommand(response) && this.activeStringList != null && this.activeStringList.size() > 0) {
            String commandString = this.activeStringList.pop();
            this.sentBufferSize -= commandString.length();
            if (!this.sendPaused.booleanValue()) {
                this.streamCommands();
            }
        }
    }

    @Override
    public boolean openCommPort(String name, int baud) throws Exception {
        boolean ret = super.openCommPort(name, baud);
        if (ret) {
            this.commandBuffer = new LinkedBlockingDeque();
            this.activeStringList = new LinkedBlockingDeque();
            this.sentBufferSize = 0;
        }
        return ret;
    }

    @Override
    public void closeCommPort() throws Exception {
        this.cancelSend();
        super.closeCommPort();
        this.sendPaused = false;
        this.commandBuffer = null;
        this.activeStringList = null;
    }

    @Override
    public void sendByteImmediately(byte b2) throws Exception {
        this.conn.sendByteImmediately(b2);
    }
}

