/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.types.Simulator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GrblSimulator
extends Simulator {
    public GrblSimulator() {
    }

    public GrblSimulator(Collection<String> configurationCommands) {
        super(configurationCommands);
    }

    protected Process getSimulatorProcess() throws IOException {
        ProcessBuilder pb = new ProcessBuilder("sim.exe", "1");
        return pb.start();
    }

    protected void sendCommands(Collection<String> commands, BufferedWriter simInputBuffer) throws IOException {
        for (String command : commands) {
            simInputBuffer.write(command);
            simInputBuffer.newLine();
            simInputBuffer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> runSimulation(Collection<String> commands) throws IOException {
        BufferedWriter simInputBuffer = null;
        ProcessBuffer simOutputBuffer = null;
        Thread parserThread = null;
        try {
            Process simulation = this.getSimulatorProcess();
            simInputBuffer = new BufferedWriter(new OutputStreamWriter(simulation.getOutputStream()));
            simOutputBuffer = new ProcessBuffer(simulation);
            parserThread = new Thread(simOutputBuffer);
            parserThread.start();
            while (!simOutputBuffer.isReady()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ioe) {
                    parserThread.interrupt();
                    List<String> list = null;
                    if (simInputBuffer != null) {
                        simInputBuffer.close();
                    }
                    if (parserThread.isAlive()) {
                        parserThread.interrupt();
                    }
                    return list;
                }
            }
            this.sendCommands(this.configStrings, simInputBuffer);
            this.sendCommands(commands, simInputBuffer);
            simInputBuffer.close();
            try {
                simulation.waitFor();
                parserThread.join();
            }
            catch (InterruptedException ie) {
                List<String> list = null;
                if (simInputBuffer != null) {
                    simInputBuffer.close();
                }
                if (parserThread.isAlive()) {
                    parserThread.interrupt();
                }
                return list;
            }
        }
        finally {
            if (simInputBuffer != null) {
                simInputBuffer.close();
            }
            if (parserThread.isAlive()) {
                parserThread.interrupt();
            }
        }
        return simOutputBuffer.getErrLines();
    }

    protected long parseResults(List<String> simOutput) {
        long result = 0L;
        for (int i2 = simOutput.size() - 1; i2 >= 0; --i2) {
            Double seconds;
            int ci;
            String line = simOutput.get(i2).trim();
            if (line.startsWith("#") || (ci = line.indexOf(44)) <= 0) continue;
            String secondsString = line.substring(0, ci);
            try {
                seconds = Double.parseDouble(secondsString);
            }
            catch (Exception e2) {
                continue;
            }
            result = StrictMath.round(seconds * 1000.0);
            break;
        }
        return result;
    }

    @Override
    public long estimateRunLength(Collection<String> commands) {
        long result = 0L;
        List<String> buffer = null;
        try {
            buffer = this.runSimulation(commands);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (buffer != null) {
            result = this.parseResults(buffer);
        }
        return result;
    }

    public class Buffer
    implements Runnable {
        private BufferedReader reader;
        List<String> buffer;
        List<String> globalBuffer;

        public Buffer(InputStream in, List<String> buffer, List<String> globalBuffer) {
            this.reader = new BufferedReader(new InputStreamReader(in));
            this.buffer = buffer;
            this.globalBuffer = globalBuffer;
        }

        @Override
        public void run() {
            this.buffer.clear();
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.buffer.add(line);
                    this.globalBuffer.add(line);
                }
            }
            catch (IOException ioe) {
                return;
            }
        }
    }

    public class ProcessBuffer
    implements Runnable {
        protected Process process;
        protected List<String> stderrList;
        protected List<String> stdoutList;
        protected List<String> outList;
        protected boolean ready;

        public boolean isReady() {
            return this.ready;
        }

        public ProcessBuffer(Process process) {
            this.process = process;
        }

        public List<String> getErrLines() {
            return this.getLines(this.stderrList);
        }

        public List<String> getStdLines() {
            return this.getLines(this.stdoutList);
        }

        public List<String> getAllLines() {
            return this.getLines(this.outList);
        }

        private List<String> getLines(List<String> list) {
            if (list == null) {
                return null;
            }
            int size = list.size();
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i2 = 0; i2 < size; ++i2) {
                result.add(list.get(i2));
            }
            return result;
        }

        @Override
        public void run() {
            this.outList = new ArrayList<String>();
            List<String> syncList = Collections.synchronizedList(this.outList);
            this.stderrList = new ArrayList<String>();
            this.stdoutList = new ArrayList<String>();
            Thread errReader = new Thread(new Buffer(this.process.getErrorStream(), this.stderrList, syncList));
            Thread stdReader = new Thread(new Buffer(this.process.getInputStream(), this.stdoutList, syncList));
            stdReader.start();
            errReader.start();
            while (this.stdoutList.size() < 2 || !StringUtils.join(this.getStdLines(), "").contains(" for help]")) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ioe) {
                    this.process.destroy();
                    return;
                }
            }
            this.ready = true;
            try {
                stdReader.join();
                errReader.join();
            }
            catch (InterruptedException ie) {
                this.process.destroy();
                return;
            }
        }
    }
}

