/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.model.Utils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;

public class GrblUtils {
    public static final int GRBL_RX_BUFFER_SIZE = 123;
    public static final byte GRBL_PAUSE_COMMAND = 33;
    public static final byte GRBL_RESUME_COMMAND = 126;
    public static final byte GRBL_STATUS_COMMAND = 63;
    public static final byte GRBL_RESET_COMMAND = 24;
    public static final String GRBL_KILL_ALARM_LOCK_COMMAND = "$X";
    public static final String GRBL_TOGGLE_CHECK_MODE_COMMAND = "$C";
    public static final String GRBL_VIEW_PARSER_STATE_COMMAND = "$G";
    public static final String GCODE_RESET_COORDINATES_TO_ZERO_V9 = "G10 P0 L20 X0 Y0 Z0";
    public static final String GCODE_RESET_COORDINATES_TO_ZERO_V8 = "G92 X0 Y0 Z0";
    public static final String GCODE_RESET_COORDINATE_TO_ZERO_V9 = "G10 P0 L20 %c0";
    public static final String GCODE_RESET_COORDINATE_TO_ZERO_V8 = "G92 %c0";
    public static final String GCODE_RETURN_TO_ZERO_LOCATION_V8 = "G91 G0 X0 Y0 Z0";
    public static final String GCODE_RETURN_TO_ZERO_LOCATION_V8C = "G90 G0 X0 Y0 Z0";
    public static final String GCODE_RETURN_TO_MAX_Z_LOCATION_V8C = "G90 G0 Z";
    public static final String GCODE_PERFORM_HOMING_CYCLE_V8 = "G28 X0 Y0 Z0";
    public static final String GCODE_PERFORM_HOMING_CYCLE_V8C = "$H";
    static Pattern mmPattern = Pattern.compile(".*:\\d+\\.\\d\\d\\d,.*");
    static Pattern machinePattern = Pattern.compile("(?<=MPos:)(-?\\d*\\..\\d*),(-?\\d*\\..\\d*),(-?\\d*\\..\\d*)(?=,WPos:)");
    static Pattern workPattern = Pattern.compile("(?<=WPos:)(\\-?\\d*\\..\\d*),(\\-?\\d*\\..\\d*),(\\-?\\d*\\..\\d*)");

    static Boolean isGrblVersionString(String response) {
        Boolean version = response.startsWith("Grbl ") || response.startsWith("CarbideMotion ");
        return version != false && GrblUtils.getVersionDouble(response) != -1.0;
    }

    protected static double getVersionDouble(String response) {
        double retValue = -1.0;
        String VERSION_REGEX = "[0-9]*\\.[0-9]*";
        Pattern pattern = Pattern.compile("[0-9]*\\.[0-9]*");
        Matcher matcher = pattern.matcher(response);
        if (matcher.find()) {
            retValue = Double.parseDouble(matcher.group(0));
        }
        return retValue;
    }

    protected static String getVersionLetter(String response) {
        String retValue = null;
        String VERSION_REGEX = "(?<=[0-9]\\.[0-9])[a-zA-Z]";
        Pattern pattern = Pattern.compile("(?<=[0-9]\\.[0-9])[a-zA-Z]");
        Matcher matcher = pattern.matcher(response);
        if (matcher.find()) {
            retValue = matcher.group(0);
        }
        return retValue;
    }

    protected static Boolean isRealTimeCapable(double version) {
        return version > 0.7;
    }

    protected static String getHomingCommand(double version, String letter) {
        if (version >= 0.8 && letter != null && letter.equals("c") || version >= 0.9) {
            return GCODE_PERFORM_HOMING_CYCLE_V8C;
        }
        if (version >= 0.8) {
            return GCODE_PERFORM_HOMING_CYCLE_V8;
        }
        return "";
    }

    protected static String getResetCoordsToZeroCommand(double version, String letter) {
        if (version >= 0.9) {
            return GCODE_RESET_COORDINATES_TO_ZERO_V9;
        }
        if (version >= 0.8 && letter != null && letter.equals("c")) {
            return GCODE_RESET_COORDINATES_TO_ZERO_V8;
        }
        if (version >= 0.8) {
            return GCODE_RESET_COORDINATES_TO_ZERO_V8;
        }
        return "";
    }

    protected static String getResetCoordToZeroCommand(char coord, double version, String letter) {
        if (version >= 0.9) {
            return String.format(GCODE_RESET_COORDINATE_TO_ZERO_V9, Character.valueOf(coord));
        }
        if (version >= 0.8 && letter != null && letter.equals("c")) {
            return String.format(GCODE_RESET_COORDINATE_TO_ZERO_V8, Character.valueOf(coord));
        }
        if (version >= 0.8) {
            return "";
        }
        return "";
    }

    @Deprecated
    protected static String getReturnToHomeCommand(double version, String letter) {
        if (version >= 0.8 && letter != null && letter.equals("c") || version >= 0.9) {
            return GCODE_RETURN_TO_ZERO_LOCATION_V8C;
        }
        if (version >= 0.8) {
            return GCODE_RETURN_TO_ZERO_LOCATION_V8;
        }
        return "";
    }

    protected static ArrayList<String> getReturnToHomeCommands(double version, String letter, double maxZOffset) {
        ArrayList<String> commands = new ArrayList<String>();
        if (version >= 0.8 && letter != null && letter.equals("c") || version >= 0.9) {
            commands.add(GCODE_RETURN_TO_MAX_Z_LOCATION_V8C + maxZOffset);
            commands.add(GCODE_RETURN_TO_ZERO_LOCATION_V8C);
        } else if (version >= 0.8) {
            commands.add(GCODE_RETURN_TO_ZERO_LOCATION_V8);
        }
        return commands;
    }

    protected static String getKillAlarmLockCommand(double version, String letter) {
        if (version >= 0.8 && letter != null && letter.equals("c") || version >= 0.9) {
            return GRBL_KILL_ALARM_LOCK_COMMAND;
        }
        return "";
    }

    protected static String getToggleCheckModeCommand(double version, String letter) {
        if (version >= 0.8 && letter != null && letter.equals("c") || version >= 0.9) {
            return GRBL_TOGGLE_CHECK_MODE_COMMAND;
        }
        return "";
    }

    protected static String getViewParserStateCommand(double version, String letter) {
        if (version >= 0.8 && letter != null && letter.equals("c") || version >= 0.9) {
            return GRBL_VIEW_PARSER_STATE_COMMAND;
        }
        return "";
    }

    protected static Capabilities getGrblStatusCapabilities(double version, String letter) {
        if (version >= 0.8) {
            if (version == 0.8 && letter != null && letter.equals("c")) {
                return Capabilities.STATUS_C;
            }
            if (version >= 0.9) {
                return Capabilities.STATUS_C;
            }
        }
        return null;
    }

    protected static Boolean isGrblStatusString(String response) {
        double retValue = -1.0;
        String REGEX = "\\<.*\\>";
        Pattern pattern = Pattern.compile("\\<.*\\>");
        Matcher matcher = pattern.matcher(response);
        if (matcher.find()) {
            return true;
        }
        return false;
    }

    protected static String getStateFromStatusString(String status, Capabilities version) {
        String retValue = null;
        if (version != Capabilities.STATUS_C) {
            return null;
        }
        String REGEX = "(?<=\\<)[a-zA-z]*(?=[,])";
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(status);
        if (matcher.find()) {
            retValue = matcher.group(0);
        }
        return retValue;
    }

    protected static Utils.Units getUnitsFromStatusString(String status, Capabilities version) {
        if (version == Capabilities.STATUS_C) {
            if (mmPattern.matcher(status).find()) {
                return Utils.Units.MM;
            }
            return Utils.Units.INCH;
        }
        return Utils.Units.UNKNOWN;
    }

    protected static Point3d getMachinePositionFromStatusString(String status, Capabilities version) {
        if (version == Capabilities.STATUS_C) {
            return GrblUtils.getPositionFromStatusString(status, machinePattern);
        }
        return null;
    }

    protected static Point3d getWorkPositionFromStatusString(String status, Capabilities version) {
        if (version == Capabilities.STATUS_C) {
            return GrblUtils.getPositionFromStatusString(status, workPattern);
        }
        return null;
    }

    private static Point3d getPositionFromStatusString(String status, Pattern pattern) {
        Matcher matcher = pattern.matcher(status);
        if (matcher.find()) {
            return new Point3d(Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(2)), Double.parseDouble(matcher.group(3)));
        }
        return null;
    }

    public static enum Capabilities {
        REAL_TIME,
        STATUS_C;

    }
}

