/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender;

import com.willwinder.universalgcodesender.i18n.Localization;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public class Utils {
    public static NumberFormat formatter = new DecimalFormat("#.###", Localization.dfs);

    public static String timeSince(long from) {
        long elapsedTime = Utils.millisSince(from);
        return Utils.formattedMillis(elapsedTime);
    }

    public static long millisSince(long from) {
        long until = System.currentTimeMillis();
        return until - from;
    }

    public static String formattedMillis(long millis) {
        String format = String.format("%%0%dd", 2);
        long elapsedTime = millis / 1000L;
        String hours = String.format(format, elapsedTime / 3600L);
        String minutes = String.format(format, (elapsedTime %= 3600L) / 60L);
        String seconds = String.format(format, elapsedTime %= 60L);
        String time = hours + ":" + minutes + ":" + seconds;
        return time;
    }

    public static List<String> processFile(File file) throws FileNotFoundException, IOException {
        Charset encoding;
        try (FileReader fileReader = new FileReader(file);){
            encoding = Charset.forName(fileReader.getEncoding());
        }
        return Files.readAllLines(file.toPath(), encoding);
    }
}

