/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.connection;

import com.willwinder.universalgcodesender.connection.Connection;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;

public class JSSCConnection
extends Connection
implements SerialPortEventListener {
    @Deprecated
    private String lineTerminator;
    private SerialPort serialPort;
    private StringBuilder inputBuffer = null;

    public JSSCConnection() {
        this("\r\n");
    }

    public JSSCConnection(String terminator) {
        this.lineTerminator = terminator;
    }

    @Deprecated
    public void setLineTerminator(String lt) {
        this.lineTerminator = lt;
    }

    @Deprecated
    public String getLineTerminator() {
        return this.lineTerminator;
    }

    @Override
    public synchronized boolean openPort(String name, int baud) throws Exception {
        this.inputBuffer = new StringBuilder();
        this.serialPort = new SerialPort(name);
        this.serialPort.openPort();
        this.serialPort.setParams(baud, 8, 1, 0, true, true);
        this.serialPort.addEventListener(this);
        if (this.serialPort == null) {
            throw new Exception("Serial port not found.");
        }
        return true;
    }

    @Override
    public void closePort() throws Exception {
        if (this.serialPort != null) {
            try {
                this.serialPort.removeEventListener();
                if (this.serialPort.isOpened()) {
                    this.serialPort.closePort();
                }
            }
            finally {
                this.inputBuffer = null;
                this.serialPort = null;
            }
        }
    }

    @Override
    public void sendStringToComm(String command) throws Exception {
        this.serialPort.writeString(command);
    }

    @Override
    public void sendByteImmediately(byte b2) throws Exception {
        this.serialPort.writeByte(b2);
    }

    @Override
    public void serialEvent(SerialPortEvent evt) {
        if (this.inputBuffer == null) {
            this.inputBuffer = new StringBuilder();
        }
        try {
            byte[] buf = this.serialPort.readBytes();
            if (buf != null && buf.length > 0) {
                String s = new String(buf, 0, buf.length);
                this.inputBuffer.append(s);
                if (this.inputBuffer.toString().contains(this.comm.getLineTerminator())) {
                    String[] commands = this.inputBuffer.toString().split(this.comm.getLineTerminator(), -1);
                    for (int i2 = 0; i2 < commands.length; ++i2) {
                        if (i2 + 1 < commands.length) {
                            this.comm.responseMessage(commands[i2]);
                            continue;
                        }
                        this.inputBuffer = new StringBuilder().append(commands[i2]);
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supports(String portname, int baud) {
        SerialPort serialPort = new SerialPort(portname);
        try {
            serialPort.openPort();
            serialPort.setParams(baud, 8, 1, 0, true, true);
            serialPort.closePort();
            boolean bl = true;
            return bl;
        }
        catch (SerialPortException e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (serialPort.isOpened()) {
                try {
                    serialPort.closePort();
                }
                catch (SerialPortException serialPortException) {}
            }
        }
    }
}

