/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.gcode;

import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.util.LinkedList;
import java.util.Queue;

public class GcodeCommandBuffer {
    private Queue<GcodeCommand> commandQueue = new LinkedList<GcodeCommand>();
    private GcodeCommand currentCommand = null;
    private int numCommands = 0;

    public int size() {
        return this.commandQueue.size();
    }

    public Boolean hasNext() {
        return this.commandQueue.size() > 0;
    }

    public GcodeCommand currentCommand() {
        return this.currentCommand;
    }

    public GcodeCommand nextCommand() {
        if (this.hasNext().booleanValue()) {
            this.currentCommand = this.commandQueue.remove();
        }
        return this.currentCommand();
    }

    public GcodeCommand appendCommandString(String commandString) {
        GcodeCommand command = new GcodeCommand(commandString);
        command.setCommandNumber(this.numCommands++);
        this.commandQueue.add(command);
        if (this.currentCommand == null || this.currentCommand.isSent().booleanValue()) {
            this.nextCommand();
        }
        return command;
    }

    public void clearBuffer() {
        this.currentCommand = null;
        this.commandQueue.clear();
    }
}

