/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.gcode;

import com.willwinder.universalgcodesender.gcode.GcodePreprocessorUtils;
import com.willwinder.universalgcodesender.types.PointSegment;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.vecmath.Point3d;

public class GcodeParser {
    private boolean isMetric = true;
    private boolean inAbsoluteMode = true;
    private boolean inAbsoluteIJKMode = false;
    private String lastGcodeCommand = "";
    private Point3d currentPoint = null;
    private int commandNumber = 0;
    private double speedOverride = -1.0;
    private int truncateDecimalLength = 40;
    private boolean removeAllWhitespace = true;
    private boolean convertArcsToLines = false;
    private double smallArcThreshold = 1.0;
    private double smallArcSegmentLength = 0.3;
    List<PointSegment> points;

    public GcodeParser() {
        this.reset();
    }

    public boolean getConvertArcsToLines() {
        return this.convertArcsToLines;
    }

    public void setConvertArcsToLines(boolean convertArcsToLines) {
        this.convertArcsToLines = convertArcsToLines;
    }

    public boolean getRemoveAllWhitespace() {
        return this.removeAllWhitespace;
    }

    public void setRemoveAllWhitespace(boolean removeAllWhitespace) {
        this.removeAllWhitespace = removeAllWhitespace;
    }

    public double getSmallArcSegmentLength() {
        return this.smallArcSegmentLength;
    }

    public void setSmallArcSegmentLength(double smallArcSegmentLength) {
        this.smallArcSegmentLength = smallArcSegmentLength;
    }

    public double getSmallArcThreshold() {
        return this.smallArcThreshold;
    }

    public void setSmallArcThreshold(double smallArcThreshold) {
        this.smallArcThreshold = smallArcThreshold;
    }

    public double getSpeedOverride() {
        return this.speedOverride;
    }

    public void setSpeedOverride(double speedOverride) {
        this.speedOverride = speedOverride;
    }

    public int getTruncateDecimalLength() {
        return this.truncateDecimalLength;
    }

    public void setTruncateDecimalLength(int truncateDecimalLength) {
        this.truncateDecimalLength = truncateDecimalLength;
    }

    public final void reset() {
        this.currentPoint = new Point3d();
        this.points = new ArrayList<PointSegment>();
        this.points.add(new PointSegment(this.currentPoint, -1));
    }

    public PointSegment addCommand(String command) {
        String stripped = GcodePreprocessorUtils.removeComment(command);
        List<String> args = GcodePreprocessorUtils.splitCommand(stripped);
        return this.addCommand(args);
    }

    public PointSegment addCommand(List<String> args) {
        if (args.isEmpty()) {
            return null;
        }
        return this.processCommand(args);
    }

    private void setLastGcodeCommand(String num) {
        this.lastGcodeCommand = num;
    }

    public Point3d getCurrentPoint() {
        return this.currentPoint;
    }

    public List<PointSegment> expandArc() {
        PointSegment startSegment = this.points.get(this.points.size() - 2);
        PointSegment lastSegment = this.points.get(this.points.size() - 1);
        if (!lastSegment.isArc()) {
            return null;
        }
        Point3d start = startSegment.point();
        Point3d end = lastSegment.point();
        Point3d center = lastSegment.center();
        double radius = lastSegment.getRadius();
        boolean clockwise = lastSegment.isClockwise();
        List<Point3d> expandedPoints = GcodePreprocessorUtils.generatePointsAlongArcBDring(start, end, center, clockwise, radius, this.smallArcThreshold, this.smallArcSegmentLength);
        if (expandedPoints == null) {
            return null;
        }
        this.points.remove(this.points.size() - 1);
        --this.commandNumber;
        ArrayList<PointSegment> psl = new ArrayList<PointSegment>();
        ListIterator<Point3d> psi = expandedPoints.listIterator(1);
        while (psi.hasNext()) {
            PointSegment temp = new PointSegment((Point3d)psi.next(), this.commandNumber++);
            temp.setIsMetric(lastSegment.isMetric());
            this.points.add(temp);
            psl.add(temp);
        }
        this.currentPoint = this.points.get(this.points.size() - 1).point();
        return psl;
    }

    public List<PointSegment> getPointSegmentList() {
        return this.points;
    }

    private PointSegment processCommand(List<String> args) {
        PointSegment ps = null;
        List<String> gCodes = GcodePreprocessorUtils.parseCodes(args, 'G');
        if (gCodes.isEmpty() && this.lastGcodeCommand != null && !this.lastGcodeCommand.isEmpty()) {
            gCodes.add(this.lastGcodeCommand);
        }
        for (String i2 : gCodes) {
            ps = this.handleGCode(i2, args);
        }
        return ps;
    }

    private PointSegment addLinearPointSegment(Point3d nextPoint, boolean fastTraverse) {
        PointSegment ps = new PointSegment(nextPoint, this.commandNumber++);
        boolean zOnly = false;
        if (this.currentPoint.x == nextPoint.x && this.currentPoint.y == nextPoint.y && this.currentPoint.z != nextPoint.z) {
            zOnly = true;
        }
        ps.setIsMetric(this.isMetric);
        ps.setIsZMovement(zOnly);
        ps.setIsFastTraverse(fastTraverse);
        this.points.add(ps);
        this.currentPoint = nextPoint;
        return ps;
    }

    private PointSegment addArcPointSegment(Point3d nextPoint, boolean clockwise, List<String> args) {
        PointSegment ps = new PointSegment(nextPoint, this.commandNumber++);
        Point3d center = GcodePreprocessorUtils.updateCenterWithCommand(args, this.currentPoint, nextPoint, this.inAbsoluteIJKMode, clockwise);
        double radius = GcodePreprocessorUtils.parseCoord(args, 'R');
        if (Double.isNaN(radius)) {
            radius = Math.sqrt(Math.pow(this.currentPoint.x - center.x, 2.0) + Math.pow(this.currentPoint.y - center.y, 2.0));
        }
        ps.setIsMetric(this.isMetric);
        ps.setArcCenter(center);
        ps.setIsArc(true);
        ps.setRadius(radius);
        ps.setIsClockwise(clockwise);
        this.points.add(ps);
        this.currentPoint = nextPoint;
        return ps;
    }

    private PointSegment handleGCode(String code, List<String> args) {
        PointSegment ps = null;
        Point3d nextPoint = GcodePreprocessorUtils.updatePointWithCommand(args, this.currentPoint, this.inAbsoluteMode);
        if (code.length() > 1 && code.startsWith("0")) {
            code = code.substring(1);
        }
        switch (code) {
            case "0": {
                ps = this.addLinearPointSegment(nextPoint, true);
                break;
            }
            case "1": {
                ps = this.addLinearPointSegment(nextPoint, false);
                break;
            }
            case "2": {
                ps = this.addArcPointSegment(nextPoint, true, args);
                break;
            }
            case "3": {
                ps = this.addArcPointSegment(nextPoint, false, args);
                break;
            }
            case "20": {
                this.isMetric = false;
                break;
            }
            case "21": {
                this.isMetric = true;
                break;
            }
            case "90": {
                this.inAbsoluteMode = true;
                break;
            }
            case "90.1": {
                this.inAbsoluteIJKMode = true;
                break;
            }
            case "91": {
                this.inAbsoluteMode = false;
                break;
            }
            case "91.1": {
                this.inAbsoluteIJKMode = false;
            }
        }
        this.lastGcodeCommand = code;
        return ps;
    }

    public List<String> preprocessCommands(Collection<String> commands) {
        int count = commands.size();
        int interval = count / 1000;
        ArrayList<String> result = new ArrayList<String>(count);
        int i2 = 0;
        double row = 0.0;
        for (String command : commands) {
            row += 1.0;
            if (++i2 >= interval) {
                System.out.println("row " + (int)row + " of " + count);
                i2 = 0;
            }
            result.addAll(this.preprocessCommand(command));
        }
        return result;
    }

    public List<String> preprocessCommand(String command) {
        String newCommand;
        ArrayList<String> result = new ArrayList<String>();
        boolean hasComment = false;
        String rawCommand = newCommand = GcodePreprocessorUtils.removeComment(command);
        boolean bl = hasComment = newCommand.length() != command.length();
        if (this.removeAllWhitespace) {
            newCommand = GcodePreprocessorUtils.removeAllWhitespace(newCommand);
        }
        if ((newCommand = GcodePreprocessorUtils.removeM30(newCommand)).length() > 0) {
            if (this.speedOverride > 0.0) {
                newCommand = GcodePreprocessorUtils.overrideSpeed(newCommand, this.speedOverride);
            }
            if (this.truncateDecimalLength > 0) {
                newCommand = GcodePreprocessorUtils.truncateDecimals(this.truncateDecimalLength, newCommand);
            }
            if (this.convertArcsToLines) {
                List<String> arcLines = this.convertArcsToLines(newCommand);
                if (arcLines != null) {
                    result.addAll(arcLines);
                } else {
                    result.add(newCommand);
                }
            } else if (hasComment) {
                result.add(command.replace(rawCommand, newCommand));
            } else {
                result.add(newCommand);
            }
        } else if (hasComment) {
            result.add(command);
        }
        return result;
    }

    public List<String> convertArcsToLines(String command) {
        int index;
        ArrayList<String> result = null;
        Point3d start = new Point3d(this.currentPoint);
        PointSegment ps = this.addCommand(command);
        if (ps == null || !ps.isArc()) {
            return result;
        }
        List<PointSegment> psl = this.expandArc();
        if (psl == null) {
            return result;
        }
        result = new ArrayList<String>(psl.size());
        StringBuilder sb = new StringBuilder("#.");
        for (index = 0; index < this.truncateDecimalLength; ++index) {
            sb.append("#");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        index = 0;
        for (PointSegment segment : psl) {
            Point3d end = segment.point();
            result.add(GcodePreprocessorUtils.generateG1FromPoints(start, end, this.inAbsoluteMode, df));
            start = segment.point();
        }
        return result;
    }
}

