/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.model;

import com.willwinder.universalgcodesender.IController;
import com.willwinder.universalgcodesender.Utils;
import com.willwinder.universalgcodesender.gcode.GcodeParser;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.ControlStateListener;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.model.BackendAPI;
import com.willwinder.universalgcodesender.model.ControlStateEvent;
import com.willwinder.universalgcodesender.model.Utils;
import com.willwinder.universalgcodesender.pendantui.SystemStateBean;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import com.willwinder.universalgcodesender.utils.FirmwareUtils;
import com.willwinder.universalgcodesender.utils.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;

public class GUIBackend
implements BackendAPI,
ControllerListener {
    private static final Logger logger = Logger.getLogger(GUIBackend.class.getName());
    private IController controller = null;
    private Settings settings = null;
    Point3d machineCoord = null;
    Point3d workCoord = null;
    String state;
    Collection<ControllerListener> controllerListeners = new ArrayList<ControllerListener>();
    Collection<ControlStateListener> controlStateListeners = new ArrayList<ControlStateListener>();
    Utils.Units units = Utils.Units.UNKNOWN;
    File gcodeFile;
    String lastComment;
    String activeState;
    Utils.ControlState controlState = Utils.ControlState.COMM_DISCONNECTED;
    long sendStartTime = 0L;
    long estimatedSendDuration = -1L;
    long estimatedSendTimeRemaining = 0L;
    long rowsInFile = 0L;
    String openCloseButtonText;
    boolean openCloseButtonEnabled;
    String pauseButtonText;
    boolean pauseButtonEnabled;
    String cancelButtonText;
    boolean cancelButtonEnabled;
    boolean G91Mode = false;
    public GcodeParser gcp = new GcodeParser();
    Collection<String> processedCommandLines = null;

    @Override
    public void addControlStateListener(ControlStateListener listener) {
        logger.log(Level.INFO, "Adding control state listener.");
        this.controlStateListeners.add(listener);
    }

    @Override
    public void addControllerListener(ControllerListener listener) {
        logger.log(Level.INFO, "Adding controller listener.");
        this.controllerListeners.add(listener);
        if (this.controller != null) {
            this.controller.addListener(listener);
        }
    }

    @Override
    public void preprocessAndExportToFile(File f2) throws Exception {
        try (BufferedReader br = new BufferedReader(new FileReader(this.getFile()));
             PrintWriter pw = new PrintWriter(f2, "UTF-8");){
            String line;
            while ((line = br.readLine()) != null) {
                List<String> lines = this.gcp.preprocessCommand(line);
                for (String processedLine : lines) {
                    pw.println(processedLine);
                }
            }
        }
    }

    @Override
    public void connect(String firmware, String port, int baudRate) throws Exception {
        logger.log(Level.INFO, "Connecting to {0} on port {1}", new Object[]{firmware, port});
        this.controller = FirmwareUtils.getControllerFor(firmware);
        this.applySettingsToController(this.settings, this.controller);
        this.controller.addListener(this);
        for (ControllerListener l2 : this.controllerListeners) {
            this.controller.addListener(l2);
        }
        if (this.openCommConnection(port, baudRate)) {
            this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_IDLE));
        }
    }

    @Override
    public boolean isConnected() {
        boolean isConnected = this.controlState != Utils.ControlState.COMM_DISCONNECTED;
        logger.log(Level.INFO, "Is connected: {0}", isConnected);
        return isConnected;
    }

    @Override
    public void disconnect() throws Exception {
        logger.log(Level.INFO, "Disconnecting.");
        this.controller.closeCommPort();
        this.controller = null;
        this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_DISCONNECTED));
    }

    @Override
    public void applySettings(Settings settings) throws Exception {
        logger.log(Level.INFO, "Applying settings.");
        this.settings = settings;
        if (this.controller != null) {
            this.applySettingsToController(this.settings, this.controller);
        }
    }

    @Override
    public void updateSystemState(SystemStateBean systemStateBean) {
        logger.log(Level.INFO, "Getting system state 'updateSystemState'");
        systemStateBean.setFileName(this.gcodeFile.getAbsolutePath());
        systemStateBean.setLatestComment(this.lastComment);
        systemStateBean.setActiveState(this.activeState);
        systemStateBean.setControlState(this.controlState);
        systemStateBean.setDuration(String.valueOf(this.getSendDuration()));
        systemStateBean.setEstimatedTimeRemaining(String.valueOf(this.getSendRemainingDuration()));
        systemStateBean.setMachineX(Utils.formatter.format(this.machineCoord.getX()));
        systemStateBean.setMachineY(Utils.formatter.format(this.machineCoord.getY()));
        systemStateBean.setMachineZ(Utils.formatter.format(this.machineCoord.getZ()));
        systemStateBean.setRemainingRows(String.valueOf(this.getNumRemainingRows()));
        systemStateBean.setRowsInFile(String.valueOf(this.getNumRows()));
        systemStateBean.setSentRows(String.valueOf(this.getNumSentRows()));
        systemStateBean.setWorkX(Utils.formatter.format(this.workCoord.getX()));
        systemStateBean.setWorkY(Utils.formatter.format(this.workCoord.getY()));
        systemStateBean.setWorkZ(Utils.formatter.format(this.workCoord.getZ()));
        systemStateBean.setSendButtonText(this.openCloseButtonText);
        systemStateBean.setSendButtonEnabled(this.openCloseButtonEnabled);
        systemStateBean.setPauseResumeButtonText(this.pauseButtonText);
        systemStateBean.setPauseResumeButtonEnabled(this.canPause());
        systemStateBean.setCancelButtonText(this.cancelButtonText);
        systemStateBean.setCancelButtonEnabled(this.canCancel());
    }

    @Override
    public void sendGcodeCommand(String commandText) throws Exception {
        logger.log(Level.INFO, "Sending gcode command: {0}", commandText);
        this.controller.sendCommandImmediately(commandText);
    }

    @Override
    public void adjustManualLocation(int dirX, int dirY, int dirZ, double stepSize, Utils.Units units) throws Exception {
        logger.log(Level.INFO, "Adjusting manual location.");
        if (dirX == 0 && dirY == 0 && dirZ == 0) {
            return;
        }
        String formattedStepSize = Utils.formatter.format(stepSize);
        StringBuilder command = new StringBuilder();
        if (this.units != units) {
            if (units == Utils.Units.INCH) {
                command.append("G20 ");
            } else if (units == Utils.Units.MM) {
                command.append("G21 ");
            }
            this.units = units;
        }
        command.append("G91 G0 ");
        if (dirX != 0) {
            command.append(" X");
            if (dirX < 0) {
                command.append('-');
            }
            command.append(formattedStepSize);
        }
        if (dirY != 0) {
            command.append(" Y");
            if (dirY < 0) {
                command.append('-');
            }
            command.append(formattedStepSize);
        }
        if (dirZ != 0) {
            command.append(" Z");
            if (dirZ < 0) {
                command.append('-');
            }
            command.append(formattedStepSize);
        }
        this.sendGcodeCommand(command.toString());
        this.G91Mode = true;
    }

    @Override
    public Settings getSettings() {
        logger.log(Level.INFO, "Getting settings.");
        return this.settings;
    }

    @Override
    public Utils.ControlState getControlState() {
        logger.log(Level.INFO, "Getting control state.");
        return this.controlState;
    }

    @Override
    public IController getController() {
        logger.log(Level.INFO, "Getting controller");
        return this.controller;
    }

    @Override
    public void setFile(File file) throws Exception {
        logger.log(Level.INFO, "Setting gcode file.");
        this.gcodeFile = file;
        this.initializeProcessedLines(true);
        this.sendControlStateEvent(new ControlStateEvent(file.getAbsolutePath()));
    }

    @Override
    public File getFile() {
        logger.log(Level.INFO, "Getting gcode file.");
        return this.gcodeFile;
    }

    @Override
    public void send() throws Exception {
        logger.log(Level.INFO, "Sending gcode file.");
        try {
            this.controller.isReadyToStreamFile();
            this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_SENDING));
            if (this.G91Mode) {
                List<String> processed = this.gcp.preprocessCommand("G90");
                this.controller.queueCommands(processed);
                this.G91Mode = false;
            }
            this.controller.queueCommands(this.processedCommandLines);
            this.sendStartTime = System.currentTimeMillis();
            this.controller.beginStreaming();
        }
        catch (Exception e2) {
            this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_IDLE));
            e2.printStackTrace();
            throw new Exception(Localization.getString("mainWindow.error.startingStream") + ": " + e2.getMessage());
        }
    }

    @Override
    public long getNumRows() {
        return this.controller.rowsInSend();
    }

    @Override
    public long getNumSentRows() {
        return this.controller.rowsSent();
    }

    @Override
    public long getNumRemainingRows() {
        return this.getNumRows() - this.getNumSentRows();
    }

    @Override
    public long getSendDuration() {
        return this.controller.getSendDuration();
    }

    @Override
    public long getSendRemainingDuration() {
        long sent = this.getNumSentRows();
        if (sent == 0L) {
            return -1L;
        }
        long estimate = this.estimatedSendDuration;
        long elapsedTime = this.getSendDuration();
        if (estimate <= 0L) {
            long timePerCode = elapsedTime / sent;
            estimate = timePerCode * this.getNumRows();
        }
        return estimate - elapsedTime;
    }

    @Override
    public void pauseResume() throws Exception {
        logger.log(Level.INFO, "Pause/Resume");
        try {
            switch (this.controlState) {
                case COMM_SENDING: {
                    this.controller.pauseStreaming();
                    this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_SENDING_PAUSED));
                    return;
                }
                case COMM_SENDING_PAUSED: {
                    this.controller.resumeStreaming();
                    this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_SENDING));
                    return;
                }
            }
            throw new Exception();
        }
        catch (Exception e2) {
            logger.log(Level.INFO, "Exception in pauseResume", e2);
            throw new Exception(Localization.getString("mainWindow.error.pauseResume"));
        }
    }

    @Override
    public String getPauseResumeText() {
        if (this.isPaused()) {
            return Localization.getString("mainWindow.ui.resumeButton");
        }
        return Localization.getString("mainWindow.ui.pauseButton");
    }

    @Override
    public boolean isSending() {
        return this.controlState == Utils.ControlState.COMM_SENDING;
    }

    @Override
    public boolean isPaused() {
        return this.controlState == Utils.ControlState.COMM_SENDING_PAUSED;
    }

    @Override
    public boolean canPause() {
        return this.controlState == Utils.ControlState.COMM_SENDING;
    }

    @Override
    public boolean canCancel() {
        return this.controlState == Utils.ControlState.COMM_SENDING;
    }

    @Override
    public boolean canSend() {
        return this.controlState == Utils.ControlState.COMM_IDLE && this.gcodeFile != null;
    }

    @Override
    public void cancel() throws Exception {
        if (this.canCancel()) {
            this.controller.cancelSend();
            this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_IDLE));
        }
    }

    @Override
    public void returnToZero() throws Exception {
        this.controller.returnToHome();
        this.G91Mode = true;
        this.units = Utils.Units.MM;
    }

    @Override
    public void resetCoordinatesToZero() throws Exception {
        this.controller.resetCoordinatesToZero();
    }

    @Override
    public void resetCoordinateToZero(char coordinate) throws Exception {
        this.controller.resetCoordinateToZero(coordinate);
    }

    @Override
    public void killAlarmLock() throws Exception {
        this.controller.killAlarmLock();
    }

    @Override
    public void performHomingCycle() throws Exception {
        this.controller.performHomingCycle();
    }

    @Override
    public void toggleCheckMode() throws Exception {
        this.controller.toggleCheckMode();
    }

    @Override
    public void issueSoftReset() throws Exception {
        this.controller.issueSoftReset();
    }

    @Override
    public void requestParserState() throws Exception {
        this.controller.viewParserState();
    }

    @Override
    public void fileStreamComplete(String filename, boolean success) {
        this.sendControlStateEvent(new ControlStateEvent(Utils.ControlState.COMM_IDLE));
    }

    @Override
    public void commandQueued(GcodeCommand command) {
    }

    @Override
    public void commandSent(GcodeCommand command) {
    }

    @Override
    public void commandComplete(GcodeCommand command) {
        String gcodeString = command.getCommandString().toLowerCase();
        Utils.Units before = this.units;
        if (gcodeString.contains("g21")) {
            this.units = Utils.Units.MM;
        } else if (gcodeString.contains("g20")) {
            this.units = Utils.Units.INCH;
        }
        this.controller.currentUnits(this.units);
    }

    @Override
    public void commandComment(String comment) {
        this.lastComment = comment;
    }

    @Override
    public void messageForConsole(String msg, Boolean verbose) {
    }

    @Override
    public void statusStringListener(String state, Point3d machineCoord, Point3d workCoord) {
        this.activeState = state;
        this.machineCoord = machineCoord;
        this.workCoord = workCoord;
    }

    @Override
    public void postProcessData(int numRows) {
    }

    @Override
    public void applySettingsToController(Settings settings, IController controller) throws Exception {
        if (settings == null) {
            throw new Exception("Programmer error.");
        }
        if (settings.isOverrideSpeedSelected()) {
            double value = settings.getOverrideSpeedValue();
            this.gcp.setSpeedOverride(value);
        } else {
            this.gcp.setSpeedOverride(-1.0);
        }
        try {
            this.gcp.setTruncateDecimalLength(settings.getTruncateDecimalLength());
            this.gcp.setRemoveAllWhitespace(settings.isRemoveAllWhitespace());
            this.gcp.setConvertArcsToLines(settings.isConvertArcsToLines());
            this.gcp.setSmallArcThreshold(settings.getSmallArcThreshold());
            this.gcp.setSmallArcSegmentLength(settings.getSmallArcSegmentLength());
            controller.getCommandCreator().setMaxCommandLength(settings.getMaxCommandLength());
            controller.setSingleStepMode(settings.isSingleStepMode());
            controller.setStatusUpdatesEnabled(settings.isStatusUpdatesEnabled());
            controller.setStatusUpdateRate(settings.getStatusUpdateRate());
        }
        catch (Exception ex) {
            StringBuilder message = new StringBuilder().append(Localization.getString("mainWindow.error.firmwareSetting")).append(": \n    ").append(Localization.getString("firmware.feature.maxCommandLength")).append("\n    ").append(Localization.getString("firmware.feature.truncateDecimal")).append("\n    ").append(Localization.getString("firmware.feature.singleStep")).append("\n    ").append(Localization.getString("firmware.feature.removeWhitespace")).append("\n    ").append(Localization.getString("firmware.feature.linesToArc")).append("\n    ").append(Localization.getString("firmware.feature.statusUpdates")).append("\n    ").append(Localization.getString("firmware.feature.statusUpdateRate"));
            throw new Exception(message.toString());
        }
    }

    private boolean openCommConnection(String port, int baudRate) throws Exception {
        boolean connected = false;
        try {
            connected = this.controller.openCommPort(port, baudRate);
            this.initializeProcessedLines(false);
        }
        catch (Exception e2) {
            logger.log(Level.INFO, "Exception in openCommConnection.", e2);
            throw new Exception(Localization.getString("mainWindow.error.connection") + " (" + e2.getClass().getName() + "): " + e2.getMessage());
        }
        return connected;
    }

    private void initializeProcessedLines(boolean forceReprocess) throws FileNotFoundException, IOException {
        if (this.gcodeFile != null) {
            Charset cs;
            try (FileReader fr = new FileReader(this.gcodeFile);){
                cs = Charset.forName(fr.getEncoding());
            }
            List<String> lines = Files.readAllLines(this.gcodeFile.toPath(), cs);
            System.out.println("Finished loading");
            long start = System.currentTimeMillis();
            if (this.processedCommandLines == null || forceReprocess) {
                this.processedCommandLines = this.gcp.preprocessCommands(lines);
            }
            long end = System.currentTimeMillis();
            System.out.println("Took " + (end - start) + "ms to preprocess");
            if (this.isConnected()) {
                this.estimatedSendDuration = -1L;
                Thread estimateThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GUIBackend.this.estimatedSendDuration = GUIBackend.this.controller.getJobLengthEstimate(GUIBackend.this.processedCommandLines);
                    }
                });
                estimateThread.start();
            }
        }
    }

    private void sendControlStateEvent(ControlStateEvent event2) {
        if (event2.getEventType() == ControlStateEvent.event.STATE_CHANGED) {
            this.controlState = event2.getState();
        }
        for (ControlStateListener l2 : this.controlStateListeners) {
            logger.info("Sending control state change.");
            l2.ControlStateEvent(event2);
        }
    }
}

