/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.pendantui;

import com.google.gson.Gson;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.model.BackendAPI;
import com.willwinder.universalgcodesender.model.Utils;
import com.willwinder.universalgcodesender.pendantui.PendantURLBean;
import com.willwinder.universalgcodesender.pendantui.SystemStateBean;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.vecmath.Point3d;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;

public class PendantUI
implements ControllerListener {
    private static final Logger logger = Logger.getLogger(PendantUI.class.getName());
    private BackendAPI mainWindow;
    private Server server = null;
    private int port = 8080;
    private SystemStateBean systemState = new SystemStateBean();

    public PendantUI(BackendAPI mainWindow) {
        this.mainWindow = mainWindow;
    }

    public Resource getBaseResource() {
        try {
            URL res = this.getClass().getResource("/resources/pendantUI");
            return Resource.newResource(res);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public List<PendantURLBean> start() {
        this.server = new Server(this.port);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setBaseResource(this.getBaseResource());
        resourceHandler.setDirectoriesListed(true);
        ContextHandler sendGcodeContext = new ContextHandler();
        sendGcodeContext.setContextPath("/sendGcode");
        sendGcodeContext.setBaseResource(this.getBaseResource());
        sendGcodeContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        sendGcodeContext.setHandler(new SendGcodeHandler());
        ContextHandler adjustManualLocationContext = new ContextHandler();
        adjustManualLocationContext.setContextPath("/adjustManualLocation");
        adjustManualLocationContext.setBaseResource(this.getBaseResource());
        adjustManualLocationContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        adjustManualLocationContext.setHandler(new AdjustManualLocationHandler());
        ContextHandler getSystemStateContext = new ContextHandler();
        getSystemStateContext.setContextPath("/getSystemState");
        getSystemStateContext.setBaseResource(this.getBaseResource());
        getSystemStateContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        getSystemStateContext.setHandler(new GetSystemStateHandler());
        ContextHandler configContext = new ContextHandler();
        configContext.setContextPath("/config");
        configContext.setBaseResource(this.getBaseResource());
        configContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        configContext.setHandler(new ConfigHandler());
        configContext.setInitParameter("cacheControl", "max-age=0, public");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{configContext, sendGcodeContext, adjustManualLocationContext, getSystemStateContext, resourceHandler, new DefaultHandler()});
        this.server.setHandler(handlers);
        try {
            this.server.start();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return this.getUrlList();
    }

    public List<PendantURLBean> getUrlList() {
        Enumeration<NetworkInterface> networkInterfaceEnum;
        ArrayList<PendantURLBean> out = new ArrayList<PendantURLBean>();
        try {
            networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e2) {
            throw new RuntimeException(e2);
        }
        while (networkInterfaceEnum.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
            Enumeration<InetAddress> addressEnum = networkInterface.getInetAddresses();
            while (addressEnum.hasMoreElements()) {
                InetAddress addr = addressEnum.nextElement();
                String hostAddress = addr.getHostAddress();
                if (hostAddress.contains(":") || hostAddress.equals("127.0.0.1")) continue;
                String url = "http://" + hostAddress + ":" + this.port;
                ByteArrayOutputStream bout = QRCode.from(url).to(ImageType.PNG).stream();
                out.add(new PendantURLBean(url, bout.toByteArray()));
                System.out.println("Listening on: " + url);
            }
        }
        return out;
    }

    public String getSystemStateJson() {
        return new Gson().toJson(this.systemState);
    }

    public int parseInt(String string) {
        int out = 0;
        try {
            out = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public double parseDouble(String string) {
        double out = 0.0;
        try {
            out = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isManualControlEnabled() {
        switch (this.systemState.getControlState()) {
            case COMM_DISCONNECTED: {
                return false;
            }
            case COMM_IDLE: {
                return true;
            }
            case COMM_SENDING: {
                return false;
            }
        }
        return true;
    }

    public BackendAPI getMainWindow() {
        return this.mainWindow;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setMainWindow(BackendAPI mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Override
    public void fileStreamComplete(String filename, boolean success) {
    }

    @Override
    public void commandQueued(GcodeCommand command) {
    }

    @Override
    public void commandSent(GcodeCommand command) {
    }

    @Override
    public void commandComplete(GcodeCommand command) {
    }

    @Override
    public void commandComment(String comment) {
    }

    @Override
    public void messageForConsole(String msg, Boolean verbose) {
    }

    @Override
    public void statusStringListener(String state, Point3d machineCoord, Point3d workCoord) {
    }

    @Override
    public void postProcessData(int numRows) {
    }

    public SystemStateBean getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemStateBean systemState) {
        this.systemState = systemState;
    }

    public class AdjustManualLocationHandler
    extends AbstractHandler {
        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (PendantUI.this.isManualControlEnabled()) {
                int dirX = PendantUI.this.parseInt(baseRequest.getParameter("dirX"));
                int dirY = PendantUI.this.parseInt(baseRequest.getParameter("dirY"));
                int dirZ = PendantUI.this.parseInt(baseRequest.getParameter("dirZ"));
                double stepSize = PendantUI.this.parseDouble(baseRequest.getParameter("stepSize"));
                try {
                    PendantUI.this.mainWindow.adjustManualLocation(dirX, dirY, dirZ, stepSize, Utils.Units.UNKNOWN);
                }
                catch (Exception e2) {
                    logger.warning(e2.getMessage());
                }
            }
            response.getWriter().print(PendantUI.this.systemState.getControlState().name());
        }
    }

    public class ConfigHandler
    extends AbstractHandler {
        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentType("application/json");
            response.getWriter().print(new Gson().toJson(PendantUI.this.mainWindow.getSettings().getPendantConfig()));
        }
    }

    public class GetSystemStateHandler
    extends AbstractHandler {
        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            PendantUI.this.mainWindow.updateSystemState(PendantUI.this.systemState);
            response.getWriter().print(PendantUI.this.getSystemStateJson());
        }
    }

    public class SendGcodeHandler
    extends AbstractHandler {
        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            String gCode = baseRequest.getParameter("gCode");
            try {
                if (PendantUI.this.isManualControlEnabled()) {
                    switch (gCode) {
                        case "$H": {
                            PendantUI.this.mainWindow.getController().performHomingCycle();
                            break;
                        }
                        case "$X": {
                            PendantUI.this.mainWindow.getController().killAlarmLock();
                            break;
                        }
                        case "$C": {
                            PendantUI.this.mainWindow.getController().toggleCheckMode();
                            break;
                        }
                        case "RESET_ZERO": {
                            PendantUI.this.mainWindow.resetCoordinatesToZero();
                            break;
                        }
                        case "RETURN_TO_ZERO": {
                            PendantUI.this.mainWindow.returnToZero();
                            break;
                        }
                        case "SEND_FILE": {
                            PendantUI.this.mainWindow.send();
                            break;
                        }
                        default: {
                            PendantUI.this.mainWindow.sendGcodeCommand(gCode);
                            break;
                        }
                    }
                } else {
                    switch (gCode) {
                        case "PAUSE_RESUME_FILE": {
                            PendantUI.this.mainWindow.pauseResume();
                            break;
                        }
                        case "CANCEL_FILE": {
                            PendantUI.this.mainWindow.cancel();
                            break;
                        }
                    }
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Exception in pendant.", e2);
                logger.warning(Localization.getString("SendGcodeHandler"));
            }
            response.getWriter().print(PendantUI.this.getSystemStateJson());
        }
    }
}

