/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.types;

import com.willwinder.universalgcodesender.gcode.GcodePreprocessorUtils;

public class GcodeCommand {
    private String command;
    private String response;
    private String responseType;
    private Boolean sent = false;
    private Boolean done = false;
    private Boolean isOk = false;
    private Boolean isError = false;
    private Integer commandNum = -1;
    private Boolean isSkipped = false;
    private boolean isComment = false;
    private boolean hasComment = false;
    private String comment;

    public GcodeCommand(String command) {
        this(command, -1);
    }

    public GcodeCommand(String command, int num) {
        this.command = command;
        this.commandNum = num;
        this.comment = GcodePreprocessorUtils.parseComment(command);
        boolean bl = this.hasComment = this.comment.length() > 0;
        if (this.hasComment) {
            this.command = GcodePreprocessorUtils.removeComment(command);
            if (this.command.trim().length() == 0) {
                this.isComment = true;
            }
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandNumber(int i2) {
        this.commandNum = i2;
    }

    public void setResponse(String response) {
        this.response = response;
        this.parseResponse();
        this.done = this.isDone();
    }

    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    public void setSkipped(Boolean skipped) {
        this.isSkipped = skipped;
    }

    public String toString() {
        return this.getCommandString() + "(" + this.commandNum + ")";
    }

    public String getCommandString() {
        return this.command;
    }

    public int getCommandNumber() {
        return this.commandNum;
    }

    public String getResponse() {
        return this.response;
    }

    public Boolean isSent() {
        return this.sent;
    }

    public Boolean isOk() {
        return this.isOk;
    }

    public Boolean isError() {
        return this.isError;
    }

    public Boolean isSkipped() {
        return this.isSkipped;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public boolean hasComment() {
        return this.hasComment;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean parseResponse() {
        if (this.response.length() < 0) {
            this.isOk = false;
            this.isError = false;
        }
        if (this.response.toLowerCase().equals("ok")) {
            this.isOk = true;
            this.isError = false;
        } else if (this.response.toLowerCase().startsWith("error")) {
            this.isOk = false;
            this.isError = true;
        }
        return this.isOk;
    }

    public String responseString() {
        String returnString = "";
        String number = "";
        if (this.commandNum != -1) {
            number = this.commandNum.toString();
        }
        if (this.isOk.booleanValue()) {
            returnString = "ok" + number;
        } else if (this.isError.booleanValue()) {
            returnString = "error" + number + "[" + this.response.substring("error: ".length()) + "]";
        }
        return returnString;
    }

    public Boolean isDone() {
        return this.response != null;
    }

    public static Boolean isOkErrorResponse(String response) {
        if (response.toLowerCase().equals("ok")) {
            return true;
        }
        if (response.toLowerCase().startsWith("error")) {
            return true;
        }
        return false;
    }
}

