/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.uielements;

import com.willwinder.universalgcodesender.i18n.AvailableLanguages;
import com.willwinder.universalgcodesender.i18n.Language;
import com.willwinder.universalgcodesender.i18n.Localization;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class ConnectionSettingsDialog
extends JDialog {
    private boolean saveChanges;
    private JButton closeWithSave;
    private JButton closeWithoutSave;
    private JCheckBox convertArcsToLinesCheckBox;
    private JCheckBox displayStateColor;
    private JButton helpButton;
    private JComboBox languageBox;
    private JLabel maxCommandLengthLabel;
    private JSpinner maxCommandLengthSpinner;
    private JCheckBox overrideSpeedCheckBox;
    private JLabel overrideSpeedPercentLabel;
    private JSpinner overrideSpeedPercentSpinner;
    private JCheckBox removeAllWhitespaceCheckBox;
    private JCheckBox sendStatusPolls;
    private JCheckBox singleStepModeCheckBox;
    private JLabel smallArcSegmentLengthLabel;
    private JSpinner smallArcSegmentLengthSpinner;
    private JLabel smallArcThresholdLabel;
    private JSpinner smallArcThresholdSpinner;
    private JSpinner statusPollRateSpinner;
    private JLabel statusPollingRate;
    private JLabel titleLabel;
    private JLabel truncateDecimalDigitsLabel;
    private JSpinner truncateDecimalDigitsSpinner;

    public ConnectionSettingsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.languageBox.removeAllItems();
        Vector<Language> al = AvailableLanguages.getAvailableLanguages();
        for (Language language : al) {
            this.languageBox.addItem(language);
        }
        this.initLocalization();
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(0);
        this.saveChanges = false;
    }

    private void initLocalization() {
        this.titleLabel.setText(Localization.getString("sender.header"));
        this.overrideSpeedCheckBox.setText(Localization.getString("sender.speed.override"));
        this.overrideSpeedPercentLabel.setText(Localization.getString("sender.speed.percent"));
        this.maxCommandLengthLabel.setText(Localization.getString("sender.command.length"));
        this.truncateDecimalDigitsLabel.setText(Localization.getString("sender.truncate"));
        this.singleStepModeCheckBox.setText(Localization.getString("sender.singlestep"));
        this.removeAllWhitespaceCheckBox.setText(Localization.getString("sender.whitespace"));
        this.sendStatusPolls.setText(Localization.getString("sender.status"));
        this.statusPollingRate.setText(Localization.getString("sender.status.rate"));
        this.displayStateColor.setText(Localization.getString("sender.state"));
        this.convertArcsToLinesCheckBox.setText(Localization.getString("sender.arcs"));
        this.smallArcSegmentLengthLabel.setText(Localization.getString("sender.arcs.length"));
        this.smallArcThresholdLabel.setText(Localization.getString("sender.arcs.threshold"));
        this.closeWithSave.setText(Localization.getString("save.close"));
        this.closeWithoutSave.setText(Localization.getString("close"));
        this.helpButton.setText(Localization.getString("help"));
    }

    public boolean saveChanges() {
        return this.saveChanges;
    }

    public boolean getSpeedOverrideEnabled() {
        return this.overrideSpeedCheckBox.isSelected();
    }

    public boolean getSingleStepModeEnabled() {
        return this.singleStepModeCheckBox.isSelected();
    }

    public int getSpeedOverridePercent() {
        return Integer.parseInt(this.overrideSpeedPercentSpinner.getValue().toString());
    }

    public int getMaxCommandLength() {
        return Integer.parseInt(this.maxCommandLengthSpinner.getValue().toString());
    }

    public int getTruncateDecimalLength() {
        return Integer.parseInt(this.truncateDecimalDigitsSpinner.getValue().toString());
    }

    public boolean getRemoveAllWhitespace() {
        return this.removeAllWhitespaceCheckBox.isSelected();
    }

    public boolean getStatusUpdatesEnabled() {
        return this.sendStatusPolls.isSelected();
    }

    public int getStatusUpdatesRate() {
        return Integer.parseInt(this.statusPollRateSpinner.getValue().toString());
    }

    public boolean getDisplayStateColor() {
        return this.displayStateColor.isSelected();
    }

    public boolean getConvertArcsToLines() {
        return this.convertArcsToLinesCheckBox.isSelected();
    }

    public double getSmallArcThreshold() {
        return (Double)this.smallArcThresholdSpinner.getValue();
    }

    public double getSmallArcSegmentLength() {
        return (Double)this.smallArcSegmentLengthSpinner.getValue();
    }

    public String getLanguage() {
        return ((Language)this.languageBox.getSelectedItem()).getLanguage() + "_" + ((Language)this.languageBox.getSelectedItem()).getRegion();
    }

    public void setSpeedOverrideEnabled(boolean enabled) {
        this.overrideSpeedCheckBox.setSelected(enabled);
    }

    public void setSpeedOverridePercent(int overridePercent) {
        this.overrideSpeedPercentSpinner.setValue(overridePercent);
    }

    public void setSingleStepModeEnabled(boolean enabled) {
        this.singleStepModeCheckBox.setSelected(enabled);
    }

    public void setMaxCommandLength(int commandLength) {
        this.maxCommandLengthSpinner.setValue(commandLength);
    }

    public void setTruncateDecimalLength(int truncateLength) {
        this.truncateDecimalDigitsSpinner.setValue(truncateLength);
    }

    public void setRemoveAllWhitespace(boolean enabled) {
        this.removeAllWhitespaceCheckBox.setSelected(enabled);
    }

    public void setStatusUpdatesEnabled(boolean enabled) {
        this.sendStatusPolls.setSelected(enabled);
    }

    public void setStatusUpdatesRate(int milliseconds) {
        this.statusPollRateSpinner.setValue(milliseconds);
    }

    public void setStateColorDisplayEnabled(boolean enabled) {
        this.displayStateColor.setSelected(enabled);
    }

    public void setConvertArcsToLines(boolean enabled) {
        this.convertArcsToLinesCheckBox.setSelected(enabled);
    }

    public void setSmallArcThreshold(double threshold) {
        this.smallArcThresholdSpinner.setValue(threshold);
    }

    public void setSmallArcSegmentLengthSpinner(double threshold) {
        this.smallArcSegmentLengthSpinner.setValue(threshold);
    }

    public void setselectedLanguage(String language) {
        Language l2 = AvailableLanguages.getLanguageByString(language);
        this.languageBox.setSelectedItem(l2);
    }

    private void initComponents() {
        this.overrideSpeedCheckBox = new JCheckBox();
        this.overrideSpeedPercentSpinner = new JSpinner();
        this.overrideSpeedPercentLabel = new JLabel();
        this.maxCommandLengthSpinner = new JSpinner();
        this.maxCommandLengthLabel = new JLabel();
        this.truncateDecimalDigitsLabel = new JLabel();
        this.truncateDecimalDigitsSpinner = new JSpinner();
        this.singleStepModeCheckBox = new JCheckBox();
        this.titleLabel = new JLabel();
        this.closeWithSave = new JButton();
        this.closeWithoutSave = new JButton();
        this.helpButton = new JButton();
        this.removeAllWhitespaceCheckBox = new JCheckBox();
        this.sendStatusPolls = new JCheckBox();
        this.statusPollingRate = new JLabel();
        this.statusPollRateSpinner = new JSpinner();
        this.displayStateColor = new JCheckBox();
        this.convertArcsToLinesCheckBox = new JCheckBox();
        this.smallArcThresholdLabel = new JLabel();
        this.smallArcThresholdSpinner = new JSpinner();
        this.smallArcSegmentLengthLabel = new JLabel();
        this.smallArcSegmentLengthSpinner = new JSpinner();
        this.languageBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.overrideSpeedCheckBox.setText("Enable speed override");
        this.overrideSpeedPercentSpinner.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        this.overrideSpeedPercentLabel.setText("Speed override percent");
        this.maxCommandLengthSpinner.setModel(new SpinnerNumberModel((Number)50, Integer.valueOf(1), null, (Number)1));
        this.maxCommandLengthLabel.setText("Max command length");
        this.truncateDecimalDigitsLabel.setText("Truncate decimal digits");
        this.truncateDecimalDigitsSpinner.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(1), null, (Number)1));
        this.singleStepModeCheckBox.setText("Enable single step mode");
        this.titleLabel.setFont(new Font("Dialog", 0, 18));
        this.titleLabel.setText("Connection Settings");
        this.closeWithSave.setText("Save and close");
        this.closeWithSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionSettingsDialog.this.closeWithSaveActionPerformed(evt);
            }
        });
        this.closeWithoutSave.setText("Close");
        this.closeWithoutSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionSettingsDialog.this.closeWithoutSaveActionPerformed(evt);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionSettingsDialog.this.helpButtonActionPerformed(evt);
            }
        });
        this.removeAllWhitespaceCheckBox.setText("Remove all whitespace in commands");
        this.sendStatusPolls.setText("Enable status polling");
        this.statusPollingRate.setText("Status poll rate (ms)");
        this.statusPollRateSpinner.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        this.displayStateColor.setText("Enable state color display");
        this.convertArcsToLinesCheckBox.setText("Convert arcs to lines");
        this.smallArcThresholdLabel.setText("Small arc threshold (mm)");
        this.smallArcThresholdSpinner.setModel(new SpinnerNumberModel((Number)2.0, Double.valueOf(0.0), null, (Number)0.1));
        this.smallArcSegmentLengthLabel.setText("Small arc segment length (mm)");
        this.smallArcSegmentLengthSpinner.setModel(new SpinnerNumberModel((Number)1.3, Double.valueOf(0.0), null, (Number)0.1));
        this.languageBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeWithoutSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeWithSave).addGap(24, 24, 24)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(38, 38, 38).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeAllWhitespaceCheckBox).addComponent(this.singleStepModeCheckBox).addComponent(this.overrideSpeedCheckBox))).addComponent(this.titleLabel)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.overrideSpeedPercentSpinner, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overrideSpeedPercentLabel)).addGroup(layout.createSequentialGroup().addComponent(this.maxCommandLengthSpinner, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxCommandLengthLabel)).addGroup(layout.createSequentialGroup().addComponent(this.truncateDecimalDigitsSpinner, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.truncateDecimalDigitsLabel))).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.statusPollRateSpinner, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPollingRate)).addGroup(layout.createSequentialGroup().addGap(38, 38, 38).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sendStatusPolls).addComponent(this.displayStateColor).addComponent(this.convertArcsToLinesCheckBox))).addGroup(layout.createSequentialGroup().addComponent(this.smallArcThresholdSpinner, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smallArcThresholdLabel)).addGroup(layout.createSequentialGroup().addComponent(this.smallArcSegmentLengthSpinner, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smallArcSegmentLengthLabel)).addComponent(this.languageBox, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addGap(18, 18, 18).addComponent(this.overrideSpeedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.overrideSpeedPercentLabel).addComponent(this.overrideSpeedPercentSpinner, -1, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.maxCommandLengthSpinner, -1, -1, -2).addComponent(this.maxCommandLengthLabel)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.truncateDecimalDigitsSpinner, -1, -1, -2).addComponent(this.truncateDecimalDigitsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleStepModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAllWhitespaceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendStatusPolls).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusPollingRate).addComponent(this.statusPollRateSpinner, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayStateColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.convertArcsToLinesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.smallArcThresholdLabel).addComponent(this.smallArcThresholdSpinner, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.smallArcSegmentLengthLabel).addComponent(this.smallArcSegmentLengthSpinner, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeWithSave).addComponent(this.closeWithoutSave).addComponent(this.helpButton)).addContainerGap()));
        this.pack();
    }

    private void closeWithoutSaveActionPerformed(ActionEvent evt) {
        this.saveChanges = false;
        this.setVisible(false);
    }

    private void closeWithSaveActionPerformed(ActionEvent evt) {
        this.saveChanges = true;
        this.setVisible(false);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        StringBuilder message = new StringBuilder().append(Localization.getString("sender.help.speed.override")).append("\n\n").append(Localization.getString("sender.help.speed.percent")).append("\n\n").append(Localization.getString("sender.help.command.length")).append("\n\n").append(Localization.getString("sender.help.truncate")).append("\n\n").append(Localization.getString("sender.help.singlestep")).append("\n\n").append(Localization.getString("sender.help.whitespace")).append("\n\n").append(Localization.getString("sender.help.status")).append("\n\n").append(Localization.getString("sender.help.status.rate")).append("\n\n").append(Localization.getString("sender.help.state")).append("\n\n").append(Localization.getString("sender.help.arcs")).append("\n\n").append(Localization.getString("sender.help.arcs.threshold")).append("\n\n").append(Localization.getString("sender.help.arcs.length"));
        JOptionPane.showMessageDialog(new JFrame(), message, Localization.getString("sender.help.dialog.title"), 1);
    }
}

