/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.uielements;

import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class FPSCounter {
    public static final int UPPER_LEFT = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int LOWER_LEFT = 3;
    public static final int LOWER_RIGHT = 4;
    private int textLocation = 4;
    private GLDrawable drawable;
    private TextRenderer renderer;
    private static final DecimalFormat format = new DecimalFormat("####.00");
    private int frameCount;
    private long startTime;
    private String fpsText;
    private int fpsMagnitude;
    private int fpsWidth;
    private int fpsHeight;
    private int fpsOffset;

    public FPSCounter(GLDrawable drawable, int textSize) throws GLException {
        this(drawable, new Font("SansSerif", 1, textSize));
    }

    public FPSCounter(GLDrawable drawable, Font font) throws GLException {
        this(drawable, font, true, true);
    }

    public FPSCounter(GLDrawable drawable, Font font, boolean antialiased, boolean useFractionalMetrics) throws GLException {
        this.drawable = drawable;
        this.renderer = new TextRenderer(font, antialiased, useFractionalMetrics);
    }

    public int getTextLocation() {
        return this.textLocation;
    }

    public void setTextLocation(int textLocation) {
        if (textLocation < 1 || textLocation > 4) {
            throw new IllegalArgumentException("textLocation");
        }
        this.textLocation = textLocation;
    }

    public void setColor(float r, float g2, float b2, float a2) throws GLException {
        this.renderer.setColor(r, g2, b2, a2);
    }

    public void draw() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (++this.frameCount >= 100) {
            long endTime = System.currentTimeMillis();
            float fps = 100.0f / (float)(endTime - this.startTime) * 1000.0f;
            this.recomputeFPSSize(fps);
            this.frameCount = 0;
            this.startTime = System.currentTimeMillis();
            this.fpsText = "FPS: " + format.format(fps);
        }
        if (this.fpsText != null) {
            this.renderer.beginRendering(this.drawable.getSurfaceWidth(), this.drawable.getSurfaceHeight());
            int x = 0;
            int y = 0;
            switch (this.textLocation) {
                case 1: {
                    x = this.fpsOffset;
                    y = this.drawable.getSurfaceHeight() - this.fpsHeight - this.fpsOffset;
                    break;
                }
                case 2: {
                    x = this.drawable.getSurfaceWidth() - this.fpsWidth - this.fpsOffset;
                    y = this.drawable.getSurfaceHeight() - this.fpsHeight - this.fpsOffset;
                    break;
                }
                case 3: {
                    x = this.fpsOffset;
                    y = this.fpsOffset;
                    break;
                }
                case 4: {
                    x = this.drawable.getSurfaceWidth() - this.fpsWidth - this.fpsOffset;
                    y = this.fpsOffset;
                }
            }
            this.renderer.draw(this.fpsText, x, y);
            this.renderer.endRendering();
        }
    }

    private void recomputeFPSSize(float fps) {
        int magnitude;
        String fpsText;
        if (fps >= 10000.0f) {
            fpsText = "10000.00";
            magnitude = 5;
        } else if (fps >= 1000.0f) {
            fpsText = "1000.00";
            magnitude = 4;
        } else if (fps >= 100.0f) {
            fpsText = "100.00";
            magnitude = 3;
        } else if (fps >= 10.0f) {
            fpsText = "10.00";
            magnitude = 2;
        } else {
            fpsText = "9.00";
            magnitude = 1;
        }
        if (magnitude > this.fpsMagnitude) {
            Rectangle2D bounds = this.renderer.getBounds("FPS: " + fpsText);
            this.fpsWidth = (int)bounds.getWidth();
            this.fpsHeight = (int)bounds.getHeight();
            this.fpsOffset = (int)((float)this.fpsHeight * 0.5f);
            this.fpsMagnitude = magnitude;
        }
    }
}

