/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.uielements;

import com.willwinder.universalgcodesender.types.GcodeCommand;
import com.willwinder.universalgcodesender.uielements.GcodeTableModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class GcodeTable
extends JTable {
    private boolean autoWindowScroll = false;
    private int offset = 0;
    private static final int COL_INDEX_COMMAND = 0;
    private static final int COL_INDEX_SENT = 1;
    private static final int COL_INDEX_DONE = 2;
    private static final int COL_INDEX_RESPONSE = 3;

    public GcodeTable() {
        this.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setPreferredColumnWidths(new double[]{0.55, 0.2, 0.2, 0.2});
        this.getColumnModel().getColumn(1).setResizable(false);
        this.getColumnModel().getColumn(1).setMaxWidth(50);
        this.getColumnModel().getColumn(2).setResizable(false);
        this.getColumnModel().getColumn(2).setMaxWidth(50);
    }

    public void setAutoWindowScroll(boolean autoWindowScroll) {
        this.autoWindowScroll = autoWindowScroll;
    }

    public void clear() {
        while (this.getModel().getRowCount() > 0) {
            ((GcodeTableModel)this.getModel()).removeRow(0);
        }
        this.offset = 0;
    }

    public void addRow(GcodeCommand command) {
        String commandString = command.getCommandString();
        if (command.isComment()) {
            commandString = "; " + command.getComment();
        } else if (command.hasComment()) {
            commandString = commandString + "; " + command.getComment();
        }
        ((GcodeTableModel)this.getModel()).addRow(new Object[]{commandString, command.isSent(), command.isDone(), command.getResponse()});
        this.scrollTable(this.getRowCount());
    }

    public void updateRow(GcodeCommand command) {
        String commandString = command.getCommandString();
        int row = command.getCommandNumber() + this.offset;
        if (!command.isComment() && commandString != this.getModel().getValueAt(row, 0)) {
            System.out.printf("Row mismatch [%s] does not match row %d [%s].]\n", commandString, row, this.getModel().getValueAt(row, 0));
        }
        this.getModel().setValueAt(command.isSent(), row, 1);
        this.getModel().setValueAt(command.isDone(), row, 2);
        this.getModel().setValueAt(command.getResponse(), row, 3);
        this.scrollTable(row);
    }

    private void scrollTable(int toRow) {
        if (this.autoWindowScroll && this.isVisible()) {
            this.scrollToVisible(toRow);
        }
    }

    private void setPreferredColumnWidths(double[] percentages) {
        int i2;
        Dimension tableDim = this.getPreferredSize();
        double total = 0.0;
        for (i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
            total += percentages[i2];
        }
        for (i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
            TableColumn column = this.getColumnModel().getColumn(i2);
            column.setPreferredWidth((int)((double)tableDim.width * (percentages[i2] / total)));
        }
    }

    private void scrollToVisible(int rowIndex) {
        this.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
        this.scrollRectToVisible(new Rectangle(this.getCellRect(rowIndex, 0, true)));
    }

    public void setOffset() {
        this.setOffset(this.getRowCount());
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

