/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.uielements;

import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.model.BackendAPI;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import com.willwinder.universalgcodesender.uielements.TableCellListener;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.vecmath.Point3d;

public class GrblFirmwareSettingsDialog
extends JDialog
implements ControllerListener {
    private BackendAPI grblController;
    private TableCellListener tcl;
    private int numberOfSettings = 0;
    private boolean loadingSettings;
    private String[] commands = null;
    private static final int COL_INDEX_SETTING = 0;
    private static final int COL_INDEX_VALUE = 1;
    private static final int COL_INDEX_DESCRIPTION = 2;
    private static final String settingNumRegex = "\\$(\\d*)";
    private static final String settingValueRegex = "\\=(\\d*\\.?\\d*)";
    private static final String commentRegex = "\\(.*\\)";
    private Pattern settingNumPattern;
    private Pattern settingValuePattern;
    private Pattern commentPattern;
    boolean initialSingleStepMode;
    boolean statusUpdatesEnabled;
    boolean savingSettings;
    private JButton closeButton;
    private JButton saveButton;
    private JTable settingsTable;
    private JScrollPane settingsTableScrollPane;

    public GrblFirmwareSettingsDialog(Frame parent, boolean modal, BackendAPI backend) throws Exception {
        super(parent, modal);
        this.initComponents();
        this.initLocalization();
        this.setLocationRelativeTo(parent);
        if (backend == null) {
            throw new Exception("There is no controller. Are you connected?");
        }
        this.grblController = backend;
        this.grblController.addControllerListener(this);
        this.loadingSettings = false;
        this.settingNumPattern = Pattern.compile(settingNumRegex);
        this.settingValuePattern = Pattern.compile(settingValueRegex);
        this.commentPattern = Pattern.compile(commentRegex);
        this.initSettings();
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TableCellListener tcl = (TableCellListener)e2.getSource();
                GrblFirmwareSettingsDialog.this.handleSettingChange(tcl.getRow(), tcl.getColumn(), tcl.getOldValue(), tcl.getNewValue());
            }
        };
        this.tcl = new TableCellListener(this.settingsTable, action);
    }

    private void initSettings() throws Exception {
        this.loadingSettings = true;
        this.grblController.sendGcodeCommand("$$");
    }

    private void checkDoneSavingSettings() {
        if (this.savingSettings && !this.grblController.isSending()) {
            this.grblController.getController().setSingleStepMode(this.initialSingleStepMode);
            this.grblController.getController().setStatusUpdatesEnabled(this.statusUpdatesEnabled);
            this.savingSettings = false;
        }
    }

    @Override
    public void messageForConsole(String msg, Boolean verbose) {
        if (this.loadingSettings) {
            if ("ok".equals(msg)) {
                this.loadingSettings = false;
            } else if (this.isSettingString(msg)) {
                this.addSetting(msg);
                ++this.numberOfSettings;
            }
        }
        if (this.savingSettings) {
            this.checkDoneSavingSettings();
        }
    }

    private boolean isSettingString(String msg) {
        if (msg.startsWith("$$")) {
            return false;
        }
        return msg.startsWith("$");
    }

    private void addSetting(String msg) {
        Matcher matcher = this.settingNumPattern.matcher(msg);
        if (!matcher.find()) {
            return;
        }
        String setting = matcher.group();
        matcher = this.settingValuePattern.matcher(msg);
        if (!matcher.find()) {
            return;
        }
        String value = matcher.group(1);
        matcher = this.commentPattern.matcher(msg);
        if (!matcher.find()) {
            return;
        }
        String comment = matcher.group();
        this.addSetting(setting, value, comment);
    }

    private void addSetting(String setting, String value, String description) {
        ((DefaultTableModel)this.settingsTable.getModel()).addRow(new String[]{setting, value, description});
    }

    private void updateSetting(int row, String setting, String value, String description) {
        this.settingsTable.getModel().setValueAt(setting, row, 0);
        this.settingsTable.getModel().setValueAt(value, row, 1);
        this.settingsTable.getModel().setValueAt(description, row, 2);
    }

    private void handleSettingChange(int row, int column, Object oldValue, Object newValue) {
        String command;
        if (this.commands == null && this.numberOfSettings > 0) {
            this.commands = new String[this.numberOfSettings];
        }
        if (row > this.commands.length) {
            String[] before = this.commands;
            this.commands = new String[this.numberOfSettings];
            System.arraycopy(before, 0, this.commands, 0, before.length);
        }
        String setting = this.settingsTable.getModel().getValueAt(row, 0).toString();
        this.commands[row] = command = setting + "=" + newValue;
    }

    private void initLocalization() {
        this.closeButton.setText(Localization.getString("close"));
        this.saveButton.setText(Localization.getString("save"));
        TableColumnModel tcm = this.settingsTable.getTableHeader().getColumnModel();
        tcm.getColumn(0).setHeaderValue(Localization.getString("setting"));
        tcm.getColumn(1).setHeaderValue(Localization.getString("value"));
        tcm.getColumn(2).setHeaderValue(Localization.getString("description"));
        this.settingsTable.getTableHeader().repaint();
    }

    private void initComponents() {
        this.saveButton = new JButton();
        this.closeButton = new JButton();
        this.settingsTableScrollPane = new JScrollPane();
        this.settingsTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrblFirmwareSettingsDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrblFirmwareSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.settingsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Setting", "Value", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTableScrollPane.setViewportView(this.settingsTable);
        this.settingsTable.getColumnModel().getColumn(0).setMinWidth(50);
        this.settingsTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.settingsTable.getColumnModel().getColumn(1).setPreferredWidth(85);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()).addComponent(this.settingsTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 510, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.settingsTableScrollPane, -1, 245, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.closeButton)).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.savingSettings) {
            JOptionPane.showMessageDialog(new JFrame(), "Cannot close dialog until settings have finished being saved.\nIf we got here by mistake open a bug report on github.", "Error", 0);
        } else {
            this.setVisible(false);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.settingsTable.editCellAt(-1, -1);
        if (this.grblController.isSending()) {
            JOptionPane.showMessageDialog(new JFrame(), "Cannot update firmware while it is busy.", "Error", 0);
            return;
        }
        this.initialSingleStepMode = this.grblController.getController().getSingleStepMode();
        this.statusUpdatesEnabled = this.grblController.getController().getStatusUpdatesEnabled();
        this.grblController.getController().setSingleStepMode(true);
        this.grblController.getController().setStatusUpdatesEnabled(false);
        this.savingSettings = true;
        try {
            for (int i2 = 0; i2 < this.commands.length; ++i2) {
                String command = this.commands[i2];
                if (command == null) continue;
                this.grblController.getController().setSingleStepMode(true);
                this.grblController.getController().setStatusUpdatesEnabled(false);
                this.grblController.sendGcodeCommand(command);
                this.commands[i2] = null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(new JFrame(), "Error from firmware while saving settings: " + ex.getMessage(), "Error", 0);
        }
    }

    @Override
    public void fileStreamComplete(String filename, boolean success) {
    }

    @Override
    public void commandComplete(GcodeCommand command) {
    }

    @Override
    public void commandQueued(GcodeCommand command) {
    }

    @Override
    public void commandSent(GcodeCommand command) {
    }

    @Override
    public void commandComment(String comment) {
    }

    @Override
    public void statusStringListener(String state, Point3d machineCoord, Point3d workCoord) {
    }

    @Override
    public void postProcessData(int numRows) {
    }
}

