/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.uielements;

import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class Overlay {
    public static final int UPPER_LEFT = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int LOWER_LEFT = 3;
    public static final int LOWER_RIGHT = 4;
    private int textLocation = 4;
    private GLDrawable drawable;
    private TextRenderer renderer;
    private int width;
    private int height;
    private int offset;

    public Overlay(GLDrawable drawable, int textSize) throws GLException {
        this(drawable, new Font("SansSerif", 1, textSize));
    }

    public Overlay(GLDrawable drawable, Font font) throws GLException {
        this(drawable, font, true, true);
    }

    public Overlay(GLDrawable drawable, Font font, boolean antialiased, boolean useFractionalMetrics) throws GLException {
        this.drawable = drawable;
        this.renderer = new TextRenderer(font, antialiased, useFractionalMetrics);
    }

    public int getTextLocation() {
        return this.textLocation;
    }

    public void setTextLocation(int textLocation) {
        if (textLocation < 1 || textLocation > 4) {
            throw new IllegalArgumentException("textLocation");
        }
        this.textLocation = textLocation;
    }

    public void setColor(float r, float g2, float b2, float a2) throws GLException {
        this.renderer.setColor(r, g2, b2, a2);
    }

    public void draw(String text) {
        if ((text = text.trim()) != null || text != "") {
            this.renderer.beginRendering(this.drawable.getSurfaceWidth(), this.drawable.getSurfaceHeight());
            Rectangle2D bounds = this.renderer.getBounds(text);
            this.width = (int)bounds.getWidth();
            this.height = (int)bounds.getHeight();
            this.offset = (int)((float)this.height * 0.5f);
            int x = 0;
            int y = 0;
            switch (this.textLocation) {
                case 1: {
                    x = this.offset;
                    y = this.drawable.getSurfaceHeight() - this.height - this.offset;
                    break;
                }
                case 2: {
                    x = this.drawable.getSurfaceWidth() - this.width - this.offset;
                    y = this.drawable.getSurfaceHeight() - this.height - this.offset;
                    break;
                }
                case 3: {
                    x = this.offset;
                    y = this.offset;
                    break;
                }
                case 4: {
                    x = this.drawable.getSurfaceWidth() - this.width - this.offset;
                    y = this.offset;
                }
            }
            this.renderer.draw(text, x, y);
            this.renderer.endRendering();
        }
    }
}

