/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.utils;

import com.willwinder.universalgcodesender.types.GcodeCommand;
import java.util.List;
import jssc.SerialPortList;

public class CommUtils {
    public static String[] getSerialPortList() {
        return SerialPortList.getPortNames();
    }

    public static Boolean checkRoomInBuffer(int sentBuffer, String nextCommand, int bufferSize) {
        if (nextCommand == null) {
            return false;
        }
        int characters = sentBuffer + nextCommand.length() + 1;
        return characters <= bufferSize;
    }

    public static Boolean checkRoomInBuffer(List<GcodeCommand> list, GcodeCommand nextCommand, int bufferSize) {
        String command = nextCommand.getCommandString();
        int characters = CommUtils.getSizeOfBuffer(list);
        return (characters += command.length() + 1) <= bufferSize;
    }

    public static synchronized int getSizeOfBuffer(List<GcodeCommand> list) {
        int characters = 0;
        for (GcodeCommand command : list) {
            String next = command.getCommandString();
            characters += next.length() + 1;
        }
        return characters;
    }
}

