/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.utils;

import com.willwinder.universalgcodesender.AbstractController;
import com.willwinder.universalgcodesender.GrblController;
import com.willwinder.universalgcodesender.TinyGController;
import com.willwinder.universalgcodesender.XLCDCommunicator;
import java.util.ArrayList;

public class FirmwareUtils {
    public static final String GRBL = "GRBL";
    public static final String Smoothie = "SmoothieBoard";
    public static final String TinyG = "TinyG";
    public static final String XLCD = "XLCD";

    public static ArrayList<String> getFirmwareList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(GRBL);
        ret.add(TinyG);
        ret.add(XLCD);
        return ret;
    }

    public static AbstractController getControllerFor(String firmware) {
        switch (firmware) {
            case "GRBL": {
                return new GrblController();
            }
            case "SmoothieBoard": {
                return null;
            }
            case "TinyG": {
                return new TinyGController();
            }
            case "XLCD": {
                return new GrblController(new XLCDCommunicator());
            }
        }
        return null;
    }
}

