/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.visualizer;

import com.willwinder.universalgcodesender.gcode.GcodeParser;
import com.willwinder.universalgcodesender.gcode.GcodePreprocessorUtils;
import com.willwinder.universalgcodesender.types.PointSegment;
import com.willwinder.universalgcodesender.visualizer.LineSegment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;

public class GcodeViewParse {
    boolean absoluteMode = true;
    static boolean absoluteIJK = false;
    private Point3d min = new Point3d();
    private Point3d max = new Point3d();
    private List<LineSegment> lines;
    private Point3d lastPoint = new Point3d();
    private int currentLine = 0;
    private boolean debug = true;

    public GcodeViewParse() {
        this.lines = new ArrayList<LineSegment>();
    }

    public Point3d getMinimumExtremes() {
        return this.min;
    }

    public Point3d getMaximumExtremes() {
        return this.max;
    }

    private void testExtremes(Point3d p3d) {
        this.testExtremes(p3d.x, p3d.y, p3d.z);
    }

    private void testExtremes(double x, double y, double z) {
        if (x < this.min.x) {
            this.min.x = x;
        }
        if (x > this.max.x) {
            this.max.x = x;
        }
        if (y < this.min.y) {
            this.min.y = y;
        }
        if (y > this.max.y) {
            this.max.y = y;
        }
        if (z < this.min.z) {
            this.min.z = z;
        }
        if (z > this.max.z) {
            this.max.z = z;
        }
    }

    public List<LineSegment> toObjRedux(List<String> gcode, double arcSegmentLength) {
        GcodeParser gp = new GcodeParser();
        for (String s : gcode) {
            gp.addCommand(s);
        }
        return this.getLinesFromParser(gp, arcSegmentLength);
    }

    private List<LineSegment> getLinesFromParser(GcodeParser gp, double arcSegmentLength) {
        List<PointSegment> psl = gp.getPointSegmentList();
        double minArcLength = 0.0;
        Point3d start = null;
        Point3d end = null;
        int num = 0;
        Iterator<PointSegment> iterator = psl.iterator();
        while (iterator.hasNext()) {
            PointSegment segment;
            PointSegment ps = segment = iterator.next();
            ps.convertToMetric();
            end = ps.point();
            if (start != null) {
                LineSegment ls;
                if (ps.isArc()) {
                    List<Point3d> points = GcodePreprocessorUtils.generatePointsAlongArcBDring(start, end, ps.center(), ps.isClockwise(), ps.getRadius(), minArcLength, arcSegmentLength);
                    if (points != null) {
                        Point3d startPoint = start;
                        for (Point3d nextPoint : points) {
                            ls = new LineSegment(startPoint, nextPoint, num);
                            ls.setIsArc(ps.isArc());
                            ls.setIsFastTraverse(ps.isFastTraverse());
                            ls.setIsZMovement(ps.isZMovement());
                            this.testExtremes(nextPoint);
                            this.lines.add(ls);
                            startPoint = nextPoint;
                        }
                    }
                } else {
                    ls = new LineSegment(start, end, num++);
                    ls.setIsArc(ps.isArc());
                    ls.setIsFastTraverse(ps.isFastTraverse());
                    ls.setIsZMovement(ps.isZMovement());
                    this.testExtremes(end);
                    this.lines.add(ls);
                }
            }
            start = end;
        }
        return this.lines;
    }
}

