/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.visualizer;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.uielements.FPSCounter;
import com.willwinder.universalgcodesender.uielements.Overlay;
import com.willwinder.universalgcodesender.visualizer.GcodeViewParse;
import com.willwinder.universalgcodesender.visualizer.LineSegment;
import com.willwinder.universalgcodesender.visualizer.VisualizerUtils;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class VisualizerCanvas
extends GLCanvas
implements GLEventListener,
KeyListener,
MouseMotionListener,
MouseWheelListener {
    private static final Logger logger = Logger.getLogger(VisualizerCanvas.class.getName());
    static boolean ortho = true;
    static double orthoRotation = -45.0;
    static boolean forceOldStyle = false;
    static boolean debugCoordinates = false;
    private static final DecimalFormat format = new DecimalFormat("####.00");
    private Point3d machineCoord;
    private Point3d workCoord;
    private String gcodeFile = null;
    private boolean isDrawable = false;
    private List<LineSegment> gcodeLineList;
    private int currentCommandNumber = 0;
    private int lastCommandNumber = 0;
    private GLU glu;
    private Point3d center;
    private Point3d eye;
    private Point3d objectMin;
    private Point3d objectMax;
    private double maxSide;
    private double aspectRatio;
    private int xSize;
    private int ySize;
    private double minArcLength;
    private double arcLength;
    private double scaleFactor;
    private double scaleFactorBase;
    private double zoomMultiplier = 1.0;
    private boolean invertZoom = false;
    private final double minZoomMultiplier = 1.0;
    private final double maxZoomMultiplier = 30.0;
    private final double zoomIncrement = 0.2;
    private int panMouseButton = 8;
    private double panMultiplierX = 1.0;
    private double panMultiplierY = 1.0;
    private Vector3d translationVectorH;
    private Vector3d translationVectorV;
    Point last;
    Point current;
    private Point3d rotation;
    private int numberOfVertices = -1;
    private float[] lineVertexData = null;
    private byte[] lineColorData = null;
    private FloatBuffer lineVertexBuffer = null;
    private ByteBuffer lineColorBuffer = null;
    private boolean colorArrayDirty = false;
    private boolean vertexArrayDirty = false;
    private FPSCounter fpsCounter;
    private Overlay overlay;
    private String dimensionsLabel;

    public VisualizerCanvas() {
        this.addGLEventListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.eye = new Point3d(0.0, 0.0, 1.5);
        this.center = new Point3d(0.0, 0.0, 0.0);
        this.workCoord = new Point3d(0.0, 0.0, 0.0);
        this.machineCoord = new Point3d(0.0, 0.0, 0.0);
        this.rotation = new Point3d(0.0, -30.0, 0.0);
        if (ortho) {
            this.setVerticalTranslationVector();
            this.setHorizontalTranslationVector();
        }
    }

    public void setCurrentCommandNumber(int num) {
        this.currentCommandNumber = num;
        this.createVertexBuffers();
        this.colorArrayDirty = true;
    }

    public int getLastCommandNumber() {
        return this.lastCommandNumber;
    }

    public void setGcodeFile(String file) {
        this.gcodeFile = file;
        this.isDrawable = false;
        this.currentCommandNumber = 0;
        this.lastCommandNumber = 0;
        this.generateObject();
    }

    public void setWorkCoordinate(Point3d p) {
        this.workCoord.set(p);
    }

    public void setMachineCoordinate(Point3d p) {
        this.machineCoord.set(p);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        logger.log(Level.INFO, "Initializing OpenGL context.");
        this.generateObject();
        this.fpsCounter = new FPSCounter((GLDrawable)drawable, new Font("SansSerif", 1, 12));
        this.overlay = new Overlay((GLDrawable)drawable, new Font("SansSerif", 1, 12));
        this.overlay.setColor(127.0f, 127.0f, 127.0f, 100.0f);
        this.overlay.setTextLocation(3);
        GL2 gl = drawable.getGL().getGL2();
        this.glu = new GLU();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        gl.glShadeModel(7425);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        logger.log(Level.INFO, "Reshaping OpenGL context.");
        if (!this.isDrawable) {
            return;
        }
        this.xSize = width;
        this.ySize = height;
        GL2 gl = drawable.getGL().getGL2();
        if (height == 0) {
            height = 1;
        }
        this.aspectRatio = (float)width / (float)height;
        this.scaleFactorBase = VisualizerUtils.findScaleFactor(this.xSize, this.ySize, this.objectMin, this.objectMax);
        this.scaleFactor = this.scaleFactorBase * this.zoomMultiplier;
        this.panMultiplierX = VisualizerUtils.getRelativeMovementMultiplier(this.objectMin.x, this.objectMax.x, this.xSize);
        this.panMultiplierY = VisualizerUtils.getRelativeMovementMultiplier(this.objectMin.y, this.objectMax.y, this.ySize);
        gl.glViewport(0, 0, width, height);
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        if (!this.isDrawable) {
            return;
        }
        this.setupPerpective(this.xSize, this.ySize, drawable, ortho);
        GL2 gl = drawable.getGL().getGL2();
        gl.glScaled(this.scaleFactor, this.scaleFactor, this.scaleFactor);
        if (ortho) {
            gl.glRotated(this.rotation.x, 0.0, 1.0, 0.0);
            gl.glRotated(this.rotation.y, 1.0, 0.0, 0.0);
            gl.glTranslated(-this.eye.x - this.center.x, -this.eye.y - this.center.y, -this.eye.z - this.center.z);
        } else {
            gl.glTranslated(-this.center.x, -this.center.y, 0.0);
        }
        gl.glClear(16640);
        if (this.isDrawable) {
            this.renderModel(drawable);
            this.renderTool(drawable);
        }
        gl.glDisable(2929);
        gl.glPopMatrix();
        if (this.isDrawable) {
            this.fpsCounter.draw();
            this.overlay.draw(this.dimensionsLabel);
        }
        this.update();
    }

    private void renderAxes(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glBegin(1);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(50.0f, 0.0f, 0.0f);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 50.0f, 0.0f);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 50.0f);
        gl.glEnd();
    }

    private void renderTool(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glLineWidth(8.0f);
        byte[] color = VisualizerUtils.getVertexColor(VisualizerUtils.Color.YELLOW);
        boolean verts = false;
        boolean colors = false;
        gl.glBegin(1);
        gl.glColor3ub(color[0], color[1], color[2]);
        gl.glVertex3d(this.workCoord.x, this.workCoord.y, this.workCoord.z);
        gl.glColor3ub(color[0], color[1], color[2]);
        gl.glVertex3d(this.workCoord.x, this.workCoord.y, this.workCoord.z + 1.0 / this.scaleFactor);
        gl.glEnd();
    }

    private void renderModel(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        if (!forceOldStyle && gl.isFunctionAvailable("glGenBuffers") && gl.isFunctionAvailable("glBindBuffer") && gl.isFunctionAvailable("glBufferData") && gl.isFunctionAvailable("glDeleteBuffers")) {
            if (this.colorArrayDirty) {
                this.updateGLColorArray(drawable);
                this.colorArrayDirty = false;
            }
            if (this.vertexArrayDirty) {
                this.updateGLGeometryArray(drawable);
                this.vertexArrayDirty = false;
            }
            gl.glLineWidth(1.0f);
            gl.glEnableClientState(32884);
            gl.glEnableClientState(32886);
            gl.glDrawArrays(1, 0, this.numberOfVertices);
            gl.glDisableClientState(32886);
            gl.glDisableClientState(32884);
        } else {
            gl.glBegin(1);
            gl.glLineWidth(1.0f);
            int verts = 0;
            int colors = 0;
            for (LineSegment ls : this.gcodeLineList) {
                gl.glColor3ub(this.lineColorData[colors++], this.lineColorData[colors++], this.lineColorData[colors++]);
                gl.glVertex3d(this.lineVertexData[verts++], this.lineVertexData[verts++], this.lineVertexData[verts++]);
                gl.glColor3ub(this.lineColorData[colors++], this.lineColorData[colors++], this.lineColorData[colors++]);
                gl.glVertex3d(this.lineVertexData[verts++], this.lineVertexData[verts++], this.lineVertexData[verts++]);
            }
            gl.glEnd();
        }
    }

    private void setupPerpective(int x, int y, GLAutoDrawable drawable, boolean ortho) {
        GL2 gl = drawable.getGL().getGL2();
        if (ortho) {
            gl.glDisable(2929);
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(-0.51 * this.aspectRatio, 0.51 * this.aspectRatio, -0.51, 0.51, -10.0, 10.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
        } else {
            gl.glEnable(2929);
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            this.glu.gluPerspective(45.0, this.aspectRatio, 0.1, 100.0);
            this.glu.gluLookAt(this.eye.x, this.eye.y, this.eye.z, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
        }
    }

    private void generateObject() {
        if (this.gcodeFile == null) {
            return;
        }
        try {
            GcodeViewParse gcvp = new GcodeViewParse();
            ArrayList<String> linesInFile = VisualizerUtils.readFiletoArrayList(this.gcodeFile);
            this.gcodeLineList = gcvp.toObjRedux(linesInFile, 0.3);
            this.objectMin = gcvp.getMinimumExtremes();
            this.objectMax = gcvp.getMaximumExtremes();
            if (this.gcodeLineList.size() == 0) {
                return;
            }
            this.lastCommandNumber = this.gcodeLineList.get(this.gcodeLineList.size() - 1).getLineNumber();
            System.out.println("Object bounds: X (" + this.objectMin.x + ", " + this.objectMax.x + ")");
            System.out.println("               Y (" + this.objectMin.y + ", " + this.objectMax.y + ")");
            System.out.println("               Z (" + this.objectMin.z + ", " + this.objectMax.z + ")");
            this.center = VisualizerUtils.findCenter(this.objectMin, this.objectMax);
            System.out.println("Center = " + this.center.toString());
            System.out.println("Num Line Segments :" + this.gcodeLineList.size());
            this.maxSide = VisualizerUtils.findMaxSide(this.objectMin, this.objectMax);
            this.scaleFactorBase = 1.0 / this.maxSide;
            this.scaleFactorBase = VisualizerUtils.findScaleFactor(this.xSize, this.ySize, this.objectMin, this.objectMax);
            this.scaleFactor = this.scaleFactorBase * this.zoomMultiplier;
            this.isDrawable = true;
            double objectWidth = this.objectMax.x - this.objectMin.x;
            double objectHeight = this.objectMax.y - this.objectMin.y;
            this.dimensionsLabel = Localization.getString("VisualizerCanvas.dimensions") + ": " + Localization.getString("VisualizerCanvas.width") + "=" + format.format(objectWidth) + " " + Localization.getString("VisualizerCanvas.height") + "=" + format.format(objectHeight);
            this.createVertexBuffers();
            this.colorArrayDirty = true;
            this.vertexArrayDirty = true;
        }
        catch (IOException e2) {
            System.out.println("Error opening file: " + e2.getLocalizedMessage());
        }
    }

    private void createVertexBuffers() {
        if (this.isDrawable) {
            this.numberOfVertices = this.gcodeLineList.size() * 2;
            this.lineVertexData = new float[this.numberOfVertices * 3];
            this.lineColorData = new byte[this.numberOfVertices * 3];
            int vertIndex = 0;
            int colorIndex = 0;
            for (LineSegment ls : this.gcodeLineList) {
                VisualizerUtils.Color color = ls.isArc() ? VisualizerUtils.Color.RED : (ls.isFastTraverse() ? VisualizerUtils.Color.BLUE : (ls.isZMovement() ? VisualizerUtils.Color.GREEN : VisualizerUtils.Color.WHITE));
                if (ls.getLineNumber() < this.currentCommandNumber) {
                    color = VisualizerUtils.Color.GRAY;
                }
                Point3d p1 = ls.getStart();
                Point3d p2 = ls.getEnd();
                byte[] c2 = VisualizerUtils.getVertexColor(color);
                this.lineColorData[colorIndex++] = c2[0];
                this.lineColorData[colorIndex++] = c2[1];
                this.lineColorData[colorIndex++] = c2[2];
                this.lineColorData[colorIndex++] = c2[0];
                this.lineColorData[colorIndex++] = c2[1];
                this.lineColorData[colorIndex++] = c2[2];
                this.lineVertexData[vertIndex++] = (float)p1.x;
                this.lineVertexData[vertIndex++] = (float)p1.y;
                this.lineVertexData[vertIndex++] = (float)p1.z;
                this.lineVertexData[vertIndex++] = (float)p2.x;
                this.lineVertexData[vertIndex++] = (float)p2.y;
                this.lineVertexData[vertIndex++] = (float)p2.z;
            }
        }
    }

    private void updateGLGeometryArray(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        if (this.lineVertexBuffer != null) {
            this.lineVertexBuffer.clear();
            if (this.lineVertexBuffer.remaining() < this.lineVertexData.length) {
                this.lineVertexBuffer = null;
            }
        }
        if (this.lineVertexBuffer == null) {
            this.lineVertexBuffer = Buffers.newDirectFloatBuffer(this.lineVertexData.length);
        }
        this.lineVertexBuffer.put(this.lineVertexData);
        this.lineVertexBuffer.flip();
        gl.glVertexPointer(3, 5126, 0, this.lineVertexBuffer);
    }

    private void updateGLColorArray(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        if (this.lineColorBuffer != null) {
            this.lineColorBuffer.clear();
            if (this.lineColorBuffer.remaining() < this.lineColorData.length) {
                this.lineColorBuffer = null;
            }
        }
        if (this.lineColorBuffer == null) {
            this.lineColorBuffer = Buffers.newDirectByteBuffer(this.lineColorData.length);
        }
        this.lineColorBuffer.put(this.lineColorData);
        this.lineColorBuffer.flip();
        gl.glColorPointer(3, 5121, 0, this.lineColorBuffer);
    }

    private void update() {
        if (debugCoordinates) {
            System.out.println("Machine coordinates: " + this.machineCoord.toString());
            System.out.println("Work coordinates: " + this.workCoord.toString());
            System.out.println("-----------------");
        }
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
        logger.log(Level.INFO, "Disposing OpenGL context.");
        this.lineColorBuffer = null;
        this.lineVertexBuffer = null;
        this.gcodeLineList = null;
        this.isDrawable = false;
        this.numberOfVertices = 0;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        double DELTA_SIZE = 0.1;
        switch (ke.getKeyCode()) {
            case 38: {
                this.eye.y += DELTA_SIZE;
                break;
            }
            case 40: {
                this.eye.y -= DELTA_SIZE;
                break;
            }
            case 37: {
                this.eye.x -= DELTA_SIZE;
                break;
            }
            case 39: {
                this.eye.x += DELTA_SIZE;
                break;
            }
            case 45: {
                if (!ke.isControlDown()) break;
                this.zoomOut(1);
                break;
            }
            case 48: {
                if (!ke.isControlDown()) break;
                this.zoomMultiplier = 1.0;
                this.scaleFactor = this.scaleFactorBase;
                break;
            }
            case 27: {
                this.zoomMultiplier = 1.0;
                this.scaleFactor = this.scaleFactorBase;
                this.eye.x = 0.0;
                this.eye.y = 0.0;
                this.eye.z = 1.5;
                this.rotation.x = 0.0;
                this.rotation.y = -30.0;
                this.rotation.z = 0.0;
            }
        }
        switch (ke.getKeyChar()) {
            case 'p': {
                this.eye.z += DELTA_SIZE;
                break;
            }
            case ';': {
                this.eye.z -= DELTA_SIZE;
                break;
            }
            case 'w': {
                this.center.y += DELTA_SIZE;
                break;
            }
            case 's': {
                this.center.y -= DELTA_SIZE;
                break;
            }
            case 'a': {
                this.center.x -= DELTA_SIZE;
                break;
            }
            case 'd': {
                this.center.x += DELTA_SIZE;
                break;
            }
            case 'r': {
                this.center.z += DELTA_SIZE;
                break;
            }
            case 'f': {
                this.center.z -= DELTA_SIZE;
                break;
            }
            case '+': {
                if (!ke.isControlDown()) break;
                this.zoomIn(1);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.current = me.getPoint();
        int dx = this.current.x - this.last.x;
        int dy = this.current.y - this.last.y;
        if (me.isShiftDown() || me.getModifiers() == this.panMouseButton) {
            if (ortho) {
                this.eye.x -= (double)dx * this.translationVectorH.x * this.panMultiplierX + (double)dy * this.translationVectorV.x * this.panMultiplierY;
                this.eye.y += (double)dy * this.translationVectorV.y * this.panMultiplierY - (double)dx * this.translationVectorH.y * this.panMultiplierX;
                this.eye.z -= (double)dx * this.translationVectorH.z * this.panMultiplierX + (double)dy * this.translationVectorV.z * this.panMultiplierY;
            } else {
                this.eye.x += (double)dx;
                this.eye.y += (double)dy;
            }
        } else {
            this.rotation.x += (double)dx / 2.0;
            this.rotation.y -= (double)dy / 2.0;
            if (ortho) {
                this.setHorizontalTranslationVector();
                this.setVerticalTranslationVector();
            }
        }
        this.last = this.current;
    }

    private void setHorizontalTranslationVector() {
        double x = Math.cos(Math.toRadians(this.rotation.x));
        double xz = Math.sin(Math.toRadians(this.rotation.x));
        double y = xz * Math.sin(Math.toRadians(this.rotation.y));
        double yz = xz * Math.cos(Math.toRadians(this.rotation.y));
        this.translationVectorH = new Vector3d(x, y, yz);
        this.translationVectorH.normalize();
    }

    private void setVerticalTranslationVector() {
        double y = Math.cos(Math.toRadians(this.rotation.y));
        double yz = Math.sin(Math.toRadians(this.rotation.y));
        this.translationVectorV = new Vector3d(0.0, y, yz);
        this.translationVectorV.normalize();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.last = me.getPoint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        int delta = e2.getWheelRotation();
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            if (this.invertZoom) {
                this.zoomOut(delta);
            } else {
                this.zoomIn(delta);
            }
        } else if (delta < 0) {
            if (this.invertZoom) {
                this.zoomIn(delta * -1);
            } else {
                this.zoomOut(delta * -1);
            }
        }
    }

    private void zoomOut(int increments) {
        if (ortho) {
            if (this.zoomMultiplier <= this.minZoomMultiplier) {
                return;
            }
            this.zoomMultiplier -= (double)increments * 0.2;
            if (this.zoomMultiplier < this.minZoomMultiplier) {
                this.zoomMultiplier = this.minZoomMultiplier;
            }
            this.scaleFactor = this.scaleFactorBase * this.zoomMultiplier;
        } else {
            this.eye.z += (double)increments;
        }
    }

    private void zoomIn(int increments) {
        if (ortho) {
            if (this.zoomMultiplier >= this.maxZoomMultiplier) {
                return;
            }
            this.zoomMultiplier += (double)increments * 0.2;
            if (this.zoomMultiplier > this.maxZoomMultiplier) {
                this.zoomMultiplier = this.maxZoomMultiplier;
            }
            this.scaleFactor = this.scaleFactorBase * this.zoomMultiplier;
        } else {
            this.eye.z -= (double)increments;
        }
    }

    public double getMinArcLength() {
        return this.minArcLength;
    }

    public void setMinArcLength(double minArcLength) {
        if (this.minArcLength != minArcLength) {
            this.minArcLength = minArcLength;
            if (this.gcodeFile != null) {
                this.setGcodeFile(this.gcodeFile);
            }
        }
    }

    public double getArcLength() {
        return this.arcLength;
    }

    public void setArcLength(double arcLength) {
        if (this.arcLength != arcLength) {
            this.arcLength = arcLength;
            if (this.gcodeFile != null) {
                this.setGcodeFile(this.gcodeFile);
            }
        }
    }
}

