/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.visualizer;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.vecmath.Point3d;

public class VisualizerUtils {
    public static double findMaxSide(Point3d min, Point3d max) {
        double x = Math.abs(min.x) + Math.abs(max.x);
        double y = Math.abs(min.y) + Math.abs(max.y);
        double z = Math.abs(min.z) + Math.abs(max.z);
        return Math.max(x, Math.max(y, z));
    }

    public static double findAspectRatio(Point3d min, Point3d max) {
        double x = Math.abs(min.x) + Math.abs(max.x);
        double y = Math.abs(min.y) + Math.abs(max.y);
        return x / y;
    }

    public static Point3d findCenter(Point3d min, Point3d max) {
        Point3d center = new Point3d();
        center.x = (min.x + max.x) / 2.0;
        center.y = (min.y + max.y) / 2.0;
        center.z = (min.z + max.z) / 2.0;
        return center;
    }

    public static double findScaleFactor(double x, double y, Point3d min, Point3d max) {
        double yObj;
        double bufferFactor = 0.9;
        if (y == 0.0 || x == 0.0 || min == null || max == null) {
            return 1.0;
        }
        double windowRatio = x / y;
        double xObj = Math.abs(min.x) + Math.abs(max.x);
        double objRatio = xObj / (yObj = Math.abs(min.y) + Math.abs(max.y));
        if (windowRatio < objRatio) {
            return 1.0 / xObj * windowRatio * 0.9;
        }
        return 1.0 / yObj * 0.9;
    }

    public static ArrayList<String> readFiletoArrayList(String gCode) throws IOException {
        String line;
        ArrayList<String> vect = new ArrayList<String>();
        File gCodeFile = new File(gCode);
        FileInputStream fstream = new FileInputStream(gCodeFile);
        DataInputStream dis = new DataInputStream(fstream);
        BufferedReader fileStream = new BufferedReader(new InputStreamReader(dis));
        while ((line = fileStream.readLine()) != null) {
            vect.add(line);
        }
        return vect;
    }

    public static byte[] getVertexColor(Color color) {
        byte[] ret;
        switch (color) {
            case RED: {
                ret = new byte[]{-1, 100, 100};
                break;
            }
            case BLUE: {
                ret = new byte[]{0, -1, -1};
                break;
            }
            case PURPLE: {
                ret = new byte[]{-14, 0, -1};
                break;
            }
            case YELLOW: {
                ret = new byte[]{-19, -1, 0};
                break;
            }
            case OTHER_YELLOW: {
                ret = new byte[]{-22, -44, 7};
                break;
            }
            case GREEN: {
                ret = new byte[]{33, -1, 0};
                break;
            }
            case WHITE: {
                ret = new byte[]{-1, -1, -1};
                break;
            }
            case GRAY: {
                ret = new byte[]{80, 80, 80};
                break;
            }
            default: {
                ret = new byte[]{-1, -1, -1};
            }
        }
        return ret;
    }

    public static double getRelativeMovementMultiplier(double objectMin, double objectMax, int movementRange) {
        if (movementRange == 0) {
            return 0.0;
        }
        double objectAxis = Math.abs(objectMax - objectMin);
        return objectAxis / (double)movementRange;
    }

    public static enum Color {
        RED,
        BLUE,
        PURPLE,
        YELLOW,
        OTHER_YELLOW,
        GREEN,
        WHITE,
        GRAY;

    }
}

