/*
 * Decompiled with CFR 0.152.
 */
package com.willwinder.universalgcodesender.visualizer;

import com.jogamp.opengl.util.FPSAnimator;
import com.willwinder.universalgcodesender.i18n.Localization;
import com.willwinder.universalgcodesender.listeners.ControllerListener;
import com.willwinder.universalgcodesender.types.GcodeCommand;
import com.willwinder.universalgcodesender.types.WindowSettings;
import com.willwinder.universalgcodesender.visualizer.VisualizerCanvas;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.vecmath.Point3d;

public class VisualizerWindow
extends JFrame
implements ControllerListener,
WindowListener {
    private static String TITLE = Localization.getString("visualizer.title");
    private static final int FPS = 20;
    FPSAnimator animator;
    private Point3d machineCoordinate;
    private Point3d workCoordinate;
    private int completedCommandNumber = -1;
    private String gcodeFile = null;
    private VisualizerCanvas canvas = null;

    public VisualizerWindow() {
        this(new WindowSettings(0, 0, 640, 480));
    }

    public VisualizerWindow(WindowSettings ws) {
        this.setPreferredSize(new Dimension(ws.width, ws.height));
        this.setLocation(ws.xLocation, ws.yLocation);
        this.canvas = new VisualizerCanvas();
        this.canvas.setPreferredSize(new Dimension(ws.width, ws.height));
        this.canvas.setLocation(ws.xLocation, ws.yLocation);
        this.animator = new FPSAnimator(this.canvas, 20, true);
        VisualizerWindow frame = this;
        frame.getContentPane().add(this.canvas);
        frame.addWindowListener(this);
        frame.setTitle(TITLE);
        frame.pack();
        frame.setVisible(true);
        this.animator.start();
    }

    public void setGcodeFile(String file) {
        this.gcodeFile = file;
        this.canvas.setGcodeFile(this.gcodeFile);
    }

    public void setCompletedCommandNumber(int num) {
        this.completedCommandNumber = num;
        this.canvas.setCurrentCommandNumber(num);
    }

    public double getMinArcLength() {
        return this.canvas.getMinArcLength();
    }

    public void setMinArcLength(double minArcLength) {
        this.canvas.setMinArcLength(minArcLength);
    }

    public double getArcLength() {
        return this.canvas.getArcLength();
    }

    public void setArcLength(double arcLength) {
        this.canvas.setArcLength(arcLength);
    }

    @Override
    public void statusStringListener(String state, Point3d machineCoord, Point3d workCoord) {
        this.machineCoordinate = machineCoord;
        this.workCoordinate = workCoord;
        this.canvas.setMachineCoordinate(this.machineCoordinate);
        this.canvas.setWorkCoordinate(this.workCoordinate);
    }

    @Override
    public void fileStreamComplete(String filename, boolean success) {
    }

    @Override
    public void commandQueued(GcodeCommand command) {
    }

    @Override
    public void commandSent(GcodeCommand command) {
    }

    @Override
    public void commandComplete(GcodeCommand command) {
    }

    @Override
    public void commandComment(String comment) {
    }

    @Override
    public void messageForConsole(String msg, Boolean verbose) {
    }

    @Override
    public void postProcessData(int numRows) {
    }

    @Override
    public void windowClosing(WindowEvent e2) {
        new Thread(){

            @Override
            public void run() {
                if (VisualizerWindow.this.animator.isStarted()) {
                    VisualizerWindow.this.animator.pause();
                }
            }
        }.start();
    }

    @Override
    public void windowActivated(WindowEvent e2) {
        if (this.animator.isPaused()) {
            this.animator.resume();
        }
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }
}

