/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import jmapps.jmstudio.CaptureControlsDialog;
import jmapps.jmstudio.CaptureDialog;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.util.JMAppsCfg;

public class PanelMediaSource
extends JMPanel
implements ActionListener,
TextListener {
    private JMAppsCfg cfgJMApps = null;
    private TextField textSource;
    private Button buttonBrowseFile;
    private Button buttonBrowseCapture;
    private CaptureDialog dlgCapture = null;
    private CaptureControlsDialog dlgCaptureControls = null;
    private boolean boolSettingCaptureSource = false;
    private String strContentTypeDefault = null;
    private DataSource dataSource = null;

    public PanelMediaSource(JMAppsCfg cfgJMApps) {
        this.cfgJMApps = cfgJMApps;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSourceUrl(String strSourceUrl) {
        if (strSourceUrl != null && strSourceUrl.trim().length() > 0) {
            this.textSource.setText(strSourceUrl);
        }
    }

    public String getSourceUrl() {
        String strSourceUrl = this.textSource.getText();
        return strSourceUrl;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void setCaptureDlg(CaptureDialog cdlg) {
        this.dlgCapture = cdlg;
    }

    public void setJMStudioCfg(JMAppsCfg cfgJMApps) {
        String strSourceUrl = null;
        this.cfgJMApps = cfgJMApps;
        if (cfgJMApps != null) {
            strSourceUrl = cfgJMApps.getLastTransmitRtpSource();
        }
        if (strSourceUrl != null) {
            this.textSource.setText(strSourceUrl);
        }
    }

    public void SaveData() {
        String strSourceUrl = this.textSource.getText();
        if (this.cfgJMApps != null && strSourceUrl != null) {
            this.cfgJMApps.setLastTransmitRtpSource(strSourceUrl);
        }
    }

    public Processor createProcessor() {
        String strContentType;
        Processor processor = null;
        this.strContentTypeDefault = null;
        this.dlgCaptureControls = null;
        if (this.dataSource == null) {
            if (this.dlgCapture != null) {
                this.dataSource = this.dlgCapture.createCaptureDataSource();
            } else {
                String strSourceUrl = this.getSourceUrl();
                try {
                    MediaLocator mediaSource = new MediaLocator(strSourceUrl);
                    this.dataSource = Manager.createDataSource(mediaSource);
                }
                catch (Exception exception) {
                    MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.datasource.createfor") + " '" + strSourceUrl + "'. ", exception);
                }
            }
        }
        if (this.dataSource == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return null;
        }
        if (this.dataSource instanceof CaptureDevice) {
            this.dlgCaptureControls = new CaptureControlsDialog(this.getFrame(), this.dataSource);
        }
        if ((strContentType = this.dataSource.getContentType()) != null) {
            this.strContentTypeDefault = new ContentDescriptor(strContentType).toString();
        }
        try {
            processor = Manager.createProcessor(this.dataSource);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.processor.create"), exception);
            exception.printStackTrace();
            this.setCursor(Cursor.getDefaultCursor());
            return null;
        }
        return processor;
    }

    public String getDefaultContentType() {
        return this.strContentTypeDefault;
    }

    public CaptureControlsDialog getCaptureControlsDialog() {
        return this.dlgCaptureControls;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(12, 12));
        Panel panelDescription = new Panel(new GridLayout(0, 1));
        this.add((Component)panelDescription, "North");
        panelDescription.add(new Label(JMFI18N.getResource("jmstudio.export.source.label1")));
        panelDescription.add(new Label(JMFI18N.getResource("jmstudio.export.source.label2")));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "Center");
        Panel panelEntry = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelEntry, "North");
        this.textSource = new TextField();
        this.textSource.addTextListener(this);
        panelEntry.add((Component)this.textSource, "Center");
        Panel panelButtons1 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelButtons1, "Center");
        Panel panelButtons2 = new Panel(new BorderLayout(6, 6));
        panelButtons1.add((Component)panelButtons2, "North");
        Panel panelButtons = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons2.add((Component)panelButtons, "West");
        this.buttonBrowseFile = new Button(JMFI18N.getResource("jmstudio.export.source.file"));
        this.buttonBrowseFile.addActionListener(this);
        panelButtons.add(this.buttonBrowseFile);
        this.buttonBrowseCapture = new Button(JMFI18N.getResource("jmstudio.export.source.capture"));
        this.buttonBrowseCapture.addActionListener(this);
        panelButtons.add(this.buttonBrowseCapture);
    }

    public void actionPerformed(ActionEvent event2) {
        String strCmd = event2.getActionCommand();
        if (strCmd.equals(this.buttonBrowseFile.getLabel())) {
            this.browseFile();
        } else if (strCmd.equals(this.buttonBrowseCapture.getLabel())) {
            this.browseCapture();
        }
    }

    public void textValueChanged(TextEvent event2) {
        Object objectSource = event2.getSource();
        if (objectSource == this.textSource) {
            if (this.boolSettingCaptureSource) {
                this.boolSettingCaptureSource = false;
            } else {
                this.dlgCapture = null;
            }
            this.dataSource = null;
        }
    }

    private void browseFile() {
        FileDialog dlgFile;
        String strFile = this.textSource.getText();
        try {
            dlgFile = new FileDialog(this.getFrame(), JMFI18N.getResource("jmstudio.export.source.filedialog"), 0);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.fgiledialog"));
            return;
        }
        int nIndex = strFile.indexOf(58);
        if (nIndex > 0 && strFile.substring(0, nIndex).equalsIgnoreCase("file")) {
            strFile = strFile.substring(nIndex + 1);
            dlgFile.setFile(strFile);
        }
        dlgFile.show();
        strFile = dlgFile.getFile();
        String strDir = dlgFile.getDirectory();
        if (strFile != null && strFile.length() > 0) {
            strFile = "file:" + strDir + strFile;
            this.textSource.setText(strFile);
            this.dlgCapture = null;
        }
    }

    private void browseCapture() {
        if (this.dlgCapture == null) {
            this.dlgCapture = new CaptureDialog(this.getFrame(), this.cfgJMApps);
        }
        this.dlgCapture.show();
        String strAction = this.dlgCapture.getAction();
        if (strAction.equals(JMDialog.ACTION_OK)) {
            this.boolSettingCaptureSource = true;
            this.textSource.setText(this.dlgCapture.toString());
        } else {
            this.dlgCapture = null;
        }
    }
}

