/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.ui.PlayerWindow;
import com.sun.media.util.JMFI18N;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.Processor;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionManager;
import jmapps.rtp.TransmissionStatsDialog;

class TransmitPlayerWindow
extends PlayerWindow
implements ActionListener,
WindowListener {
    private Vector vectorMngrSessions = new Vector();
    private Vector vectorStreams = new Vector();
    private Vector vectorStreamLabels = new Vector();
    private MenuBar menuBar = null;
    private Menu menuStats = null;
    private MenuItem menuItemStats = null;
    private TransmissionStatsDialog dlgTransmissionStats = null;
    private static final String MENU_STATS = JMFI18N.getResource("jmstudio.menu.stats");
    private static final String MENU_STATS_TRANSMISSION = JMFI18N.getResource("jmstudio.menu.player.transmission");

    public TransmitPlayerWindow(Processor processor) {
        super(processor, JMFI18N.getResource("jmstudio.playerwindow.transcoding"), true);
        this.addWindowListener(this);
    }

    public void addNotify() {
        this.createMenuStats();
        super.addNotify();
    }

    public void addSessionManager(SessionManager mngrSession, SendStream streamSend, String strStreamLabel) {
        this.vectorMngrSessions.addElement(mngrSession);
        this.vectorStreams.addElement(streamSend);
        this.vectorStreamLabels.addElement(strStreamLabel);
        this.createMenuStats();
    }

    public void actionPerformed(ActionEvent event2) {
        String strCmd = event2.getActionCommand();
        if (strCmd.equals(MENU_STATS_TRANSMISSION)) {
            if (this.dlgTransmissionStats == null) {
                this.dlgTransmissionStats = new TransmissionStatsDialog((Frame)this, this.vectorMngrSessions, this.vectorStreamLabels);
            }
            this.dlgTransmissionStats.setVisible(true);
            this.dlgTransmissionStats.toFront();
        }
    }

    public void windowOpened(WindowEvent event2) {
    }

    public void windowClosing(WindowEvent event2) {
    }

    public void windowClosed(WindowEvent event2) {
        if (this.dlgTransmissionStats != null) {
            this.dlgTransmissionStats.dispose();
            this.dlgTransmissionStats = null;
        }
        int nCount = this.vectorStreams.size();
        int i2 = 0;
        while (i2 < nCount) {
            SendStream streamSend = (SendStream)this.vectorStreams.elementAt(i2);
            streamSend.close();
            ++i2;
        }
        nCount = this.vectorMngrSessions.size();
        i2 = 0;
        while (i2 < nCount) {
            SessionManager mngrSession = (SessionManager)this.vectorMngrSessions.elementAt(i2);
            mngrSession.closeSession("Transmission terminated");
            ++i2;
        }
        this.vectorMngrSessions.removeAllElements();
        this.vectorStreams.removeAllElements();
        this.vectorStreamLabels.removeAllElements();
    }

    public void windowIconified(WindowEvent event2) {
    }

    public void windowDeiconified(WindowEvent event2) {
    }

    public void windowActivated(WindowEvent event2) {
    }

    public void windowDeactivated(WindowEvent event2) {
    }

    private synchronized void createMenuStats() {
        if (this.menuItemStats != null) {
            return;
        }
        this.createMenuBar();
        if (this.menuStats == null) {
            this.menuStats = new Menu(MENU_STATS);
            this.menuBar.add(this.menuStats);
        }
        this.menuItemStats = new MenuItem(MENU_STATS_TRANSMISSION);
        this.menuStats.add(this.menuItemStats);
        this.menuItemStats.setActionCommand(MENU_STATS_TRANSMISSION);
        this.menuItemStats.addActionListener(this);
    }

    private synchronized void createMenuBar() {
        this.menuBar = this.getMenuBar();
        if (this.menuBar == null) {
            this.menuBar = new MenuBar();
            this.setMenuBar(this.menuBar);
        }
    }
}

