/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jmapps.registry.VectorEditor;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class VectorPanel
extends JMPanel
implements ItemListener,
ActionListener {
    VectorEditor editor;
    int code;
    TextField textAdd;
    Vector values;
    List listBox;
    Button buttonAdd;
    Button buttonUp;
    Button buttonDown;
    Button buttonRemove;
    Button buttonRestore;
    Button buttonCommit;

    public VectorPanel(String title, VectorEditor ve, int code) {
        this.editor = ve;
        this.code = code;
        this.setLayout(new BorderLayout(6, 6));
        Panel panelValues = new Panel(new BorderLayout(6, 6));
        this.add((Component)panelValues, "Center");
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "East");
        Panel panelButtons = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panelButtons, "North");
        Panel panelAdd = new Panel(new BorderLayout(6, 6));
        panelValues.add((Component)panelAdd, "North");
        Label label = new Label(title);
        panelAdd.add((Component)label, "North");
        this.textAdd = new TextField(20);
        this.textAdd.addActionListener(this);
        panelAdd.add((Component)this.textAdd, "Center");
        this.listBox = new List();
        this.listBox.addItemListener(this);
        panelValues.add((Component)this.listBox, "Center");
        this.values = this.editor.getList(code);
        int nCount = this.values.size();
        int i2 = 0;
        while (i2 < nCount) {
            Object objValue = this.values.elementAt(i2);
            this.listBox.add(objValue.toString());
            ++i2;
        }
        this.buttonAdd = new Button(JMFI18N.getResource("jmfregistry.vector.add"));
        this.buttonAdd.addActionListener(this);
        panelButtons.add(this.buttonAdd);
        this.buttonUp = new Button(JMFI18N.getResource("jmfregistry.vector.moveup"));
        this.buttonUp.addActionListener(this);
        panelButtons.add(this.buttonUp);
        this.buttonDown = new Button(JMFI18N.getResource("jmfregistry.vector.movedown"));
        this.buttonDown.addActionListener(this);
        panelButtons.add(this.buttonDown);
        this.buttonRemove = new Button(JMFI18N.getResource("jmfregistry.vector.remove"));
        this.buttonRemove.addActionListener(this);
        panelButtons.add(this.buttonRemove);
        this.buttonRestore = new Button(JMFI18N.getResource("jmfregistry.vector.restore"));
        this.buttonRestore.addActionListener(this);
        panelButtons.add(this.buttonRestore);
        this.buttonCommit = new Button(JMFI18N.getResource("jmfregistry.vector.commit"));
        this.buttonCommit.addActionListener(this);
        panelButtons.add(this.buttonCommit);
        this.updateButtons();
    }

    private void refresh() {
        this.listBox.removeAll();
        int nCount = this.values.size();
        int i2 = 0;
        while (i2 < nCount) {
            Object objValue = this.values.elementAt(i2);
            this.listBox.add(objValue.toString());
            ++i2;
        }
        this.repaint();
    }

    private void addNew() {
        String value = this.textAdd.getText();
        if (value != null && value.length() > 0 && this.editor.addToList(this.code, value)) {
            this.values.addElement(value);
            this.refresh();
        } else {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.additem"));
        }
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.textAdd || source == this.buttonAdd) {
            this.addNew();
        } else if (source == this.buttonUp) {
            this.moveUp();
        } else if (source == this.buttonDown) {
            this.moveDown();
        } else if (source == this.buttonRemove) {
            this.remove();
        } else if (source == this.buttonRestore) {
            this.restore();
        } else if (source == this.buttonCommit) {
            this.commit();
        }
        this.updateButtons();
    }

    public void itemStateChanged(ItemEvent event2) {
        int index = this.listBox.getSelectedIndex();
        this.editor.selectedIndex(this.code, index);
        this.updateButtons();
    }

    public void moveUp() {
        int index = this.listBox.getSelectedIndex();
        if (index == 0) {
            return;
        }
        Object element = this.values.elementAt(index);
        this.values.removeElementAt(index);
        this.values.insertElementAt(element, index - 1);
        this.refresh();
        this.editor.setList(this.code, this.values);
        this.listBox.select(index - 1);
        this.updateButtons();
    }

    public void moveDown() {
        int index = this.listBox.getSelectedIndex();
        if (index == this.listBox.getItemCount() - 1) {
            return;
        }
        Object element = this.values.elementAt(index);
        this.values.removeElementAt(index);
        this.values.insertElementAt(element, index + 1);
        this.refresh();
        this.editor.setList(this.code, this.values);
        this.listBox.select(index + 1);
        this.updateButtons();
    }

    public void remove() {
        int index = this.listBox.getSelectedIndex();
        if (index < 0) {
            this.updateButtons();
            return;
        }
        this.values.removeElementAt(index);
        this.refresh();
        this.editor.setList(this.code, this.values);
        int nCount = this.values.size();
        if (index >= nCount) {
            --index;
        }
        if (nCount > 0) {
            this.listBox.select(index);
        } else {
            index = -1;
        }
        this.editor.selectedIndex(this.code, index);
        this.updateButtons();
    }

    public void restore() {
        System.err.println("restoring");
        this.values = this.editor.getList(this.code);
        System.err.println("value = " + this.values);
        this.refresh();
        this.updateButtons();
    }

    public void commit() {
        this.editor.commit(this.code);
        this.updateButtons();
    }

    private void updateButtons() {
        int nCount = this.values.size();
        int index = this.listBox.getSelectedIndex();
        if (index < 1) {
            this.buttonUp.setEnabled(false);
        } else {
            this.buttonUp.setEnabled(true);
        }
        if (index >= nCount - 1 || index < 0) {
            this.buttonDown.setEnabled(false);
        } else {
            this.buttonDown.setEnabled(true);
        }
        if (index < 0) {
            this.buttonRemove.setEnabled(false);
        } else {
            this.buttonRemove.setEnabled(true);
        }
    }
}

