/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class BaseTable
implements Table {
    private final DirectoryEntry _de;
    private final int _version;
    private final int _horizAxisOffset;
    private final int _vertAxisOffset;
    private Axis _horizAxis;
    private Axis _vertAxis;
    private byte[] _buf;

    protected BaseTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._buf = new byte[directoryEntry.getLength()];
        dataInput.readFully(this._buf);
        DataInput dataInput2 = this.getDataInputForOffset(0);
        this._version = dataInput2.readInt();
        this._horizAxisOffset = dataInput2.readUnsignedShort();
        this._vertAxisOffset = dataInput2.readUnsignedShort();
        if (this._horizAxisOffset != 0) {
            this._horizAxis = new Axis(this._horizAxisOffset);
        }
        if (this._vertAxisOffset != 0) {
            this._vertAxis = new Axis(this._vertAxisOffset);
        }
        this._buf = null;
    }

    private DataInput getDataInputForOffset(int n2) {
        return new DataInputStream(new ByteArrayInputStream(this._buf, n2, this._de.getLength() - n2));
    }

    protected static String tagAsString(int n2) {
        char[] cArray = new char[]{(char)(n2 >> 24 & 0xFF), (char)(n2 >> 16 & 0xFF), (char)(n2 >> 8 & 0xFF), (char)(n2 & 0xFF)};
        return String.valueOf(cArray);
    }

    @Override
    public int getType() {
        return 1111577413;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("; 'BASE' Table - Baseline\n;-------------------------------------\n\n").append("BASEHeader BASEHeaderT").append(Integer.toHexString(0)).append("\n").append(Integer.toHexString(this._version)).append("\nAxisT").append(Integer.toHexString(this._horizAxisOffset)).append("\nAxisT").append(Integer.toHexString(this._vertAxisOffset));
        if (this._horizAxis != null) {
            stringBuilder.append("\n").append(this._horizAxis.toString());
        }
        if (this._vertAxis != null) {
            stringBuilder.append("\n").append(this._vertAxis.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    class Axis {
        private final int _thisOffset;
        private final int _baseTagListOffset;
        private final int _baseScriptListOffset;
        private BaseTagList _baseTagList;
        private BaseScriptList _baseScriptList;

        protected Axis(int n2) throws IOException {
            this._thisOffset = n2;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n2);
            this._baseTagListOffset = dataInput.readUnsignedShort();
            this._baseScriptListOffset = dataInput.readUnsignedShort();
            if (this._baseTagListOffset != 0) {
                this._baseTagList = new BaseTagList(n2 + this._baseTagListOffset);
            }
            if (this._baseScriptListOffset != 0) {
                this._baseScriptList = new BaseScriptList(n2 + this._baseScriptListOffset);
            }
        }

        public String toString() {
            return "\nAxis AxisT" + Integer.toHexString(this._thisOffset) + "\nBaseTagListT" + Integer.toHexString(this._thisOffset + this._baseTagListOffset) + "\nBaseScriptListT" + Integer.toHexString(this._thisOffset + this._baseScriptListOffset) + "\n" + this._baseTagList + "\n" + this._baseScriptList;
        }
    }

    class BaseTagList {
        private final int _thisOffset;
        private final int _baseTagCount;
        private final int[] _baselineTag;

        protected BaseTagList(int n2) throws IOException {
            this._thisOffset = n2;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n2);
            this._baseTagCount = dataInput.readUnsignedShort();
            this._baselineTag = new int[this._baseTagCount];
            for (int i2 = 0; i2 < this._baseTagCount; ++i2) {
                this._baselineTag[i2] = dataInput.readInt();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseTagList BaseTagListT").append(Integer.toHexString(this._thisOffset)).append("\n").append(Integer.toHexString(this._baseTagCount));
            for (int i2 = 0; i2 < this._baseTagCount; ++i2) {
                stringBuilder.append("\n'").append(BaseTable.tagAsString(this._baselineTag[i2])).append("'");
            }
            return stringBuilder.toString();
        }
    }

    class BaseScriptList {
        private final int _thisOffset;
        private final int _baseScriptCount;
        private final BaseScriptRecord[] _baseScriptRecord;
        private final BaseScript[] _baseScripts;

        protected BaseScriptList(int n2) throws IOException {
            int n3;
            this._thisOffset = n2;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n2);
            this._baseScriptCount = dataInput.readUnsignedShort();
            this._baseScriptRecord = new BaseScriptRecord[this._baseScriptCount];
            for (n3 = 0; n3 < this._baseScriptCount; ++n3) {
                this._baseScriptRecord[n3] = new BaseScriptRecord(dataInput);
            }
            this._baseScripts = new BaseScript[this._baseScriptCount];
            for (n3 = 0; n3 < this._baseScriptCount; ++n3) {
                this._baseScripts[n3] = new BaseScript(n2 + this._baseScriptRecord[n3].getBaseScriptOffset());
            }
        }

        public String toString() {
            int n2;
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseScriptList BaseScriptListT").append(Integer.toHexString(this._thisOffset)).append("\n").append(Integer.toHexString(this._baseScriptCount));
            for (n2 = 0; n2 < this._baseScriptCount; ++n2) {
                stringBuilder.append("\n                          ; BaseScriptRecord[").append(n2);
                stringBuilder.append("]\n'").append(BaseTable.tagAsString(this._baseScriptRecord[n2].getBaseScriptTag())).append("'");
                stringBuilder.append("\nBaseScriptT").append(Integer.toHexString(this._thisOffset + this._baseScriptRecord[n2].getBaseScriptOffset()));
            }
            for (n2 = 0; n2 < this._baseScriptCount; ++n2) {
                stringBuilder.append("\n").append(this._baseScripts[n2].toString());
            }
            return stringBuilder.toString();
        }
    }

    static class BaseScriptRecord {
        private final int _baseScriptTag;
        private final int _baseScriptOffset;

        protected BaseScriptRecord(DataInput dataInput) throws IOException {
            this._baseScriptTag = dataInput.readInt();
            this._baseScriptOffset = dataInput.readUnsignedShort();
        }

        int getBaseScriptTag() {
            return this._baseScriptTag;
        }

        int getBaseScriptOffset() {
            return this._baseScriptOffset;
        }
    }

    class BaseScript {
        private final int _thisOffset;
        private final int _baseValuesOffset;
        private final int _defaultMinMaxOffset;
        private final int _baseLangSysCount;
        private final BaseLangSysRecord[] _baseLangSysRecord;
        private BaseValues _baseValues;
        private MinMax[] _minMax;

        protected BaseScript(int n2) throws IOException {
            int n3;
            this._thisOffset = n2;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n2);
            this._baseValuesOffset = dataInput.readUnsignedShort();
            this._defaultMinMaxOffset = dataInput.readUnsignedShort();
            this._baseLangSysCount = dataInput.readUnsignedShort();
            this._baseLangSysRecord = new BaseLangSysRecord[this._baseLangSysCount];
            for (n3 = 0; n3 < this._baseLangSysCount; ++n3) {
                this._baseLangSysRecord[n3] = new BaseLangSysRecord(dataInput);
            }
            if (this._baseValuesOffset > 0) {
                this._baseValues = new BaseValues(n2 + this._baseValuesOffset);
            }
            for (n3 = 0; n3 < this._baseLangSysCount; ++n3) {
                this._minMax[n3] = new MinMax(n2 + this._baseLangSysRecord[n3].getMinMaxOffset());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseScript BaseScriptT").append(Integer.toHexString(this._thisOffset)).append("\nBaseValuesT").append(Integer.toHexString(this._thisOffset + this._baseValuesOffset)).append("\nMinMaxT").append(Integer.toHexString(this._thisOffset + this._defaultMinMaxOffset)).append("\n").append(Integer.toHexString(this._baseLangSysCount));
            if (this._baseValues != null) {
                stringBuilder.append("\n").append(this._baseValues.toString());
            }
            return stringBuilder.toString();
        }
    }

    static class BaseLangSysRecord {
        private final int _minMaxOffset;

        protected BaseLangSysRecord(DataInput dataInput) throws IOException {
            dataInput.readInt();
            this._minMaxOffset = dataInput.readUnsignedShort();
        }

        int getMinMaxOffset() {
            return this._minMaxOffset;
        }
    }

    class BaseValues {
        private final int _baseCoordCount;
        private final int[] _baseCoordOffset;
        private final BaseCoord[] _baseCoords;

        protected BaseValues(int n2) throws IOException {
            int n3;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n2);
            dataInput.readUnsignedShort();
            this._baseCoordCount = dataInput.readUnsignedShort();
            this._baseCoordOffset = new int[this._baseCoordCount];
            for (n3 = 0; n3 < this._baseCoordCount; ++n3) {
                this._baseCoordOffset[n3] = dataInput.readUnsignedShort();
            }
            this._baseCoords = new BaseCoord[this._baseCoordCount];
            block6: for (n3 = 0; n3 < this._baseCoordCount; ++n3) {
                int n4 = dataInput.readUnsignedShort();
                switch (n4) {
                    case 1: {
                        this._baseCoords[n3] = new BaseCoordFormat1(dataInput);
                        continue block6;
                    }
                    case 2: {
                        this._baseCoords[n3] = new BaseCoordFormat2(dataInput);
                        continue block6;
                    }
                    case 3: {
                        this._baseCoords[n3] = new BaseCoordFormat3(dataInput);
                    }
                }
            }
        }
    }

    class MinMax {
        private final int _featMinMaxCount;
        private final FeatMinMaxRecord[] _featMinMaxRecord;

        protected MinMax(int n2) throws IOException {
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n2);
            dataInput.readUnsignedShort();
            dataInput.readUnsignedShort();
            this._featMinMaxCount = dataInput.readUnsignedShort();
            this._featMinMaxRecord = new FeatMinMaxRecord[this._featMinMaxCount];
            for (int i2 = 0; i2 < this._featMinMaxCount; ++i2) {
                this._featMinMaxRecord[i2] = new FeatMinMaxRecord(dataInput);
            }
        }
    }

    static class FeatMinMaxRecord {
        protected FeatMinMaxRecord(DataInput dataInput) throws IOException {
            dataInput.readInt();
            dataInput.readUnsignedShort();
            dataInput.readUnsignedShort();
        }
    }

    class BaseCoordFormat3
    extends BaseCoord {
        private final short _coordinate;

        protected BaseCoordFormat3(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
            dataInput.readUnsignedShort();
        }

        @Override
        int getBaseCoordFormat() {
            return 2;
        }

        @Override
        short getCoordinate() {
            return this._coordinate;
        }
    }

    class BaseCoordFormat2
    extends BaseCoord {
        private final short _coordinate;

        protected BaseCoordFormat2(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
            dataInput.readUnsignedShort();
            dataInput.readUnsignedShort();
        }

        @Override
        int getBaseCoordFormat() {
            return 2;
        }

        @Override
        short getCoordinate() {
            return this._coordinate;
        }
    }

    class BaseCoordFormat1
    extends BaseCoord {
        private final short _coordinate;

        protected BaseCoordFormat1(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
        }

        @Override
        int getBaseCoordFormat() {
            return 1;
        }

        @Override
        short getCoordinate() {
            return this._coordinate;
        }
    }

    abstract class BaseCoord {
        BaseCoord() {
        }

        abstract int getBaseCoordFormat();

        abstract short getCoordinate();
    }
}

