/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import jogamp.graph.font.typecast.ot.table.CffStandardStrings;
import jogamp.graph.font.typecast.ot.table.Charstring;
import jogamp.graph.font.typecast.ot.table.CharstringType2;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class CffTable
implements Table {
    private final DirectoryEntry _de;
    private final int _major;
    private final int _minor;
    private final int _hdrSize;
    private final int _offSize;
    private final NameIndex _nameIndex;
    private final TopDictIndex _topDictIndex;
    private final StringIndex _stringIndex;
    private final Index _globalSubrIndex;
    private final Index[] _charStringsIndexArray;
    private final Charset[] _charsets;
    private final Charstring[][] _charstringsArray;
    private final byte[] _buf;

    protected CffTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._buf = new byte[directoryEntry.getLength()];
        dataInput.readFully(this._buf);
        DataInput dataInput2 = this.getDataInputForOffset(0);
        this._major = dataInput2.readUnsignedByte();
        this._minor = dataInput2.readUnsignedByte();
        this._hdrSize = dataInput2.readUnsignedByte();
        this._offSize = dataInput2.readUnsignedByte();
        dataInput2 = this.getDataInputForOffset(this._hdrSize);
        this._nameIndex = new NameIndex(dataInput2);
        this._topDictIndex = new TopDictIndex(dataInput2);
        this._stringIndex = new StringIndex(dataInput2);
        this._globalSubrIndex = new Index(dataInput2);
        this._charStringsIndexArray = new Index[this._topDictIndex.getCount()];
        this._charsets = new Charset[this._topDictIndex.getCount()];
        this._charstringsArray = new Charstring[this._topDictIndex.getCount()][];
        for (int i2 = 0; i2 < this._topDictIndex.getCount(); ++i2) {
            Integer n2 = (Integer)this._topDictIndex.getTopDict(i2).getValue(17);
            dataInput2 = this.getDataInputForOffset(n2);
            this._charStringsIndexArray[i2] = new Index(dataInput2);
            int n3 = this._charStringsIndexArray[i2].getCount();
            Integer n4 = (Integer)this._topDictIndex.getTopDict(i2).getValue(15);
            dataInput2 = this.getDataInputForOffset(n4);
            int n5 = dataInput2.readUnsignedByte();
            switch (n5) {
                case 0: {
                    this._charsets[i2] = new CharsetFormat0(dataInput2, n3);
                    break;
                }
                case 1: {
                    this._charsets[i2] = new CharsetFormat1(dataInput2, n3);
                    break;
                }
                case 2: {
                    this._charsets[i2] = new CharsetFormat2(dataInput2, n3);
                }
            }
            this._charstringsArray[i2] = new Charstring[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = this._charStringsIndexArray[i2].getOffset(i3) - 1;
                int n7 = this._charStringsIndexArray[i2].getOffset(i3 + 1) - n6 - 1;
                this._charstringsArray[i2][i3] = new CharstringType2(i2, this._stringIndex.getString(this._charsets[i2].getSID(i3)), this._charStringsIndexArray[i2].getData(), n6, n7, null, null);
            }
        }
    }

    private DataInput getDataInputForOffset(int n2) {
        return new DataInputStream(new ByteArrayInputStream(this._buf, n2, this._de.getLength() - n2));
    }

    public NameIndex getNameIndex() {
        return this._nameIndex;
    }

    public Charset getCharset(int n2) {
        return this._charsets[n2];
    }

    public Charstring getCharstring(int n2, int n3) {
        return this._charstringsArray[n2][n3];
    }

    public int getCharstringCount(int n2) {
        return this._charstringsArray[n2].length;
    }

    @Override
    public int getType() {
        return 1128678944;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'CFF' Table - Compact Font Format\n---------------------------------\n");
        stringBuilder.append("\nName INDEX\n");
        stringBuilder.append(this._nameIndex.toString());
        stringBuilder.append("\nTop DICT INDEX\n");
        stringBuilder.append(this._topDictIndex.toString());
        stringBuilder.append("\nString INDEX\n");
        stringBuilder.append(this._stringIndex.toString());
        stringBuilder.append("\nGlobal Subr INDEX\n");
        stringBuilder.append(this._globalSubrIndex.toString());
        for (int i2 = 0; i2 < this._charStringsIndexArray.length; ++i2) {
            stringBuilder.append("\nCharStrings INDEX ").append(i2).append("\n");
            stringBuilder.append(this._charStringsIndexArray[i2].toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    private class CharsetFormat2
    extends Charset {
        private final ArrayList<CharsetRange> _charsetRanges;

        protected CharsetFormat2(DataInput dataInput, int n2) throws IOException {
            CharsetRange2 charsetRange2;
            this._charsetRanges = new ArrayList();
            for (int i2 = n2 - 1; i2 > 0; i2 -= charsetRange2.getLeft() + 1) {
                charsetRange2 = new CharsetRange2(dataInput);
                this._charsetRanges.add(charsetRange2);
            }
        }

        @Override
        public int getFormat() {
            return 2;
        }

        @Override
        public int getSID(int n2) {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            for (CharsetRange charsetRange : this._charsetRanges) {
                if (n2 < charsetRange.getLeft() + n3) {
                    int n4 = n2 - n3 + charsetRange.getFirst() - 1;
                    return n4;
                }
                n3 += charsetRange.getLeft();
            }
            return 0;
        }
    }

    private class CharsetFormat1
    extends Charset {
        private final ArrayList<CharsetRange> _charsetRanges;

        protected CharsetFormat1(DataInput dataInput, int n2) throws IOException {
            CharsetRange1 charsetRange1;
            this._charsetRanges = new ArrayList();
            for (int i2 = n2 - 1; i2 > 0; i2 -= charsetRange1.getLeft() + 1) {
                charsetRange1 = new CharsetRange1(dataInput);
                this._charsetRanges.add(charsetRange1);
            }
        }

        @Override
        public int getFormat() {
            return 1;
        }

        @Override
        public int getSID(int n2) {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            for (CharsetRange charsetRange : this._charsetRanges) {
                if (n2 >= (n3 += charsetRange.getLeft())) continue;
                int n4 = n2 - n3 + charsetRange.getFirst();
                return n4;
            }
            return 0;
        }
    }

    private class CharsetFormat0
    extends Charset {
        private final int[] _glyph;

        protected CharsetFormat0(DataInput dataInput, int n2) throws IOException {
            this._glyph = new int[n2 - 1];
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                this._glyph[i2] = dataInput.readUnsignedShort();
            }
        }

        @Override
        public int getFormat() {
            return 0;
        }

        @Override
        public int getSID(int n2) {
            if (n2 == 0) {
                return 0;
            }
            return this._glyph[n2 - 1];
        }
    }

    private abstract class Charset {
        private Charset() {
        }

        public abstract int getFormat();

        public abstract int getSID(int var1);
    }

    private class CharsetRange2
    extends CharsetRange {
        protected CharsetRange2(DataInput dataInput) throws IOException {
            this.setFirst(dataInput.readUnsignedShort());
            this.setLeft(dataInput.readUnsignedShort());
        }
    }

    private class CharsetRange1
    extends CharsetRange {
        protected CharsetRange1(DataInput dataInput) throws IOException {
            this.setFirst(dataInput.readUnsignedShort());
            this.setLeft(dataInput.readUnsignedByte());
        }
    }

    private class CharsetRange {
        private int _first;
        private int _left;

        private CharsetRange() {
        }

        public int getFirst() {
            return this._first;
        }

        protected void setFirst(int n2) {
            this._first = n2;
        }

        public int getLeft() {
            return this._left;
        }

        protected void setLeft(int n2) {
            this._left = n2;
        }
    }

    public class StringIndex
    extends Index {
        protected StringIndex(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public String getString(int n2) {
            if (n2 < CffStandardStrings.standardStrings.length) {
                return CffStandardStrings.standardStrings[n2];
            }
            if ((n2 -= CffStandardStrings.standardStrings.length) >= this.getCount()) {
                return null;
            }
            int n3 = this.getOffset(n2) - 1;
            int n4 = this.getOffset(n2 + 1) - n3 - 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = n3; i2 < n3 + n4; ++i2) {
                stringBuilder.append((char)this.getData()[i2]);
            }
            return stringBuilder.toString();
        }

        @Override
        public String toString() {
            int n2 = CffStandardStrings.standardStrings.length;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.getCount(); ++i2) {
                stringBuilder.append(n2 + i2).append(": ");
                stringBuilder.append(this.getString(n2 + i2)).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public class NameIndex
    extends Index {
        protected NameIndex(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public String getName(int n2) {
            String string = null;
            int n3 = this.getOffset(n2) - 1;
            int n4 = this.getOffset(n2 + 1) - n3 - 1;
            if (this.getData()[n3] != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = n3; i2 < n3 + n4; ++i2) {
                    stringBuilder.append((char)this.getData()[i2]);
                }
                string = stringBuilder.toString();
            } else {
                string = "DELETED NAME";
            }
            return string;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.getCount(); ++i2) {
                stringBuilder.append(this.getName(i2)).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public class TopDictIndex
    extends Index {
        protected TopDictIndex(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public Dict getTopDict(int n2) {
            int n3 = this.getOffset(n2) - 1;
            int n4 = this.getOffset(n2 + 1) - n3 - 1;
            return new Dict(this.getData(), n3, n4);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.getCount(); ++i2) {
                stringBuilder.append(this.getTopDict(i2).toString()).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public class Index {
        private final int _count;
        private final int _offSize;
        private final int[] _offset;
        private final int[] _data;

        protected Index(DataInput dataInput) throws IOException {
            int n2;
            this._count = dataInput.readUnsignedShort();
            this._offset = new int[this._count + 1];
            this._offSize = dataInput.readUnsignedByte();
            for (n2 = 0; n2 < this._count + 1; ++n2) {
                int n3 = 0;
                for (int i2 = 0; i2 < this._offSize; ++i2) {
                    n3 |= dataInput.readUnsignedByte() << (this._offSize - i2 - 1) * 8;
                }
                this._offset[n2] = n3;
            }
            this._data = new int[this.getDataLength()];
            for (n2 = 0; n2 < this.getDataLength(); ++n2) {
                this._data[n2] = dataInput.readUnsignedByte();
            }
        }

        public int getCount() {
            return this._count;
        }

        public int getOffset(int n2) {
            return this._offset[n2];
        }

        public int getDataLength() {
            return this._offset[this._offset.length - 1] - 1;
        }

        public int[] getData() {
            return this._data;
        }

        public String toString() {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DICT\n");
            stringBuilder.append("count: ").append(this._count).append("\n");
            stringBuilder.append("offSize: ").append(this._offSize).append("\n");
            for (n2 = 0; n2 < this._count + 1; ++n2) {
                stringBuilder.append("offset[").append(n2).append("]: ").append(this._offset[n2]).append("\n");
            }
            stringBuilder.append("data:");
            for (n2 = 0; n2 < this._data.length; ++n2) {
                if (n2 % 8 == 0) {
                    stringBuilder.append("\n");
                } else {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this._data[n2]);
            }
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }

    public static class Dict {
        private final Dictionary<Integer, Object> _entries = new Hashtable<Integer, Object>();
        private final int[] _data;
        private int _index;

        protected Dict(int[] nArray, int n2, int n3) {
            this._data = nArray;
            this._index = n2;
            while (this._index < n2 + n3) {
                this.addKeyAndValueEntry();
            }
        }

        public Object getValue(int n2) {
            return this._entries.get(n2);
        }

        private boolean addKeyAndValueEntry() {
            int n2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = null;
            while (this.isOperandAtIndex()) {
                object = this.nextOperand();
                arrayList.add(object);
            }
            if ((n2 = this._data[this._index++]) == 12) {
                n2 <<= 8;
                n2 |= this._data[this._index++];
            }
            if (arrayList.size() == 1) {
                this._entries.put(n2, object);
            } else {
                this._entries.put(n2, arrayList);
            }
            return true;
        }

        private boolean isOperandAtIndex() {
            int n2 = this._data[this._index];
            return 32 <= n2 && n2 <= 254 || n2 == 28 || n2 == 29 || n2 == 30;
        }

        private boolean isOperatorAtIndex() {
            int n2 = this._data[this._index];
            return 0 <= n2 && n2 <= 21;
        }

        private Object nextOperand() {
            int n2 = this._data[this._index];
            if (32 <= n2 && n2 <= 246) {
                ++this._index;
                return n2 - 139;
            }
            if (247 <= n2 && n2 <= 250) {
                int n3 = this._data[this._index + 1];
                this._index += 2;
                return (n2 - 247) * 256 + n3 + 108;
            }
            if (251 <= n2 && n2 <= 254) {
                int n4 = this._data[this._index + 1];
                this._index += 2;
                return -(n2 - 251) * 256 - n4 - 108;
            }
            if (n2 == 28) {
                int n5 = this._data[this._index + 1];
                int n6 = this._data[this._index + 2];
                this._index += 3;
                return n5 << 8 | n6;
            }
            if (n2 == 29) {
                int n7 = this._data[this._index + 1];
                int n8 = this._data[this._index + 2];
                int n9 = this._data[this._index + 3];
                int n10 = this._data[this._index + 4];
                this._index += 5;
                return n7 << 24 | n8 << 16 | n9 << 8 | n10;
            }
            if (n2 == 30) {
                StringBuilder stringBuilder = new StringBuilder();
                int n11 = 0;
                int n12 = 0;
                ++this._index;
                while (n11 != 15 && n12 != 15) {
                    n11 = this._data[this._index] >> 4;
                    n12 = this._data[this._index] & 0xF;
                    ++this._index;
                    stringBuilder.append(this.decodeRealNibble(n11));
                    stringBuilder.append(this.decodeRealNibble(n12));
                }
                return Float.valueOf(stringBuilder.toString());
            }
            return null;
        }

        private String decodeRealNibble(int n2) {
            if (n2 < 10) {
                return Integer.toString(n2);
            }
            if (n2 == 10) {
                return ".";
            }
            if (n2 == 11) {
                return "E";
            }
            if (n2 == 12) {
                return "E-";
            }
            if (n2 == 14) {
                return "-";
            }
            return "";
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration<Integer> enumeration = this._entries.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = enumeration.nextElement();
                if ((n2 & 0xC00) == 3072) {
                    stringBuilder.append("12 ").append((int)(n2 & 0xFF)).append(": ");
                } else {
                    stringBuilder.append(n2.toString()).append(": ");
                }
                stringBuilder.append(this._entries.get(n2).toString()).append("\n");
            }
            return stringBuilder.toString();
        }
    }
}

