/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat0;
import jogamp.graph.font.typecast.ot.table.CmapFormat2;
import jogamp.graph.font.typecast.ot.table.CmapFormat4;
import jogamp.graph.font.typecast.ot.table.CmapFormat6;
import jogamp.graph.font.typecast.ot.table.CmapFormatUnknown;

public abstract class CmapFormat {
    protected int _format;
    protected int _length;
    protected int _language;

    protected CmapFormat(DataInput dataInput) throws IOException {
        this._length = dataInput.readUnsignedShort();
        this._language = dataInput.readUnsignedShort();
    }

    protected static CmapFormat create(int n2, DataInput dataInput) throws IOException {
        switch (n2) {
            case 0: {
                return new CmapFormat0(dataInput);
            }
            case 2: {
                return new CmapFormat2(dataInput);
            }
            case 4: {
                return new CmapFormat4(dataInput);
            }
            case 6: {
                return new CmapFormat6(dataInput);
            }
        }
        return new CmapFormatUnknown(n2, dataInput);
    }

    public int getFormat() {
        return this._format;
    }

    public int getLength() {
        return this._length;
    }

    public int getLanguage() {
        return this._language;
    }

    public abstract int getRangeCount();

    public abstract Range getRange(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract int mapCharCode(int var1);

    public String toString() {
        return "format: " + this._format + ", length: " + this._length + ", language: " + this._language;
    }

    public static class Range {
        private final int _startCode;
        private final int _endCode;

        protected Range(int n2, int n3) {
            this._startCode = n2;
            this._endCode = n3;
        }

        public int getStartCode() {
            return this._startCode;
        }

        public int getEndCode() {
            return this._endCode;
        }
    }
}

