/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.ToolkitLock;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedResourceToolkitLock
implements ToolkitLock {
    private static final LongObjectHashMap handle2Lock = new LongObjectHashMap();
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final long handle;
    private final AtomicInteger refCount;

    public static int shutdown(boolean bl) {
        if (DEBUG || bl || handle2Lock.size() > 0) {
            System.err.println("SharedResourceToolkitLock: Shutdown (open: " + handle2Lock.size() + ")");
            if (DEBUG) {
                ExceptionUtils.dumpStack(System.err);
            }
            if (handle2Lock.size() > 0) {
                SharedResourceToolkitLock.dumpOpenDisplayConnections();
            }
        }
        return handle2Lock.size();
    }

    public static void dumpOpenDisplayConnections() {
        System.err.println("SharedResourceToolkitLock: Open ResourceToolkitLock's: " + handle2Lock.size());
        int n2 = 0;
        for (LongObjectHashMap.Entry entry : handle2Lock) {
            System.err.println("SharedResourceToolkitLock: Open[" + n2 + "]: " + entry.value);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SharedResourceToolkitLock get(long l2) {
        SharedResourceToolkitLock sharedResourceToolkitLock;
        LongObjectHashMap longObjectHashMap = handle2Lock;
        synchronized (longObjectHashMap) {
            sharedResourceToolkitLock = (SharedResourceToolkitLock)handle2Lock.get(l2);
            if (null == sharedResourceToolkitLock) {
                sharedResourceToolkitLock = new SharedResourceToolkitLock(l2);
                sharedResourceToolkitLock.refCount.incrementAndGet();
                handle2Lock.put(l2, sharedResourceToolkitLock);
                if (DEBUG || TRACE_LOCK) {
                    System.err.println("SharedResourceToolkitLock.get() * NEW   *: " + sharedResourceToolkitLock);
                }
            } else {
                sharedResourceToolkitLock.refCount.incrementAndGet();
                if (DEBUG || TRACE_LOCK) {
                    System.err.println("SharedResourceToolkitLock.get() * EXIST *: " + sharedResourceToolkitLock);
                }
            }
        }
        return sharedResourceToolkitLock;
    }

    private SharedResourceToolkitLock(long l2) {
        this.handle = l2;
        this.refCount = new AtomicInteger(0);
    }

    @Override
    public final void lock() {
        this.lock.lock();
        if (TRACE_LOCK) {
            System.err.println(Thread.currentThread() + " SharedResourceToolkitLock: lock() " + this.toStringImpl());
        }
    }

    @Override
    public final void unlock() {
        if (TRACE_LOCK) {
            System.err.println(Thread.currentThread() + " SharedResourceToolkitLock: unlock() " + this.toStringImpl());
        }
        this.lock.unlock();
    }

    @Override
    public final void validateLocked() throws RuntimeException {
        this.lock.validateLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (0 < this.refCount.get()) {
            LongObjectHashMap longObjectHashMap = handle2Lock;
            synchronized (longObjectHashMap) {
                if (0 == this.refCount.decrementAndGet()) {
                    if (DEBUG || TRACE_LOCK) {
                        System.err.println("SharedResourceToolkitLock.dispose() * REMOV *: " + this);
                    }
                    handle2Lock.remove(this.handle);
                } else if (DEBUG || TRACE_LOCK) {
                    System.err.println("SharedResourceToolkitLock.dispose() * DOWN  *: " + this);
                }
            }
        } else if (DEBUG || TRACE_LOCK) {
            System.err.println("SharedResourceToolkitLock.dispose() * NULL  *: " + this);
        }
    }

    public String toString() {
        return "SharedResourceToolkitLock[" + this.toStringImpl() + "]";
    }

    private String toStringImpl() {
        return "refCount " + this.refCount + ", handle 0x" + Long.toHexString(this.handle) + ", obj 0x" + Integer.toHexString(this.hashCode()) + ", isOwner " + this.lock.isOwner(Thread.currentThread()) + ", " + this.lock.toString();
    }

    static {
        handle2Lock.setKeyNotFoundValue(null);
    }
}

