/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import java.util.ArrayList;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.RandR;
import jogamp.newt.driver.x11.RandR11;
import jogamp.newt.driver.x11.RandR13;

public class ScreenDriver
extends ScreenImpl {
    protected static final boolean DEBUG_TEST_RANDR13_DISABLED;
    private VersionNumber randrVersion;
    private RandR rAndR;
    private final DisplayImpl.DisplayRunnable<Boolean> xineramaEnabledQueryWithTemp = new DisplayImpl.DisplayRunnable<Boolean>(){

        @Override
        public Boolean run(long l2) {
            return X11Util.XineramaIsEnabled(l2);
        }
    };

    static void initSingleton() {
    }

    @Override
    protected void createNativeImpl() {
        Long l2 = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Long>(){

            @Override
            public Long run(long l2) {
                return ScreenDriver.GetScreen0(l2, ScreenDriver.this.screen_idx);
            }
        });
        if (l2 == 0L) {
            throw new RuntimeException("Error creating screen: " + this.screen_idx);
        }
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)this.getDisplay().getGraphicsDevice();
        long l3 = x11GraphicsDevice.getHandle();
        this.aScreen = new X11GraphicsScreen(x11GraphicsDevice, this.screen_idx);
        int[] nArray = ScreenDriver.getRandRVersion0(l3);
        this.randrVersion = new VersionNumber(nArray[0], nArray[1], 0);
        this.rAndR = !DEBUG_TEST_RANDR13_DISABLED && this.randrVersion.compareTo(RandR.version130) >= 0 ? new RandR13(this.randrVersion) : (this.randrVersion.compareTo(RandR.version110) >= 0 ? new RandR11(this.randrVersion) : null);
        ((DisplayDriver)this.display).registerRandR(this.rAndR);
        if (DEBUG) {
            System.err.println("Using " + this.rAndR);
            this.rAndR.dumpInfo(l3, this.screen_idx);
        }
    }

    @Override
    protected void closeNativeImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        block13: {
            if (null == this.rAndR) {
                return;
            }
            AbstractGraphicsDevice abstractGraphicsDevice = this.getDisplay().getGraphicsDevice();
            abstractGraphicsDevice.lock();
            try {
                if (!this.rAndR.beginInitialQuery(abstractGraphicsDevice.getHandle(), this)) break block13;
                try {
                    int[] nArray;
                    int n2;
                    int[] nArray2 = this.rAndR.getMonitorDeviceIds(abstractGraphicsDevice.getHandle(), this);
                    int n3 = nArray2.length;
                    ArrayHashSet arrayHashSet = new ArrayHashSet();
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArray = this.rAndR.getAvailableRotations(abstractGraphicsDevice.getHandle(), this, nArray2[n2]);
                        if (null == nArray) continue;
                        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
                        for (int i2 = 0; i2 < nArray.length; ++i2) {
                            arrayList.add(nArray[i2]);
                        }
                        arrayHashSet.addAll(arrayList);
                    }
                    n2 = 0;
                    do {
                        if (null == (nArray = this.rAndR.getMonitorModeProps(abstractGraphicsDevice.getHandle(), this, n2++))) continue;
                        for (int i3 = 0; i3 < arrayHashSet.size(); ++i3) {
                            nArray[7] = (Integer)arrayHashSet.get(i3);
                            MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
                        }
                    } while (null != nArray);
                    if (cache.monitorModes.size() > 0) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            nArray = this.rAndR.getMonitorDeviceProps(abstractGraphicsDevice.getHandle(), this, cache, nArray2[n2]);
                            if (null == nArray || 17 > nArray[0] || 17 > nArray.length) continue;
                            MonitorModeProps.streamInMonitorDevice(cache, this, null, nArray, 0, null);
                        }
                    }
                }
                finally {
                    this.rAndR.endInitialQuery(abstractGraphicsDevice.getHandle(), this);
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getDisplay().getGraphicsDevice();
        abstractGraphicsDevice.lock();
        try {
            int[] nArray = this.rAndR.getMonitorDeviceViewport(abstractGraphicsDevice.getHandle(), this, monitorDevice.getId());
            rectangle.set(nArray[0], nArray[1], nArray[2], nArray[3]);
            rectangle2.set(nArray[0], nArray[1], nArray[2], nArray[3]);
            boolean bl = true;
            return bl;
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    @Override
    protected MonitorMode queryCurrentMonitorModeImpl(final MonitorDevice monitorDevice) {
        if (null == this.rAndR) {
            return null;
        }
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<MonitorMode>(){

            @Override
            public MonitorMode run(long l2) {
                int[] nArray = ScreenDriver.this.rAndR.getCurrentMonitorModeProps(l2, ScreenDriver.this, monitorDevice.getId());
                return MonitorModeProps.streamInMonitorMode(null, null, nArray, 0);
            }
        });
    }

    @Override
    protected boolean setCurrentMonitorModeImpl(final MonitorDevice monitorDevice, final MonitorMode monitorMode) {
        if (null == this.rAndR) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        boolean bl = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l2) {
                return ScreenDriver.this.rAndR.setCurrentMonitorModeStart(l2, ScreenDriver.this, monitorDevice, monitorMode);
            }
        });
        boolean bl2 = bl ? this.rAndR.setCurrentMonitorModeWait(this) : false;
        if (DEBUG || !bl2) {
            System.err.println("X11Screen.setCurrentMonitorModeImpl: " + (bl2 ? " OK" : "NOK") + " (started " + bl + "): t/TO " + (System.currentTimeMillis() - l2) + "/" + 10000 + "ms; " + monitorDevice.getCurrentMode() + " -> " + monitorMode);
        }
        return bl2;
    }

    @Override
    protected int validateScreenIndex(int n2) {
        DisplayDriver displayDriver = (DisplayDriver)this.getDisplay();
        Boolean bl = displayDriver.isXineramaEnabled();
        if (null != bl) {
            return bl != false ? 0 : n2;
        }
        return this.runWithTempDisplayHandle(this.xineramaEnabledQueryWithTemp) != false ? 0 : n2;
    }

    @Override
    protected void calcVirtualScreenOriginAndSize(final Rectangle rectangle, final Rectangle rectangle2) {
        RectangleImmutable rectangleImmutable = DEBUG ? (RectangleImmutable)this.getViewport().cloneMutable() : null;
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                rectangle.set(0, 0, ScreenDriver.getWidth0(l2, ScreenDriver.this.screen_idx), ScreenDriver.getHeight0(l2, ScreenDriver.this.screen_idx));
                rectangle2.set(rectangle);
                return null;
            }
        });
        if (DEBUG) {
            System.err.println("X11Screen.calcVirtualScreenOriginAndSize: Querying X11: " + rectangleImmutable + " -> " + rectangle);
        }
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return this.display.runWithLockedDisplayDevice(displayRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWithTempDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        T t;
        long l2 = X11Util.openDisplay(this.display.getName());
        if (0L == l2) {
            throw new RuntimeException("null device");
        }
        try {
            t = displayRunnable.run(l2);
        }
        finally {
            X11Util.closeDisplay(l2);
        }
        return t;
    }

    private static native long GetScreen0(long var0, int var2);

    private static native int getWidth0(long var0, int var2);

    private static native int getHeight0(long var0, int var2);

    private static native int[] getRandRVersion0(long var0);

    static {
        Debug.initSingleton();
        DEBUG_TEST_RANDR13_DISABLED = PropertyAccess.isPropertyDefined("newt.test.Screen.disableRandR13", true);
        DisplayDriver.initSingleton();
    }
}

