/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLFBODrawable;
import com.jogamp.opengl.GLRunnable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLRunnableTask;

public class GLDrawableHelper {
    private static final boolean PERF_STATS;
    protected static final boolean DEBUG;
    private final Object listenersLock = new Object();
    private final ArrayList<GLEventListener> listeners = new ArrayList();
    private final HashSet<GLEventListener> listenersToBeInit = new HashSet();
    private final Object glRunnablesLock = new Object();
    private ArrayList<GLRunnableTask> glRunnables = new ArrayList();
    private volatile int glRunnableCount = 0;
    private boolean autoSwapBufferMode;
    private volatile Thread exclusiveContextThread;
    private volatile int exclusiveContextSwitch;
    private GLAnimatorControl animatorCtrl;
    private static Runnable nop;
    private GLContext sharedContext;
    private GLAutoDrawable sharedAutoDrawable;
    private static final int MAX_RELEASE_ITER = 512;
    private static final ThreadLocal<WeakReference<Runnable>> perThreadInitAction;

    public GLDrawableHelper() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.clear();
            this.listenersToBeInit.clear();
        }
        this.autoSwapBufferMode = true;
        this.exclusiveContextThread = null;
        this.exclusiveContextSwitch = 0;
        object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnableCount = 0;
            this.glRunnables.clear();
        }
        this.animatorCtrl = null;
        this.sharedContext = null;
        this.sharedAutoDrawable = null;
    }

    public final void setSharedContext(GLContext gLContext, GLContext gLContext2) throws IllegalStateException {
        if (null == gLContext2) {
            throw new IllegalStateException("Null shared GLContext");
        }
        if (gLContext == gLContext2) {
            throw new IllegalStateException("Shared GLContext same as local");
        }
        if (null != this.sharedContext) {
            throw new IllegalStateException("Shared GLContext already set");
        }
        if (null != this.sharedAutoDrawable) {
            throw new IllegalStateException("Shared GLAutoDrawable already set");
        }
        this.sharedContext = gLContext2;
    }

    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2) throws IllegalStateException {
        if (null == gLAutoDrawable2) {
            throw new IllegalStateException("Null shared GLAutoDrawable");
        }
        if (gLAutoDrawable == gLAutoDrawable2) {
            throw new IllegalStateException("Shared GLAutoDrawable same as this");
        }
        if (null != this.sharedContext) {
            throw new IllegalStateException("Shared GLContext already set");
        }
        if (null != this.sharedAutoDrawable) {
            throw new IllegalStateException("Shared GLAutoDrawable already set");
        }
        this.sharedAutoDrawable = gLAutoDrawable2;
    }

    public boolean isSharedGLContextPending(GLContext[] gLContextArray) {
        GLContext gLContext;
        boolean bl = null != this.sharedAutoDrawable ? null == (gLContext = this.sharedAutoDrawable.getContext()) || !gLContext.isCreated() || !this.sharedAutoDrawable.areAllGLEventListenerInitialized() : null != (gLContext = this.sharedContext) && !gLContext.isCreated();
        gLContextArray[0] = gLContext;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GLAnimatorControl: " + this.animatorCtrl + ", ");
        Object object = this.listenersLock;
        synchronized (object) {
            stringBuilder.append("GLEventListeners num " + this.listeners.size() + " [");
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                GLEventListener gLEventListener = this.listeners.get(i2);
                stringBuilder.append(gLEventListener);
                stringBuilder.append("[init ");
                stringBuilder.append(!this.listenersToBeInit.contains(gLEventListener));
                stringBuilder.append("], ");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final void forceNativeRelease(GLContext gLContext) {
        int n2 = 0;
        do {
            gLContext.release();
            ++n2;
            if (!DEBUG) continue;
            System.err.println("GLDrawableHelper.forceNativeRelease() #" + n2 + " -- currentThread " + Thread.currentThread() + " -> " + GLContext.getCurrent());
        } while (512 > n2 && gLContext.isCurrent());
        if (gLContext.isCurrent()) {
            throw new GLException("Context still current after 512 releases: " + gLContext);
        }
    }

    public static final void switchContext(GLDrawable gLDrawable, GLContext gLContext, boolean bl, GLContext gLContext2, int n2) {
        if (null != gLContext) {
            if (bl) {
                gLContext.destroy();
            } else {
                gLContext.setGLDrawable(null, true);
            }
        }
        if (null != gLContext2) {
            gLContext2.setContextCreationFlags(n2);
            gLContext2.setGLDrawable(gLDrawable, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl recreateGLDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        ProxySurface proxySurface;
        if (!gLDrawableImpl.isRealized()) {
            return gLDrawableImpl;
        }
        GLContext gLContext2 = GLContext.getCurrent();
        GLDrawableFactory gLDrawableFactory = gLDrawableImpl.getFactory();
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        ProxySurface proxySurface2 = proxySurface = nativeSurface instanceof ProxySurface ? (ProxySurface)nativeSurface : null;
        if (null != gLContext) {
            if (gLContext2 != gLContext) {
                gLContext.makeCurrent();
            }
            gLContext.setGLDrawable(null, true);
        }
        if (null != proxySurface) {
            proxySurface.enableUpstreamSurfaceHookLifecycle(false);
        }
        try {
            gLDrawableImpl.setRealized(false);
            gLDrawableImpl = (GLDrawableImpl)gLDrawableFactory.createGLDrawable(nativeSurface);
            gLDrawableImpl.setRealized(true);
        }
        finally {
            if (null != proxySurface) {
                proxySurface.enableUpstreamSurfaceHookLifecycle(true);
            }
        }
        if (null != gLContext) {
            gLContext.setGLDrawable(gLDrawableImpl, true);
        }
        if (null != gLContext2) {
            gLContext2.makeCurrent();
        }
        return gLDrawableImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl resizeOffscreenDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext, int n2, int n3) throws NativeWindowException, GLException {
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        int n4 = nativeSurface.lockSurface();
        if (1 >= n4) {
            throw new NativeWindowException("Could not lock surface of drawable: " + gLDrawableImpl);
        }
        boolean bl = true;
        try {
            if (!gLDrawableImpl.isRealized()) {
                GLDrawableImpl gLDrawableImpl2 = gLDrawableImpl;
                return gLDrawableImpl2;
            }
            if (gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
                throw new NativeWindowException("Drawable is not offscreen: " + gLDrawableImpl);
            }
            if (DEBUG && (0 >= n2 || 0 >= n3)) {
                System.err.println("WARNING: Odd size detected: " + n2 + "x" + n3 + ", using safe size 1x1. Drawable " + gLDrawableImpl);
                ExceptionUtils.dumpStack(System.err);
            }
            if (0 >= n2) {
                n2 = 1;
                bl = false;
            }
            if (0 >= n3) {
                n3 = 1;
                bl = false;
            }
            if (nativeSurface instanceof ProxySurface) {
                ProxySurface proxySurface = (ProxySurface)nativeSurface;
                UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
                if (upstreamSurfaceHook instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSurfaceSize(n2, n3);
                } else if (DEBUG) {
                    System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen ProxySurface n.a. UpstreamSurfaceHook.MutableSize, but " + upstreamSurfaceHook.getClass().getName() + ": " + upstreamSurfaceHook);
                }
            } else if (DEBUG) {
                System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen surface n.a. ProxySurface, but " + nativeSurface.getClass().getName() + ": " + nativeSurface);
            }
            if (gLDrawableImpl instanceof GLFBODrawable) {
                if (null != gLContext && gLContext.isCreated()) {
                    ((GLFBODrawable)((Object)gLDrawableImpl)).resetSize(gLContext.getGL());
                }
            } else {
                gLDrawableImpl = GLDrawableHelper.recreateGLDrawable(gLDrawableImpl, gLContext);
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
        if (bl && (gLDrawableImpl.getSurfaceWidth() != n2 || gLDrawableImpl.getSurfaceHeight() != n3)) {
            throw new InternalError("Incomplete resize operation: expected " + n2 + "x" + n3 + ", has: " + gLDrawableImpl);
        }
        return gLDrawableImpl;
    }

    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.addGLEventListener(-1, gLEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGLEventListener(int n2, GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n2) {
                n2 = this.listeners.size();
            }
            this.listenersToBeInit.add(gLEventListener);
            this.listeners.add(n2, gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersToBeInit.remove(gLEventListener);
            return this.listeners.remove(gLEventListener) ? gLEventListener : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(int n2) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n2) {
                n2 = this.listeners.size() - 1;
            }
            GLEventListener gLEventListener = this.listeners.remove(n2);
            this.listenersToBeInit.remove(gLEventListener);
            return gLEventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getGLEventListenerCount() {
        Object object = this.listenersLock;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener getGLEventListener(int n2) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n2) {
                n2 = this.listeners.size() - 1;
            }
            return this.listeners.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean areAllGLEventListenerInitialized() {
        Object object = this.listenersLock;
        synchronized (object) {
            return 0 == this.listenersToBeInit.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            return !this.listenersToBeInit.contains(gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                this.listenersToBeInit.remove(gLEventListener);
            } else {
                this.listenersToBeInit.add(gLEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener disposeGLEventListener(GLAutoDrawable gLAutoDrawable, GLEventListener gLEventListener, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                if (this.listeners.remove(gLEventListener)) {
                    if (!this.listenersToBeInit.remove(gLEventListener)) {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    return gLEventListener;
                }
            } else if (this.listeners.contains(gLEventListener) && !this.listenersToBeInit.contains(gLEventListener)) {
                gLEventListener.dispose(gLAutoDrawable);
                this.listenersToBeInit.add(gLEventListener);
                return gLEventListener;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int disposeAllGLEventListener(GLAutoDrawable gLAutoDrawable, boolean bl) throws GLException {
        Throwable throwable = null;
        int n2 = 0;
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                for (int i2 = this.listeners.size(); 0 < i2 && 0 < this.listeners.size(); --i2) {
                    GLEventListener gLEventListener = this.listeners.remove(0);
                    if (this.listenersToBeInit.remove(gLEventListener)) continue;
                    try {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    catch (Throwable throwable2) {
                        if (null == throwable) {
                            throwable = throwable2;
                        }
                        ExceptionUtils.dumpThrowable("subsequent", throwable2);
                    }
                    ++n2;
                }
            } else {
                for (int i3 = 0; i3 < this.listeners.size(); ++i3) {
                    GLEventListener gLEventListener = this.listeners.get(i3);
                    if (this.listenersToBeInit.contains(gLEventListener)) continue;
                    try {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    catch (Throwable throwable3) {
                        if (null == throwable) {
                            throwable = throwable3;
                        }
                        ExceptionUtils.dumpThrowable("subsequent", throwable3);
                    }
                    this.listenersToBeInit.add(gLEventListener);
                    ++n2;
                }
            }
        }
        if (null != throwable) {
            this.flushGLRunnables();
            throw GLException.newGLException(throwable);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener disposeGLEventListener(final GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, final GLEventListener gLEventListener, final boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listenersToBeInit.contains(gLEventListener)) {
                if (bl) {
                    this.listenersToBeInit.remove(gLEventListener);
                    return this.listeners.remove(gLEventListener) ? gLEventListener : null;
                }
                return null;
            }
        }
        boolean bl2 = this.isAnimatorAnimatingOnOtherThread() && this.animatorCtrl.pause();
        final GLEventListener[] gLEventListenerArray = new GLEventListener[]{null};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                gLEventListenerArray[0] = GLDrawableHelper.this.disposeGLEventListener(gLAutoDrawable, gLEventListener, bl);
            }
        };
        this.invokeGL(gLDrawable, gLContext, runnable, nop);
        if (bl2) {
            this.animatorCtrl.resume();
        }
        return gLEventListenerArray[0];
    }

    public final void disposeAllGLEventListener(final GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, final boolean bl) {
        boolean bl2 = this.isAnimatorAnimatingOnOtherThread() && this.animatorCtrl.pause();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GLDrawableHelper.this.disposeAllGLEventListener(gLAutoDrawable, bl);
            }
        };
        this.invokeGL(gLDrawable, gLContext, runnable, nop);
        if (bl2) {
            this.animatorCtrl.resume();
        }
    }

    private final void init(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        gLEventListener.init(gLAutoDrawable);
        if (bl) {
            this.reshape(gLEventListener, gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), bl2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            int n2 = arrayList.size();
            if (n2 > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    GLEventListener gLEventListener = arrayList.get(i2);
                    this.listenersToBeInit.remove(gLEventListener);
                    this.init(gLEventListener, gLAutoDrawable, bl, 0 == i2);
                }
            } else {
                gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            }
        }
    }

    public final void display(GLAutoDrawable gLAutoDrawable) {
        this.displayImpl(gLAutoDrawable);
        if (this.glRunnableCount > 0 && !this.execGLRunnables(gLAutoDrawable)) {
            this.displayImpl(gLAutoDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void displayImpl(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                GLEventListener gLEventListener = arrayList.get(i2);
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, true, this.listenersToBeInit.size() + 1 == n2);
                }
                gLEventListener.display(gLAutoDrawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runForAllGLEventListener(GLAutoDrawable gLAutoDrawable, GLEventListenerAction gLEventListenerAction) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                GLEventListener gLEventListener = arrayList.get(i2);
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, true, this.listenersToBeInit.size() + 1 == n2);
                }
                gLEventListenerAction.run(gLAutoDrawable, gLEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reshape(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        if (bl2) {
            Object object = this.listenersLock;
            synchronized (object) {
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    gLEventListener.init(gLAutoDrawable);
                }
            }
        }
        if (bl) {
            int n6;
            if ((GLContext.DEBUG_GL || DEBUG) && 0 != (n6 = gLAutoDrawable.getGL().glGetError())) {
                System.err.println("Info: GLDrawableHelper.reshape: pre-exisiting GL error 0x" + Integer.toHexString(n6));
                ExceptionUtils.dumpStack(System.err);
            }
            gLAutoDrawable.getGL().glViewport(n2, n3, n4, n5);
        }
        gLEventListener.reshape(gLAutoDrawable, n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reshape(GLAutoDrawable gLAutoDrawable, int n2, int n3, int n4, int n5) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                this.reshape(this.listeners.get(i2), gLAutoDrawable, n2, n3, n4, n5, 0 == i2, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean execGLRunnables(GLAutoDrawable gLAutoDrawable) {
        ArrayList<GLRunnableTask> arrayList;
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.glRunnables.size() <= 0) {
                return true;
            }
            this.glRunnableCount = 0;
            arrayList = this.glRunnables;
            this.glRunnables = new ArrayList();
        }
        boolean bl = true;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            bl = arrayList.get(i2).run(gLAutoDrawable) && bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushGLRunnables() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnableCount = 0;
            while (this.glRunnables.size() > 0) {
                this.glRunnables.remove(0).flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.animatorCtrl != gLAnimatorControl && null != gLAnimatorControl && null != this.animatorCtrl) {
                throw new GLException("Trying to register GLAnimatorControl " + gLAnimatorControl + ", where " + this.animatorCtrl + " is already registered. Unregister first.");
            }
            this.animatorCtrl = gLAnimatorControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLAnimatorControl getAnimator() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            return this.animatorCtrl;
        }
    }

    public final boolean isAnimatorStartedOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorStarted() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() : false;
    }

    public final boolean isAnimatorAnimatingOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() : false;
    }

    public static final boolean isLockedByOtherThread(GLAutoDrawable gLAutoDrawable) {
        Thread thread = Thread.currentThread();
        Thread thread2 = gLAutoDrawable.getUpstreamLock().getOwner();
        if (null != thread2 && thread != thread2) {
            return true;
        }
        NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
        Thread thread3 = null != nativeSurface ? nativeSurface.getSurfaceLockOwner() : null;
        return null != thread3 && thread != thread3;
    }

    public static final boolean isLockedByThisThread(GLAutoDrawable gLAutoDrawable) {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        if (thread2 == (thread = gLAutoDrawable.getUpstreamLock().getOwner())) {
            return true;
        }
        NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
        Thread thread3 = null != nativeSurface ? nativeSurface.getSurfaceLockOwner() : null;
        return thread2 == thread3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        if (null == gLRunnable || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        GLRunnableTask gLRunnableTask = null;
        Object object = new Object();
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                boolean bl3 = gLAutoDrawable.isThreadGLCapable();
                bl2 = this.isAnimatorAnimatingOnOtherThread();
                if (bl2) {
                    if (bl && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        if (!bl3) throw new IllegalStateException("Deferred, wait, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                        bl2 = false;
                        bl = false;
                    }
                } else {
                    if (!bl3 && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        throw new IllegalStateException("Not deferred, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                    }
                    bl = false;
                }
                gLRunnableTask = new GLRunnableTask(gLRunnable, bl ? object : null, bl);
                ++this.glRunnableCount;
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else {
                if (!bl) return true;
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null == throwable) return true;
                throw new RuntimeException(throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, List<GLRunnable> list) throws IllegalStateException {
        if (null == list || list.size() == 0 || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        int n2 = list.size();
        GLRunnableTask gLRunnableTask = null;
        Object object = new Object();
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                boolean bl3 = gLAutoDrawable.isThreadGLCapable();
                bl2 = this.isAnimatorAnimatingOnOtherThread();
                if (bl2) {
                    if (bl && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        if (!bl3) throw new IllegalStateException("Deferred, wait, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                        bl2 = false;
                        bl = false;
                    }
                } else {
                    if (!bl3 && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        throw new IllegalStateException("Not deferred, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                    }
                    bl = false;
                }
                for (int i2 = 0; i2 < n2 - 1; ++i2) {
                    ++this.glRunnableCount;
                    this.glRunnables.add(new GLRunnableTask(list.get(i2), null, false));
                }
                gLRunnableTask = new GLRunnableTask(list.get(n2 - 1), bl ? object : null, bl);
                ++this.glRunnableCount;
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else {
                if (!bl) return true;
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null == throwable) return true;
                throw new RuntimeException(throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(GLRunnable gLRunnable) {
        if (null == gLRunnable) {
            return;
        }
        Object object = this.glRunnablesLock;
        synchronized (object) {
            ++this.glRunnableCount;
            this.glRunnables.add(new GLRunnableTask(gLRunnable, null, false));
        }
    }

    public final void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public final boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    private final String getExclusiveContextSwitchString() {
        return 0 == this.exclusiveContextSwitch ? "nop" : (0 > this.exclusiveContextSwitch ? "released" : "claimed");
    }

    public final Thread setExclusiveContextThread(Thread thread, GLContext gLContext) throws GLException {
        if (DEBUG) {
            System.err.println("GLDrawableHelper.setExclusiveContextThread(): START switch " + this.getExclusiveContextSwitchString() + ", thread " + this.exclusiveContextThread + " -> " + thread + " -- currentThread " + Thread.currentThread());
        }
        Thread thread2 = this.exclusiveContextThread;
        if (this.exclusiveContextThread == thread) {
            this.exclusiveContextSwitch = 0;
        } else if (null == thread) {
            this.exclusiveContextSwitch = -1;
        } else {
            this.exclusiveContextSwitch = 1;
            if (null != this.exclusiveContextThread) {
                throw new GLException("Release current exclusive Context Thread " + this.exclusiveContextThread + " first");
            }
            if (null != gLContext && gLContext.isCurrent()) {
                try {
                    GLDrawableHelper.forceNativeRelease(gLContext);
                }
                catch (Throwable throwable) {
                    this.flushGLRunnables();
                    throw GLException.newGLException(throwable);
                }
            }
            this.exclusiveContextThread = thread;
        }
        if (DEBUG) {
            System.err.println("GLDrawableHelper.setExclusiveContextThread(): END switch " + this.getExclusiveContextSwitchString() + ", thread " + this.exclusiveContextThread + " -- currentThread " + Thread.currentThread());
        }
        return thread2;
    }

    public final Thread getExclusiveContextThread() {
        return this.exclusiveContextThread;
    }

    private static final Runnable getLastInitAction() {
        WeakReference<Runnable> weakReference = perThreadInitAction.get();
        if (null != weakReference) {
            Runnable runnable = (Runnable)weakReference.get();
            if (null == runnable) {
                perThreadInitAction.set(null);
            }
            return runnable;
        }
        return null;
    }

    private static final void setLastInitAction(Runnable runnable) {
        perThreadInitAction.set(new WeakReference<Runnable>(runnable));
    }

    public final void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        if (null == gLContext) {
            if (DEBUG) {
                ExceptionUtils.dumpThrowable("informal", new GLException("Info: GLDrawableHelper " + this + ".invokeGL(): NULL GLContext"));
            }
            return;
        }
        if (PERF_STATS) {
            this.invokeGLImplStats(gLDrawable, gLContext, runnable, runnable2);
        } else {
            this.invokeGLImpl(gLDrawable, gLContext, runnable, runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeGL(GLAutoDrawable gLAutoDrawable, GLContext gLContext, boolean bl) throws GLException {
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable = null;
        if (gLContext2 != null) {
            if (gLContext2 == gLContext) {
                gLContext2 = null;
            } else {
                runnable = GLDrawableHelper.getLastInitAction();
                gLContext2.release();
            }
        }
        GLException gLException = null;
        Throwable throwable = null;
        try {
            int n2 = gLContext.makeCurrent();
            if (0 != n2) {
                if (2 == n2) {
                    throw new GLException(GLDrawableHelper.getThreadName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context was not created (new ctx): " + gLContext);
                }
                if (this.listeners.size() > 0 && null != gLAutoDrawable) {
                    try {
                        this.disposeAllGLEventListener(gLAutoDrawable, false);
                    }
                    catch (GLException gLException2) {
                        gLException = gLException2;
                    }
                }
            }
        }
        finally {
            try {
                if (bl) {
                    gLContext.destroy();
                } else {
                    GLDrawableHelper.forceNativeRelease(gLContext);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            this.flushGLRunnables();
            if (gLContext2 != null) {
                int n3 = gLContext2.makeCurrent();
                if (null != runnable && n3 == 2) {
                    runnable.run();
                }
            }
            if (null != gLException) {
                if (null != throwable) {
                    ExceptionUtils.dumpThrowable("subsequent", throwable);
                }
                throw gLException;
            }
            if (null != throwable) {
                throw GLException.newGLException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeGLImpl(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        Throwable throwable;
        Throwable throwable2;
        block33: {
            int n2;
            boolean bl;
            int n3;
            Thread thread = Thread.currentThread();
            throwable2 = null;
            throwable = null;
            if (null != this.exclusiveContextThread) {
                if (thread != this.exclusiveContextThread) return;
                n3 = 0 > this.exclusiveContextSwitch ? 1 : 0;
                bl = n3 == 0;
                this.exclusiveContextSwitch = 0;
            } else {
                n3 = 0;
                bl = false;
            }
            int n4 = 0;
            GLContext gLContext2 = GLContext.getCurrent();
            Runnable runnable3 = null;
            if (gLContext2 != null) {
                if (gLContext2 == gLContext) {
                    n4 = 1;
                    gLContext2 = null;
                } else {
                    runnable3 = GLDrawableHelper.getLastInitAction();
                    gLContext2.release();
                }
            }
            try {
                if (0 == n4) {
                    n4 = gLContext.makeCurrent();
                    n2 = !bl ? 1 : 0;
                } else {
                    n2 = n3;
                }
                if (0 != n4) {
                    try {
                        GLDrawableHelper.setLastInitAction(runnable2);
                        if (2 == n4) {
                            if (DEBUG) {
                                System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                            }
                            runnable2.run();
                        }
                        runnable.run();
                        if (this.autoSwapBufferMode) {
                            gLDrawable.swapBuffers();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                    }
                    finally {
                        if (n3 != 0) {
                            this.exclusiveContextThread = null;
                            if (DEBUG) {
                                System.err.println("GLDrawableHelper.invokeGL() - Release ExclusiveContextThread -- currentThread " + Thread.currentThread());
                            }
                        }
                        if (n2 != 0) {
                            try {
                                gLContext.release();
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                            }
                        }
                    }
                }
                if (gLContext2 == null) break block33;
            }
            catch (Throwable throwable5) {
                if (gLContext2 != null) {
                    int n5 = gLContext2.makeCurrent();
                    if (null != runnable3 && n5 == 2) {
                        runnable3.run();
                    }
                }
                if (null != throwable2) {
                    this.flushGLRunnables();
                    if (null == throwable) throw GLException.newGLException(throwable2);
                    ExceptionUtils.dumpThrowable("subsequent", throwable);
                    throw GLException.newGLException(throwable2);
                }
                if (null == throwable) throw throwable5;
                this.flushGLRunnables();
                throw GLException.newGLException(throwable);
            }
            n2 = gLContext2.makeCurrent();
            if (null != runnable3 && n2 == 2) {
                runnable3.run();
            }
        }
        if (null != throwable2) {
            this.flushGLRunnables();
            if (null == throwable) throw GLException.newGLException(throwable2);
            ExceptionUtils.dumpThrowable("subsequent", throwable);
            throw GLException.newGLException(throwable2);
        }
        if (null == throwable) return;
        this.flushGLRunnables();
        throw GLException.newGLException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeGLImplStats(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        int n2;
        boolean bl;
        boolean bl2;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        Runnable runnable3;
        GLContext gLContext2;
        Throwable throwable;
        Throwable throwable2;
        block33: {
            boolean bl3;
            int n3;
            Thread thread = Thread.currentThread();
            throwable2 = null;
            throwable = null;
            if (null != this.exclusiveContextThread) {
                if (thread != this.exclusiveContextThread) return;
                n3 = 0 > this.exclusiveContextSwitch ? 1 : 0;
                bl3 = n3 == 0;
            } else {
                n3 = 0;
                bl3 = false;
            }
            int n4 = 0;
            gLContext2 = GLContext.getCurrent();
            runnable3 = null;
            if (gLContext2 != null) {
                if (gLContext2 == gLContext) {
                    n4 = 1;
                    gLContext2 = null;
                } else {
                    runnable3 = GLDrawableHelper.getLastInitAction();
                    gLContext2.release();
                }
            }
            l6 = System.currentTimeMillis();
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
            bl2 = false;
            bl = false;
            try {
                if (0 == n4) {
                    n4 = gLContext.makeCurrent();
                    n2 = !bl3 ? 1 : 0;
                    bl2 = true;
                } else {
                    n2 = n3;
                }
                if (0 == n4) break block33;
                try {
                    GLDrawableHelper.setLastInitAction(runnable2);
                    if (2 == n4) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                    l4 = System.currentTimeMillis();
                    l5 = l4 - l6;
                    runnable.run();
                    l3 = System.currentTimeMillis();
                    l4 = l3 - l4;
                    if (this.autoSwapBufferMode) {
                        gLDrawable.swapBuffers();
                        l2 = System.currentTimeMillis();
                        l3 = l2 - l3;
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                }
                finally {
                    if (n3 != 0) {
                        this.exclusiveContextSwitch = 0;
                        this.exclusiveContextThread = null;
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper.invokeGL() - Release ExclusiveContextThread -- currentThread " + Thread.currentThread());
                        }
                    }
                    if (n2 != 0) {
                        try {
                            gLContext.release();
                            bl = true;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                l2 = System.currentTimeMillis() - l2;
                if (gLContext2 != null) {
                    int n5 = gLContext2.makeCurrent();
                    if (null != runnable3 && n5 == 2) {
                        runnable3.run();
                    }
                }
                if (null != throwable2) {
                    this.flushGLRunnables();
                    if (null == throwable) throw GLException.newGLException(throwable2);
                    ExceptionUtils.dumpThrowable("subsequent", throwable);
                    throw GLException.newGLException(throwable2);
                }
                if (null == throwable) throw throwable5;
                this.flushGLRunnables();
                throw GLException.newGLException(throwable);
            }
        }
        l2 = System.currentTimeMillis() - l2;
        if (gLContext2 != null) {
            n2 = gLContext2.makeCurrent();
            if (null != runnable3 && n2 == 2) {
                runnable3.run();
            }
        }
        if (null != throwable2) {
            this.flushGLRunnables();
            if (null == throwable) throw GLException.newGLException(throwable2);
            ExceptionUtils.dumpThrowable("subsequent", throwable);
            throw GLException.newGLException(throwable2);
        }
        if (null != throwable) {
            this.flushGLRunnables();
            throw GLException.newGLException(throwable);
        }
        long l7 = System.currentTimeMillis() - l6;
        System.err.println("td0 " + l7 + "ms, fps " + 1.0 / ((double)l7 / 1000.0) + ", td-makeCurrent: " + l5 + "ms, td-render " + l4 + "ms, td-swap " + l3 + "ms, td-release " + l2 + "ms, ctx claimed: " + bl2 + ", ctx release: " + bl + ", ctx destroyed " + false);
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        Debug.initSingleton();
        PERF_STATS = PropertyAccess.isPropertyDefined("jogl.debug.GLDrawable.PerfStats", true);
        DEBUG = GLDrawableImpl.DEBUG;
        nop = new Runnable(){

            @Override
            public void run() {
            }
        };
        perThreadInitAction = new ThreadLocal();
    }

    public static interface GLEventListenerAction {
        public void run(GLAutoDrawable var1, GLEventListener var2);
    }
}

