/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    static VisualIDHolder.VIDComparator EglCfgIDComparator = new VisualIDHolder.VIDComparator(VisualIDHolder.VIDType.EGL_CONFIG);
    static GraphicsConfigurationFactory nativeGraphicsConfigurationFactory = null;
    static GraphicsConfigurationFactory kdeglGraphicsConfigurationFactory = null;
    static GraphicsConfigurationFactory fallbackGraphicsConfigurationFactory = null;

    static void registerFactory() {
        EGLGraphicsConfigurationFactory eGLGraphicsConfigurationFactory = new EGLGraphicsConfigurationFactory();
        String string = NativeWindowFactory.getNativeWindowType(false);
        if (NativeWindowFactory.TYPE_X11 == string) {
            nativeGraphicsConfigurationFactory = GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, GLCapabilitiesImmutable.class, eGLGraphicsConfigurationFactory);
            fallbackGraphicsConfigurationFactory = null != nativeGraphicsConfigurationFactory ? nativeGraphicsConfigurationFactory : GraphicsConfigurationFactory.getFactory(X11GraphicsDevice.class, CapabilitiesImmutable.class);
        }
        kdeglGraphicsConfigurationFactory = GraphicsConfigurationFactory.registerFactory(EGLGraphicsDevice.class, GLCapabilitiesImmutable.class, eGLGraphicsConfigurationFactory);
    }

    static void unregisterFactory() {
        String string = NativeWindowFactory.getNativeWindowType(false);
        if (NativeWindowFactory.TYPE_X11 == string) {
            GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, GLCapabilitiesImmutable.class, nativeGraphicsConfigurationFactory);
        }
        nativeGraphicsConfigurationFactory = null;
        fallbackGraphicsConfigurationFactory = null;
        GraphicsConfigurationFactory.registerFactory(EGLGraphicsDevice.class, GLCapabilitiesImmutable.class, kdeglGraphicsConfigurationFactory);
        kdeglGraphicsConfigurationFactory = null;
    }

    private EGLGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n2) {
        if (abstractGraphicsScreen == null) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only AbstractGraphicsDevice objects");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)capabilitiesImmutable;
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice) {
            throw new GLException("Null AbstractGraphicsDevice");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = null;
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
            abstractGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen, n2, false);
        } else {
            if (null == fallbackGraphicsConfigurationFactory) {
                throw new InternalError("Native fallback GraphicsConfigurationFactory is null, but call issued for device: " + abstractGraphicsDevice + " of type " + abstractGraphicsDevice.getClass().getSimpleName());
            }
            if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES()) {
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfigurationFactory.choose..: Handle native device " + abstractGraphicsDevice.getClass().getSimpleName());
                }
                if (null == (abstractGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen, n2, false)) || 0 == abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE)) {
                    abstractGraphicsConfiguration = null;
                    if (DEBUG) {
                        System.err.println("EGLGraphicsConfigurationFactory.choose..: No native visual ID, fallback ..");
                    }
                }
            }
            if (null == abstractGraphicsConfiguration) {
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfigurationFactory.choose..: Delegate to " + fallbackGraphicsConfigurationFactory.getClass().getSimpleName());
                }
                abstractGraphicsConfiguration = fallbackGraphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, n2);
            }
        }
        return abstractGraphicsConfiguration;
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(EGLDrawableFactory eGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        EGLDrawableFactory.SharedResource sharedResource = eGLDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        EGLGraphicsDevice eGLGraphicsDevice = sharedResource.getDevice();
        long l2 = eGLGraphicsDevice.getHandle();
        if (0L == l2) {
            throw new GLException("null eglDisplay");
        }
        List<GLCapabilitiesImmutable> list = null;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        if (!EGL.eglGetConfigs(l2, null, 0, intBuffer)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (0 == intBuffer.get(0)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) no configs");
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        if (!EGL.eglGetConfigs(l2, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
            throw new GLException("Graphics configuration get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (intBuffer.get(0) > 0 && null != (list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, null, pointerBuffer, intBuffer.get(0), 15, false, false)) && list.size() > 1) {
            Collections.sort(list, EglCfgIDComparator);
        }
        return list;
    }

    public static EGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n2, boolean bl) {
        GLCapabilities gLCapabilities;
        boolean bl2;
        EGLGraphicsDevice eGLGraphicsDevice;
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        if (null == abstractGraphicsScreen) {
            throw new GLException("Null AbstractGraphicsScreen");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice) {
            throw new GLException("Null AbstractGraphicsDevice");
        }
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            if (eGLGraphicsDevice.getHandle() == 0L) {
                throw new GLException("Invalid EGL display: " + eGLGraphicsDevice);
            }
            bl2 = false;
        } else {
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(abstractGraphicsDevice.getHandle(), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
            eGLGraphicsDevice.open();
            bl2 = true;
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, GLDrawableFactory.getEGLFactory(), abstractGraphicsDevice);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n2, bl);
        if (null == eGLGraphicsConfiguration) {
            if (DEBUG) {
                System.err.println("eglChooseConfig failed with given capabilities " + gLCapabilitiesImmutable);
            }
            gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setRedBits(8);
            gLCapabilities.setGreenBits(8);
            gLCapabilities.setBlueBits(8);
            gLCapabilities.setDepthBits(16);
            if (!gLCapabilitiesImmutable.isOnscreen()) {
                gLCapabilities.setOnscreen(false);
                gLCapabilities.setPBuffer(gLCapabilitiesImmutable.isPBuffer());
                gLCapabilities.setFBO(gLCapabilitiesImmutable.isFBO());
            }
            if (DEBUG) {
                System.err.println("trying fixed caps (1): " + gLCapabilities);
            }
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n2, false);
        }
        if (null == eGLGraphicsConfiguration) {
            gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            if (!gLCapabilitiesImmutable.isOnscreen()) {
                gLCapabilities.setOnscreen(false);
                gLCapabilities.setPBuffer(gLCapabilitiesImmutable.isPBuffer());
                gLCapabilities.setFBO(gLCapabilitiesImmutable.isFBO());
            }
            if (DEBUG) {
                System.err.println("trying fixed caps (2): " + gLCapabilities);
            }
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n2, false);
        }
        if (null == eGLGraphicsConfiguration) {
            gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            if (!gLCapabilitiesImmutable.isOnscreen()) {
                gLCapabilities.setOnscreen(false);
                gLCapabilities.setPBuffer(gLCapabilitiesImmutable.isPBuffer());
                gLCapabilities.setFBO(gLCapabilitiesImmutable.isFBO());
            }
            if (DEBUG) {
                System.err.println("trying fixed caps (3): " + gLCapabilities);
            }
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(eGLGraphicsDevice, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n2, false);
        }
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Graphics configuration failed [direct caps, eglGetConfig/chooser and fixed-caps(1-3)]");
        }
        if (bl2) {
            ((EGLGLCapabilities)eGLGraphicsConfiguration.getChosenCapabilities()).setEGLConfig(0L);
            eGLGraphicsDevice.close();
        }
        return eGLGraphicsConfiguration;
    }

    static EGLGraphicsConfiguration eglChooseConfig(EGLGraphicsDevice eGLGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n2, boolean bl) {
        int n3;
        VisualIDHolder visualIDHolder;
        boolean bl2;
        boolean bl3;
        long l2 = eGLGraphicsDevice.getHandle();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int n4 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
        List<GLCapabilitiesImmutable> list = null;
        int n5 = -1;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        if (!EGL.eglGetConfigs(l2, null, 0, intBuffer)) {
            throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: Get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (0 == intBuffer.get(0)) {
            throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: Get maxConfigs (eglGetConfigs) no configs");
        }
        int n6 = intBuffer.get(0);
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: eglChooseConfig eglDisplay " + EGLGraphicsConfigurationFactory.toHexString(l2) + ", nativeVisualID " + EGLGraphicsConfigurationFactory.toHexString(n2) + ", capsChosen " + gLCapabilitiesImmutable + ", winbits " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n4).toString() + ", fboAvail " + GLContext.isFBOAvailable(eGLGraphicsDevice, gLProfile) + ", device " + eGLGraphicsDevice + ", " + eGLGraphicsDevice.getUniqueID() + ", numEGLConfigs " + n6);
        }
        IntBuffer intBuffer2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        if (0 == n2) {
            if (!EGL.eglChooseConfig(l2, intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: false");
                }
                intBuffer.put(0, 0);
                bl3 = false;
            } else {
                bl3 = intBuffer.get(0) > 0;
            }
        } else {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: Skipped due to given visualID: " + EGLGraphicsConfigurationFactory.toHexString(n2));
            }
            bl3 = false;
        }
        boolean bl4 = bl3 && !bl && gLCapabilitiesImmutable.isBackgroundOpaque();
        boolean bl5 = bl2 = null == gLCapabilitiesChooser && bl4;
        if (bl3) {
            list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLProfile, pointerBuffer, intBuffer.get(0), n4, bl, bl2);
            if (list.size() > 0) {
                long l3 = pointerBuffer.get(0);
                n5 = 0;
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString(l3) + ", idx " + n5);
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 useRecommendedIndex " + bl4 + ", skipCapsChooser " + bl2);
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 fbcfg caps " + list.get(n5));
                }
            } else if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: no caps for recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString(pointerBuffer.get(0)));
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 useRecommendedIndex " + bl4 + ", skipCapsChooser " + bl2);
            }
        } else if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: no configs");
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 useRecommendedIndex " + bl4 + ", skipCapsChooser " + bl2);
        }
        if (null == list || 0 == list.size()) {
            n5 = -1;
            if (!EGL.eglGetConfigs(l2, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
                throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: #2 Get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
            }
            if (intBuffer.get(0) > 0) {
                list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLProfile, pointerBuffer, intBuffer.get(0), n4, bl, false);
            }
        }
        if (null == list || 0 == list.size()) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #2 Graphics configuration 1st choice and 2nd choice failed - no configs");
                list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLProfile, pointerBuffer, intBuffer.get(0), 15, bl, false);
                EGLGraphicsConfigurationFactory.printCaps("AllCaps", list, System.err);
            }
            return null;
        }
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: got configs: " + list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                System.err.println(i2 + ": " + list.get(i2));
            }
        }
        if (0 != n2) {
            ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
            int n7 = 0;
            while (n7 < list.size()) {
                visualIDHolder = list.get(n7);
                if (visualIDHolder.getVisualID(VisualIDHolder.VIDType.NATIVE) != n2) {
                    if (DEBUG) {
                        System.err.println("Remove[" + n7 + "] (mismatch VisualID): " + visualIDHolder);
                    }
                    arrayList.add(list.remove(n7));
                    continue;
                }
                if (0 == visualIDHolder.getDepthBits() && 0 < gLCapabilitiesImmutable.getDepthBits()) {
                    if (DEBUG) {
                        System.err.println("Remove[" + n7 + "] (mismatch depth-bits): " + visualIDHolder);
                    }
                    arrayList.add(list.remove(n7));
                    continue;
                }
                ++n7;
            }
            if (0 == list.size()) {
                list = arrayList;
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: post filter nativeVisualID " + EGLGraphicsConfigurationFactory.toHexString(n2) + " no config found, revert to all");
                }
            } else if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: post filter nativeVisualID " + EGLGraphicsConfigurationFactory.toHexString(n2) + " got configs: " + list.size());
                for (n7 = 0; n7 < list.size(); ++n7) {
                    System.err.println(n7 + ": " + list.get(n7));
                }
            }
        }
        if (0 > (n3 = bl2 && 0 <= n5 ? n5 : EGLGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, list, n5))) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #2 chooseCapabilities failed");
            }
            return null;
        }
        EGLGLCapabilities eGLGLCapabilities = (EGLGLCapabilities)list.get(n3);
        visualIDHolder = new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: X chosen :" + n3 + ", eglConfig: " + EGLGraphicsConfigurationFactory.toHexString(eGLGLCapabilities.getEGLConfig()) + ": " + visualIDHolder);
        }
        return visualIDHolder;
    }

    static List<GLCapabilitiesImmutable> eglConfigs2GLCaps(EGLGraphicsDevice eGLGraphicsDevice, GLProfile gLProfile, PointerBuffer pointerBuffer, int n2, int n3, boolean bl, boolean bl2) {
        GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(GLDrawableFactory.getEGLFactory().getDefaultDevice());
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            EGLGLCapabilities eGLGLCapabilities = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLRendererQuirks, eGLGraphicsDevice, gLProfile, pointerBuffer.get(i2), n3, bl);
            if (null == eGLGLCapabilities) continue;
            arrayList.add(eGLGLCapabilities);
            if (bl2) break;
        }
        return arrayList;
    }

    static void printCaps(String string, List<GLCapabilitiesImmutable> list, PrintStream printStream) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            printStream.println(string + "[" + i2 + "] " + list.get(i2));
        }
    }
}

