/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.mipmap;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.glu.mipmap.Extract1010102;
import jogamp.opengl.glu.mipmap.Extract1555rev;
import jogamp.opengl.glu.mipmap.Extract2101010rev;
import jogamp.opengl.glu.mipmap.Extract233rev;
import jogamp.opengl.glu.mipmap.Extract332;
import jogamp.opengl.glu.mipmap.Extract4444;
import jogamp.opengl.glu.mipmap.Extract4444rev;
import jogamp.opengl.glu.mipmap.Extract5551;
import jogamp.opengl.glu.mipmap.Extract565;
import jogamp.opengl.glu.mipmap.Extract565rev;
import jogamp.opengl.glu.mipmap.Extract8888;
import jogamp.opengl.glu.mipmap.Extract8888rev;
import jogamp.opengl.glu.mipmap.ExtractFloat;
import jogamp.opengl.glu.mipmap.ExtractSByte;
import jogamp.opengl.glu.mipmap.ExtractSInt;
import jogamp.opengl.glu.mipmap.ExtractSShort;
import jogamp.opengl.glu.mipmap.ExtractUByte;
import jogamp.opengl.glu.mipmap.ExtractUInt;
import jogamp.opengl.glu.mipmap.ExtractUShort;
import jogamp.opengl.glu.mipmap.HalveImage;
import jogamp.opengl.glu.mipmap.Image;
import jogamp.opengl.glu.mipmap.Mipmap;
import jogamp.opengl.glu.mipmap.PixelStorageModes;
import jogamp.opengl.glu.mipmap.ScaleInternal;

public class BuildMipmap {
    private static final boolean DEBUG = Debug.debug("BuildMipmap");
    private static final boolean VERBOSE = Debug.verbose();
    private static final int TARGA_HEADER_SIZE = 18;

    public static int gluBuild1DMipmapLevelsCore(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer) {
        ShortBuffer shortBuffer = null;
        ShortBuffer shortBuffer2 = null;
        ShortBuffer shortBuffer3 = null;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        assert (Mipmap.checkMipmapArgs(n3, n6, n7) == 0);
        assert (n4 >= 1);
        int n11 = n5;
        int n12 = Mipmap.computeLog(n11);
        n12 += n8;
        Mipmap.retrieveStoreModes(gL, pixelStorageModes);
        try {
            shortBuffer = Buffers.newDirectByteBuffer(Mipmap.image_size(n4, 1, n6, 5123)).asShortBuffer();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return 100902;
        }
        int n13 = n4;
        Image.fill_image(pixelStorageModes, n4, 1, n6, n7, Mipmap.is_index(n6), byteBuffer, shortBuffer);
        int n14 = Mipmap.elements_per_group(n6, n7);
        gL.glPixelStorei(3317, 2);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3312, 0);
        for (int i2 = n8; i2 <= n12; ++i2) {
            if (n13 == n11) {
                if (n9 <= i2 && i2 <= n10) {
                    gL.getGL2().glTexImage1D(n2, i2, n3, n13, 0, n6, 5123, shortBuffer);
                }
            } else {
                if (shortBuffer2 == null) {
                    int n15 = Mipmap.image_size(n11, 1, n6, 5123);
                    try {
                        shortBuffer2 = Buffers.newDirectByteBuffer(n15).asShortBuffer();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                        return 100902;
                    }
                }
                ScaleInternal.scale_internal(n14, n13, 1, shortBuffer, n11, 1, shortBuffer2);
                shortBuffer3 = shortBuffer2;
                shortBuffer2 = shortBuffer;
                shortBuffer = shortBuffer3;
                n13 = n11;
                if (n9 <= i2 && i2 <= n10) {
                    gL.getGL2().glTexImage1D(n2, i2, n3, n13, 0, n6, 5123, shortBuffer);
                }
            }
            if (n11 <= 1) continue;
            n11 /= 2;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int bitmapBuild2DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ShortBuffer shortBuffer = null;
        ShortBuffer shortBuffer2 = null;
        ShortBuffer shortBuffer3 = null;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        Mipmap.retrieveStoreModes(gL, pixelStorageModes);
        Mipmap.closestFit(gL, n2, n4, n5, n3, n6, n7, nArray, nArray2);
        int n8 = Mipmap.computeLog(nArray[0]);
        int n9 = Mipmap.computeLog(nArray2[0]);
        if (n9 > n8) {
            n8 = n9;
        }
        try {
            shortBuffer = Buffers.newDirectByteBuffer(Mipmap.image_size(n4, n5, n6, 5123)).asShortBuffer();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return 100902;
        }
        int n10 = n4;
        int n11 = n5;
        Image.fill_image(pixelStorageModes, n4, n5, n6, n7, Mipmap.is_index(n6), byteBuffer, shortBuffer);
        int n12 = Mipmap.elements_per_group(n6, n7);
        gL.glPixelStorei(3317, 2);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3312, 0);
        for (n9 = 0; n9 < n8; ++n9) {
            if (n10 == nArray[0] && n11 == nArray2[0]) {
                shortBuffer.rewind();
                gL.glTexImage2D(n2, n9, n3, n10, n11, 0, n6, 5123, shortBuffer);
            } else {
                if (shortBuffer2 == null) {
                    int n13 = Mipmap.image_size(nArray[0], nArray2[0], n6, 5123);
                    try {
                        shortBuffer2 = Buffers.newDirectByteBuffer(n13).asShortBuffer();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                        return 100902;
                    }
                }
                ScaleInternal.scale_internal(n12, n10, n11, shortBuffer, nArray[0], nArray2[0], shortBuffer2);
                shortBuffer3 = shortBuffer2;
                shortBuffer2 = shortBuffer;
                shortBuffer = shortBuffer3;
                n10 = nArray[0];
                n11 = nArray2[0];
                shortBuffer.rewind();
                gL.glTexImage2D(n2, n9, n3, n10, n11, 0, n6, 5123, shortBuffer);
            }
            if (nArray2[0] > 1) {
                nArray[0] = nArray[0] / 2;
            }
            if (nArray2[0] <= 1) continue;
            nArray2[0] = nArray2[0] / 2;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int gluBuild2DMipmapLevelsCore(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, ByteBuffer byteBuffer) {
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        ByteBuffer byteBuffer2 = null;
        ByteBuffer byteBuffer3 = null;
        ByteBuffer byteBuffer4 = null;
        Object var23_16 = null;
        int n18 = -1;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        assert (Mipmap.checkMipmapArgs(n3, n8, n9) == 0);
        assert (n4 >= 1 && n5 >= 1);
        if (n9 == 6656) {
            return BuildMipmap.bitmapBuild2DMipmaps(gL, n2, n3, n4, n5, n8, n9, byteBuffer);
        }
        int n19 = n6;
        int n20 = n7;
        int n21 = Mipmap.computeLog(n19);
        int n22 = Mipmap.computeLog(n20);
        if (n22 > n21) {
            n21 = n22;
        }
        n21 += n10;
        Mipmap.retrieveStoreModes(gL, pixelStorageModes);
        boolean bl = pixelStorageModes.getUnpackSwapBytes();
        int n23 = Mipmap.elements_per_group(n8, n9);
        int n24 = pixelStorageModes.getUnpackRowLength() > 0 ? pixelStorageModes.getUnpackRowLength() : n4;
        int n25 = Mipmap.bytes_per_element(n9);
        int n26 = n25 * n23;
        if (n25 == 1) {
            bl = false;
        }
        if ((n17 = (n16 = n24 * n26) % pixelStorageModes.getUnpackAlignment()) != 0) {
            n16 += pixelStorageModes.getUnpackAlignment() - n17;
        }
        n18 = pixelStorageModes.getUnpackSkipRows() * n16 + pixelStorageModes.getUnpackSkipPixels() * n26;
        byteBuffer.position(n18);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        n22 = n10;
        if (n4 == n19 && n5 == n20) {
            if (n11 <= n22 && n22 <= n12) {
                byteBuffer.rewind();
                gL.glTexImage2D(n2, n22, n3, n4, n5, 0, n8, n9, byteBuffer);
            }
            if (n21 == 0) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 0;
            }
            n15 = n19 / 2;
            n14 = n20 / 2;
            if (n15 < 1) {
                n15 = 1;
            }
            if (n14 < 1) {
                n14 = 1;
            }
            n13 = Mipmap.image_size(n15, n14, n8, n9);
            try {
                switch (n9) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n13);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 100902;
            }
            if (byteBuffer3 != null) {
                switch (n9) {
                    case 5121: {
                        HalveImage.halveImage_ubyte(n23, n4, n5, byteBuffer, byteBuffer3, n25, n16, n26);
                        break;
                    }
                    case 5120: {
                        HalveImage.halveImage_byte(n23, n4, n5, byteBuffer, byteBuffer3, n25, n16, n26);
                        break;
                    }
                    case 5123: {
                        HalveImage.halveImage_ushort(n23, n4, n5, byteBuffer, byteBuffer3.asShortBuffer(), n25, n16, n26, bl);
                        break;
                    }
                    case 5122: {
                        HalveImage.halveImage_short(n23, n4, n5, byteBuffer, byteBuffer3.asShortBuffer(), n25, n16, n26, bl);
                        break;
                    }
                    case 5125: {
                        HalveImage.halveImage_uint(n23, n4, n5, byteBuffer, byteBuffer3.asIntBuffer(), n25, n16, n26, bl);
                        break;
                    }
                    case 5124: {
                        HalveImage.halveImage_int(n23, n4, n5, byteBuffer, byteBuffer3.asIntBuffer(), n25, n16, n26, bl);
                        break;
                    }
                    case 5126: {
                        HalveImage.halveImage_float(n23, n4, n5, byteBuffer, byteBuffer3.asFloatBuffer(), n25, n16, n26, bl);
                        break;
                    }
                    case 32818: {
                        assert (n8 == 6407);
                        HalveImage.halveImagePackedPixel(3, new Extract332(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33634: {
                        assert (n8 == 6407);
                        HalveImage.halveImagePackedPixel(3, new Extract233rev(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33635: {
                        HalveImage.halveImagePackedPixel(3, new Extract565(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33636: {
                        HalveImage.halveImagePackedPixel(3, new Extract565rev(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 32819: {
                        HalveImage.halveImagePackedPixel(4, new Extract4444(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33637: {
                        HalveImage.halveImagePackedPixel(4, new Extract4444rev(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 32820: {
                        HalveImage.halveImagePackedPixel(4, new Extract5551(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33638: {
                        HalveImage.halveImagePackedPixel(4, new Extract1555rev(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 32821: {
                        HalveImage.halveImagePackedPixel(4, new Extract8888(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33639: {
                        HalveImage.halveImagePackedPixel(4, new Extract8888rev(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 36342: {
                        HalveImage.halveImagePackedPixel(4, new Extract1010102(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    case 33640: {
                        HalveImage.halveImagePackedPixel(4, new Extract2101010rev(), n4, n5, byteBuffer, byteBuffer3, n25, n16, bl);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            n19 = n4 / 2;
            n20 = n5 / 2;
            if (n19 < 1) {
                n19 = 1;
            }
            if (n20 < 1) {
                n20 = 1;
            }
            bl = false;
            n16 = n19 * n26;
            n13 = Mipmap.image_size(n19, n20, n8, n9);
            byteBuffer4 = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            byteBuffer3 = byteBuffer4;
            try {
                switch (n9) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n13);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 100902;
            }
            n22 = n10 + 1;
        } else {
            n13 = Mipmap.image_size(n19, n20, n8, n9);
            try {
                switch (n9) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n13);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 100902;
            }
            byteBuffer.position(n18);
            switch (n9) {
                case 5121: {
                    ScaleInternal.scale_internal_ubyte(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, n26);
                    break;
                }
                case 5120: {
                    ScaleInternal.scale_internal_byte(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, n26);
                    break;
                }
                case 5123: {
                    ScaleInternal.scale_internal_ushort(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3.asShortBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5122: {
                    ScaleInternal.scale_internal_ushort(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3.asShortBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5125: {
                    ScaleInternal.scale_internal_uint(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3.asIntBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5124: {
                    ScaleInternal.scale_internal_int(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3.asIntBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5126: {
                    ScaleInternal.scale_internal_float(n23, n4, n5, byteBuffer, n19, n20, byteBuffer3.asFloatBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 32818: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract332(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33634: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract233rev(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33635: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract565(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33636: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract565rev(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 32819: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract4444(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33637: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract4444rev(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 32820: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract5551(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33638: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract1555rev(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 32821: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract8888(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33639: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract8888rev(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 36342: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract1010102(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33640: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract2101010rev(), n4, n5, byteBuffer, n19, n20, byteBuffer3, n25, n16, bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            bl = false;
            n16 = n19 * n26;
            byteBuffer4 = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            byteBuffer3 = byteBuffer4;
            if (n21 != 0) {
                n15 = n19 / 2;
                n14 = n20 / 2;
                if (n15 < 1) {
                    n15 = 1;
                }
                if (n14 < 1) {
                    n14 = 1;
                }
                n13 = Mipmap.image_size(n15, n14, n8, n9);
                try {
                    switch (n9) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 32818: 
                        case 32819: 
                        case 32820: 
                        case 32821: 
                        case 33634: 
                        case 33635: 
                        case 33636: 
                        case 33637: 
                        case 33638: 
                        case 33639: 
                        case 33640: 
                        case 36342: {
                            byteBuffer3 = Buffers.newDirectByteBuffer(n13);
                            break;
                        }
                        default: {
                            return 100900;
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                    gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                    gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                    gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                    gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                    return 100902;
                }
            }
            n22 = n10;
        }
        gL.glPixelStorei(3312, 0);
        if (n11 <= n22 && n22 <= n12) {
            byteBuffer2.rewind();
            gL.glTexImage2D(n2, n22, n3, n19, n20, 0, n8, n9, byteBuffer2);
            if (DEBUG) {
                System.err.println("GL Error(" + n22 + "): " + gL.glGetError());
                if (VERBOSE) {
                    byteBuffer2.limit(Mipmap.image_size(n19, n20, n8, n9));
                    BuildMipmap.writeTargaFile("glu2DMipmapJ" + n22 + ".tga", byteBuffer2, n19, n20);
                    byteBuffer2.clear();
                }
            }
        }
        ++n22;
        while (n22 <= n21) {
            byteBuffer2.rewind();
            byteBuffer3.rewind();
            switch (n9) {
                case 5121: {
                    HalveImage.halveImage_ubyte(n23, n19, n20, byteBuffer2, byteBuffer3, n25, n16, n26);
                    break;
                }
                case 5120: {
                    HalveImage.halveImage_byte(n23, n19, n20, byteBuffer2, byteBuffer3, n25, n16, n26);
                    break;
                }
                case 5123: {
                    HalveImage.halveImage_ushort(n23, n19, n20, byteBuffer2, byteBuffer3.asShortBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5122: {
                    HalveImage.halveImage_short(n23, n19, n20, byteBuffer2, byteBuffer3.asShortBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5125: {
                    HalveImage.halveImage_uint(n23, n19, n20, byteBuffer2, byteBuffer3.asIntBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5124: {
                    HalveImage.halveImage_int(n23, n19, n20, byteBuffer2, byteBuffer3.asIntBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 5126: {
                    HalveImage.halveImage_float(n23, n19, n20, byteBuffer2, byteBuffer3.asFloatBuffer(), n25, n16, n26, bl);
                    break;
                }
                case 32818: {
                    assert (n8 == 6407);
                    HalveImage.halveImagePackedPixel(3, new Extract332(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33634: {
                    assert (n8 == 6407);
                    HalveImage.halveImagePackedPixel(3, new Extract233rev(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33635: {
                    HalveImage.halveImagePackedPixel(3, new Extract565(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33636: {
                    HalveImage.halveImagePackedPixel(3, new Extract565rev(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 32819: {
                    HalveImage.halveImagePackedPixel(4, new Extract4444(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33637: {
                    HalveImage.halveImagePackedPixel(4, new Extract4444rev(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 32820: {
                    HalveImage.halveImagePackedPixel(4, new Extract5551(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33638: {
                    HalveImage.halveImagePackedPixel(4, new Extract1555rev(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 32821: {
                    HalveImage.halveImagePackedPixel(4, new Extract8888(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33639: {
                    HalveImage.halveImagePackedPixel(4, new Extract8888rev(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 36342: {
                    HalveImage.halveImagePackedPixel(4, new Extract1010102(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                case 33640: {
                    HalveImage.halveImagePackedPixel(4, new Extract2101010rev(), n19, n20, byteBuffer2, byteBuffer3, n25, n16, bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            byteBuffer4 = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            byteBuffer3 = byteBuffer4;
            if (n19 > 1) {
                n19 /= 2;
                n16 /= 2;
            }
            if (n20 > 1) {
                n20 /= 2;
            }
            if ((n15 = n16 % pixelStorageModes.getUnpackAlignment()) == 0) {
                if (n11 <= n22 && n22 <= n12) {
                    byteBuffer2.rewind();
                    gL.glTexImage2D(n2, n22, n3, n19, n20, 0, n8, n9, byteBuffer2);
                    if (DEBUG) {
                        System.err.println("GL Error(" + n22 + "): " + gL.glGetError());
                        if (VERBOSE) {
                            byteBuffer2.limit(Mipmap.image_size(n19, n20, n8, n9));
                            BuildMipmap.writeTargaFile("glu2DMipmapJ" + n22 + ".tga", byteBuffer2, n19, n20);
                            byteBuffer2.clear();
                        }
                    }
                }
            } else {
                n14 = n16 + pixelStorageModes.getUnpackAlignment() - n15;
                ByteBuffer byteBuffer5 = null;
                try {
                    byteBuffer5 = ByteBuffer.allocateDirect(n14 * n20);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                    gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                    gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                    gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                    gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                    return 100902;
                }
                byteBuffer2.rewind();
                for (int i2 = 0; i2 < n20; ++i2) {
                    byteBuffer5.position(n14 * i2);
                    for (int i3 = 0; i3 < n16; ++i3) {
                        byteBuffer5.put(byteBuffer2.get());
                    }
                }
                if (n11 <= n22 && n22 <= n12) {
                    byteBuffer5.rewind();
                    gL.glTexImage2D(n2, n22, n3, n19, n20, 0, n8, n9, byteBuffer5);
                    if (DEBUG) {
                        System.err.println("GL Error(" + n22 + " padded): " + gL.glGetError());
                        if (VERBOSE) {
                            BuildMipmap.writeTargaFile("glu2DMipmapJ" + n22 + ".tga", byteBuffer5, n19, n20);
                        }
                    }
                }
            }
            ++n22;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int fastBuild2DMipmaps(GL gL, PixelStorageModes pixelStorageModes, int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        int n8;
        int n9;
        ByteBuffer byteBuffer2;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Mipmap.closestFit(gL, n2, n4, n5, n3, n6, n7, nArray, nArray2);
        int n10 = Mipmap.computeLog(nArray[0]);
        int n11 = Mipmap.computeLog(nArray2[0]);
        if (n11 > n10) {
            n10 = n11;
        }
        int n12 = Mipmap.elements_per_group(n6, n7);
        ByteBuffer byteBuffer3 = null;
        if (pixelStorageModes.getUnpackSkipRows() == 0 && pixelStorageModes.getUnpackSkipPixels() == 0) {
            byteBuffer2 = byteBuffer;
            n9 = n4;
            n8 = n5;
        } else {
            try {
                byteBuffer2 = Buffers.newDirectByteBuffer(Mipmap.image_size(n4, n5, n6, 5121));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return 100902;
            }
            n9 = n4;
            n8 = n5;
            int n13 = pixelStorageModes.getUnpackRowLength() > 0 ? pixelStorageModes.getUnpackRowLength() : n4;
            int n14 = n13 * n12;
            int n15 = n4 * n12;
            int n16 = pixelStorageModes.getUnpackSkipRows() * n14 + pixelStorageModes.getUnpackSkipPixels() * n12;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n17 = n16;
                byteBuffer.position(n17);
                for (int i3 = 0; i3 < n15; ++i3) {
                    byteBuffer2.put(byteBuffer.get());
                }
                n16 += n14;
            }
        }
        gL.glPixelStorei(3317, 1);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3312, 0);
        for (n11 = 0; n11 <= n10; ++n11) {
            if (n9 == nArray[0] && n8 == nArray2[0]) {
                byteBuffer2.rewind();
                gL.glTexImage2D(n2, n11, n3, n9, n8, 0, n6, 5121, byteBuffer2);
            } else {
                if (byteBuffer3 == null) {
                    int n18 = Mipmap.image_size(nArray[0], nArray2[0], n6, 5121);
                    try {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n18);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                        return 100902;
                    }
                }
                ByteBuffer byteBuffer4 = byteBuffer3;
                byteBuffer3 = byteBuffer2;
                byteBuffer2 = byteBuffer4;
                n9 = nArray[0];
                n8 = nArray2[0];
                byteBuffer2.rewind();
                gL.glTexImage2D(n2, n11, n3, n9, n8, 0, n6, 5121, byteBuffer2);
            }
            if (nArray[0] > 1) {
                nArray[0] = nArray[0] / 2;
            }
            if (nArray2[0] <= 1) continue;
            nArray2[0] = nArray2[0] / 2;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int gluBuild3DMipmapLevelsCore(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19 = -1;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        assert (Mipmap.checkMipmapArgs(n3, n10, n11) == 0);
        assert (n4 >= 1 && n5 >= 1 && n6 >= 1);
        assert (n11 != 6656);
        ByteBuffer byteBuffer3 = null;
        ByteBuffer byteBuffer4 = null;
        int n20 = n7;
        int n21 = n8;
        int n22 = n9;
        int n23 = Mipmap.computeLog(n20);
        int n24 = Mipmap.computeLog(n21);
        if (n24 > n23) {
            n23 = n24;
        }
        if ((n24 = Mipmap.computeLog(n22)) > n23) {
            n23 = n24;
        }
        n23 += n12;
        Mipmap.retrieveStoreModes3D(gL, pixelStorageModes);
        boolean bl = pixelStorageModes.getUnpackSwapBytes();
        int n25 = Mipmap.elements_per_group(n10, n11);
        int n26 = pixelStorageModes.getUnpackRowLength() > 0 ? pixelStorageModes.getUnpackRowLength() : n4;
        int n27 = Mipmap.bytes_per_element(n11);
        int n28 = n27 * n25;
        if (n27 == 1) {
            bl = false;
        }
        int n29 = pixelStorageModes.getUnpackImageHeight() > 0 ? pixelStorageModes.getUnpackImageHeight() : n5;
        int n30 = n26 * n28;
        int n31 = n30 % pixelStorageModes.getUnpackAlignment();
        if (n31 != 0) {
            n30 += pixelStorageModes.getUnpackAlignment() - n31;
        }
        int n32 = n29 * n30;
        ByteBuffer byteBuffer5 = ByteBuffer.wrap(byteBuffer.array());
        n19 = pixelStorageModes.getUnpackSkipRows() * n30 + pixelStorageModes.getUnpackSkipPixels() * n28 + pixelStorageModes.getUnpackSkipImages() * n32;
        byteBuffer5.position(n19);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(32877, 0);
        gL.glPixelStorei(32878, 0);
        n24 = n12;
        if (n4 == n20 && n5 == n21 && n6 == n22) {
            if (n13 <= n24 && n24 <= n14) {
                gL.getGL2().glTexImage3D(n2, n24, n3, n4, n5, n6, 0, n10, n11, byteBuffer5);
            }
            if (n23 == 0) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 0;
            }
            n18 = n20 / 2;
            n17 = n21 / 2;
            n16 = n22 / 2;
            if (n18 < 1) {
                n18 = 1;
            }
            if (n17 < 1) {
                n17 = 1;
            }
            if (n16 < 1) {
                n16 = 1;
            }
            n15 = Mipmap.imageSize3D(n18, n17, n16, n10, n11);
            try {
                switch (n11) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n15);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 100902;
            }
            if (byteBuffer3 != null) {
                switch (n11) {
                    case 5121: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractUByte(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_ubyte(n25, n4, n5, byteBuffer5, byteBuffer3, n27, n30, n28);
                        break;
                    }
                    case 5120: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractSByte(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_byte(n25, n4, n5, byteBuffer5, byteBuffer3, n27, n30, n28);
                        break;
                    }
                    case 5123: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractUShort(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_ushort(n25, n4, n5, byteBuffer5, byteBuffer3.asShortBuffer(), n27, n30, n28, bl);
                        break;
                    }
                    case 5122: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractSShort(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_short(n25, n4, n5, byteBuffer5, byteBuffer3.asShortBuffer(), n27, n30, n28, bl);
                        break;
                    }
                    case 5125: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractUInt(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_uint(n25, n4, n5, byteBuffer5, byteBuffer3.asIntBuffer(), n27, n30, n28, bl);
                        break;
                    }
                    case 5124: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractSInt(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_int(n25, n4, n5, byteBuffer5, byteBuffer3.asIntBuffer(), n27, n30, n28, bl);
                        break;
                    }
                    case 5126: {
                        if (n6 > 1) {
                            HalveImage.halveImage3D(n25, new ExtractFloat(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                            break;
                        }
                        HalveImage.halveImage_float(n25, n4, n5, byteBuffer5, byteBuffer3.asFloatBuffer(), n27, n30, n28, bl);
                        break;
                    }
                    case 32818: {
                        assert (n10 == 6407);
                        HalveImage.halveImagePackedPixel3D(3, new Extract332(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33634: {
                        assert (n10 == 6407);
                        HalveImage.halveImagePackedPixel3D(3, new Extract233rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33635: {
                        HalveImage.halveImagePackedPixel3D(3, new Extract565(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33636: {
                        HalveImage.halveImagePackedPixel3D(3, new Extract565rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 32819: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract4444(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33637: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract4444rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 32820: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract5551(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33638: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract1555rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 32821: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract8888(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33639: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract8888rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 36342: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract1010102(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    case 33640: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract2101010rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            n20 = n4 / 2;
            n21 = n5 / 2;
            n22 = n6 / 2;
            if (n20 < 1) {
                n20 = 1;
            }
            if (n21 < 1) {
                n21 = 1;
            }
            if (n22 < 1) {
                n22 = 1;
            }
            bl = false;
            n30 = n20 * n28;
            n32 = n30 * n21;
            n15 = Mipmap.imageSize3D(n20, n21, n22, n10, n11);
            byteBuffer2 = byteBuffer4;
            byteBuffer4 = byteBuffer3;
            byteBuffer3 = byteBuffer2;
            try {
                switch (n11) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n15);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 100902;
            }
            n24 = n12 + 1;
        } else {
            n15 = Mipmap.imageSize3D(n20, n21, n22, n10, n11);
            try {
                switch (n11) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer(n15);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 100902;
            }
            ScaleInternal.gluScaleImage3D(gL, n10, n4, n5, n6, n11, byteBuffer5, n20, n21, n22, n11, byteBuffer3);
            bl = false;
            n30 = n20 * n28;
            n32 = n30 * n21;
            byteBuffer2 = byteBuffer4;
            byteBuffer4 = byteBuffer3;
            byteBuffer3 = byteBuffer2;
            if (n23 != 0) {
                n18 = n20 / 2;
                n17 = n21 / 2;
                n16 = n22 / 2;
                if (n18 < 1) {
                    n18 = 1;
                }
                if (n17 < 1) {
                    n17 = 1;
                }
                if (n16 < 1) {
                    n16 = 1;
                }
                n15 = Mipmap.imageSize3D(n18, n17, n16, n10, n11);
                try {
                    switch (n11) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 32818: 
                        case 32819: 
                        case 32820: 
                        case 32821: 
                        case 33634: 
                        case 33635: 
                        case 33636: 
                        case 33637: 
                        case 33638: 
                        case 33639: 
                        case 33640: 
                        case 36342: {
                            byteBuffer3 = Buffers.newDirectByteBuffer(n15);
                            break;
                        }
                        default: {
                            return 100900;
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                    gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                    gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                    gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                    gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                    gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                    gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                    return 100902;
                }
            }
            n24 = n12;
        }
        gL.glPixelStorei(3312, 0);
        if (n13 <= n24 && n24 <= n14) {
            byteBuffer5.position(n19);
            gL.getGL2().glTexImage3D(n2, n24, n3, n4, n5, n6, 0, n10, n11, byteBuffer5);
        }
        ++n24;
        while (n24 <= n23) {
            switch (n11) {
                case 5121: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractUByte(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_ubyte(n25, n4, n5, byteBuffer5, byteBuffer3, n27, n30, n28);
                    break;
                }
                case 5120: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractSByte(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_byte(n25, n4, n5, byteBuffer5, byteBuffer3, n27, n30, n28);
                    break;
                }
                case 5123: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractUShort(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_ushort(n25, n4, n5, byteBuffer5, byteBuffer3.asShortBuffer(), n27, n30, n28, bl);
                    break;
                }
                case 5122: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractSShort(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_short(n25, n4, n5, byteBuffer5, byteBuffer3.asShortBuffer(), n27, n30, n28, bl);
                    break;
                }
                case 5125: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractUInt(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_uint(n25, n4, n5, byteBuffer5, byteBuffer3.asIntBuffer(), n27, n30, n28, bl);
                    break;
                }
                case 5124: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractSInt(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_int(n25, n4, n5, byteBuffer5, byteBuffer3.asIntBuffer(), n27, n30, n28, bl);
                    break;
                }
                case 5126: {
                    if (n6 > 1) {
                        HalveImage.halveImage3D(n25, new ExtractFloat(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n28, n30, n32, bl);
                        break;
                    }
                    HalveImage.halveImage_float(n25, n4, n5, byteBuffer5, byteBuffer3.asFloatBuffer(), n27, n30, n28, bl);
                    break;
                }
                case 32818: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract332(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33634: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract233rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33635: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract565(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33636: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract565rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 32819: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract4444(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33637: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract4444rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 32820: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract5551(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33638: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract1555rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 32821: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract8888(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33639: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract8888rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 36342: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract1010102(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                case 33640: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract2101010rev(), n4, n5, n6, byteBuffer5, byteBuffer3, n27, n30, n32, bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            byteBuffer2 = byteBuffer4;
            byteBuffer4 = byteBuffer3;
            byteBuffer3 = byteBuffer2;
            if (n20 > 1) {
                n20 /= 2;
                n30 /= 2;
            }
            if (n21 > 1) {
                n32 = n30 * (n21 /= 2);
            }
            if (n22 > 1) {
                n22 /= 2;
            }
            if (n13 <= n24 && n24 <= n14) {
                byteBuffer5.position(n19);
                gL.getGL2().glTexImage3D(n2, n24, n3, n4, n5, n6, 0, n10, n11, byteBuffer5);
            }
            ++n24;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
        gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
        return 0;
    }

    private static void writeTargaFile(String string, ByteBuffer byteBuffer, int n2, int n3) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(18);
            byteBuffer2.put(0, (byte)0).put(1, (byte)0);
            byteBuffer2.put(2, (byte)2);
            byteBuffer2.put(12, (byte)(n2 & 0xFF));
            byteBuffer2.put(13, (byte)(n2 >> 8));
            byteBuffer2.put(14, (byte)(n3 & 0xFF));
            byteBuffer2.put(15, (byte)(n3 >> 8));
            byteBuffer2.put(16, (byte)24);
            fileOutputStream.write(byteBuffer2.array());
            fileOutputStream.write(byteBuffer.array());
            byteBuffer.clear();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

