/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.mipmap;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.glu.mipmap.Extract;
import jogamp.opengl.glu.mipmap.ExtractPrimitive;
import jogamp.opengl.glu.mipmap.Mipmap;

public class HalveImage {
    private static final int BOX2 = 2;
    private static final int BOX4 = 4;
    private static final int BOX8 = 8;

    public static void halveImage(int n2, int n3, int n4, ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        int n5 = 0;
        short s = 0;
        int n6 = n3 / 2;
        int n7 = n4 / 2;
        int n8 = n3 * n2;
        for (int i2 = 0; i2 < n7; ++i2) {
            for (int i3 = 0; i3 < n6; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    shortBuffer.position(n5);
                    s = shortBuffer.get();
                    shortBuffer.position(n5 + n2);
                    s = (short)(s + shortBuffer.get());
                    shortBuffer.position(n5 + n8);
                    s = (short)(s + shortBuffer.get());
                    shortBuffer.position(n5 + n8 + n2);
                    s = (short)(s + shortBuffer.get());
                    s = (short)(s + 2);
                    s = (short)(s / 4);
                    shortBuffer2.put(s);
                    ++n5;
                }
                n5 += n2;
            }
            n5 += n8;
        }
    }

    public static void halveImage_ubyte(int n2, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n5, int n6, int n7) {
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_ubyte(n2, n3, n4, byteBuffer, byteBuffer2, n5, n6, n7);
            return;
        }
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        boolean bl = false;
        int n10 = 0;
        int n11 = 0;
        for (int i2 = 0; i2 < n9; ++i2) {
            for (int i3 = 0; i3 < n8; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    byteBuffer.position(n10);
                    n11 = 0xFF & byteBuffer.get();
                    byteBuffer.position(n10 + n7);
                    n11 += 0xFF & byteBuffer.get();
                    byteBuffer.position(n10 + n6);
                    n11 += 0xFF & byteBuffer.get();
                    byteBuffer.position(n10 + n6 + n7);
                    byteBuffer2.put((byte)((n11 += (0xFF & byteBuffer.get()) + 2) / 4));
                    n10 += n5;
                }
                n10 += n7;
            }
            n10 += n6;
        }
    }

    public static void halve1Dimage_ubyte(int n2, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n5, int n6, int n7) {
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n13;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n13 = 0; n13 < n2; ++n13) {
                    byteBuffer.position(n10);
                    n12 = 0xFF & byteBuffer.get();
                    byteBuffer.position(n10 + n7);
                    n12 += 0xFF & byteBuffer.get();
                    byteBuffer2.put((byte)(n12 /= 2));
                    n10 += n5;
                    ++n11;
                }
                n10 += n7;
            }
            n13 = n6 - n3 * n7;
            n10 += n13;
        } else if (n3 == 1) {
            int n14 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    byteBuffer.position(n10);
                    n12 = 0xFF & byteBuffer.get();
                    byteBuffer.position(n10 + n6);
                    n12 += 0xFF & byteBuffer.get();
                    byteBuffer2.put((byte)(n12 /= 2));
                    n10 += n5;
                    ++n11;
                }
                n10 += n14;
                n10 += n6;
            }
        }
        assert (n10 == n6 * n4);
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImage_byte(int n2, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n5, int n6, int n7) {
        int n8 = 0;
        byte by = 0;
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_byte(n2, n3, n4, byteBuffer, byteBuffer2, n5, n6, n7);
            return;
        }
        int n9 = n3 / 2;
        int n10 = n4 / 2;
        for (int i2 = 0; i2 < n10; ++i2) {
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    byteBuffer.position(n8);
                    by = byteBuffer.get();
                    byteBuffer.position(n8 + n7);
                    by = (byte)(by + byteBuffer.get());
                    byteBuffer.position(n8 + n6);
                    by = (byte)(by + byteBuffer.get());
                    byteBuffer.position(n8 + n6 + n7);
                    by = (byte)(by + byteBuffer.get());
                    by = (byte)(by + 2);
                    by = (byte)(by / 4);
                    byteBuffer2.put(by);
                    n8 += n5;
                }
                n8 += n7;
            }
            n8 += n6;
        }
    }

    public static void halve1Dimage_byte(int n2, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n5, int n6, int n7) {
        int n8 = n3 / 2;
        int n9 = n3 / 2;
        int n10 = 0;
        int n11 = 0;
        byte by = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n12;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n12 = 0; n12 < n2; ++n12) {
                    byteBuffer.position(n10);
                    by = byteBuffer.get();
                    byteBuffer.position(n10 + n7);
                    by = (byte)(by + byteBuffer.get());
                    by = (byte)(by / 2);
                    byteBuffer2.put(by);
                    n10 += n5;
                    ++n11;
                }
                n10 += n7;
            }
            n12 = n6 - n3 * n7;
            n10 += n12;
        } else if (n3 == 1) {
            int n13 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    byteBuffer.position(n10);
                    by = byteBuffer.get();
                    byteBuffer.position(n10 + n6);
                    by = (byte)(by + byteBuffer.get());
                    by = (byte)(by / 2);
                    n10 += n5;
                    ++n11;
                }
                n10 += n13;
                n10 += n6;
            }
            assert (n10 == n6 * n4);
        }
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImage_ushort(int n2, int n3, int n4, ByteBuffer byteBuffer, ShortBuffer shortBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = 0;
        int n9 = 0;
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_ushort(n2, n3, n4, byteBuffer, shortBuffer, n5, n6, n7, bl);
            return;
        }
        int n10 = n3 / 2;
        int n11 = n4 / 2;
        if (!bl) {
            for (int i2 = 0; i2 < n11; ++i2) {
                for (int i3 = 0; i3 < n10; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        byteBuffer.position(n8);
                        n9 = 0xFFFF & byteBuffer.getShort();
                        byteBuffer.position(n8 + n7);
                        n9 += 0xFFFF & byteBuffer.getShort();
                        byteBuffer.position(n8 + n6);
                        n9 += 0xFFFF & byteBuffer.getShort();
                        byteBuffer.position(n8 + n6 + n7);
                        shortBuffer.put((short)(((n9 += 0xFFFF & byteBuffer.getShort()) + 2) / 4));
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        } else {
            for (int i5 = 0; i5 < n11; ++i5) {
                for (int i6 = 0; i6 < n10; ++i6) {
                    for (int i7 = 0; i7 < n2; ++i7) {
                        byteBuffer.position(n8);
                        n9 = 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n8 + n7);
                        n9 += 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n8 + n6);
                        n9 += 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n8 + n6 + n7);
                        shortBuffer.put((short)(((n9 += 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) + 2) / 4));
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        }
    }

    public static void halve1Dimage_ushort(int n2, int n3, int n4, ByteBuffer byteBuffer, ShortBuffer shortBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = 0;
        int n11 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n12;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n12 = 0; n12 < n9; ++n12) {
                    int[] nArray = new int[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        nArray[0] = 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n10 + n7);
                        nArray[1] = 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                    } else {
                        byteBuffer.position(n10);
                        nArray[0] = 0xFFFF & byteBuffer.getShort();
                        byteBuffer.position(n10 + n7);
                        nArray[1] = 0xFFFF & byteBuffer.getShort();
                    }
                    shortBuffer.put((short)((nArray[0] + nArray[1]) / 2));
                    n10 += n5;
                    n11 += 2;
                }
                n10 += n7;
            }
            n12 = n6 - n3 * n7;
            n10 += n12;
        } else if (n3 == 1) {
            int n13 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    int[] nArray = new int[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        nArray[0] = 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n10 + n6);
                        nArray[0] = 0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                    } else {
                        byteBuffer.position(n10);
                        nArray[0] = 0xFFFF & byteBuffer.getShort();
                        byteBuffer.position(n10 + n6);
                        nArray[1] = 0xFFFF & byteBuffer.getShort();
                    }
                    shortBuffer.put((short)((nArray[0] + nArray[1]) / 2));
                    n10 += n5;
                    n11 += 2;
                }
                n10 += n13;
                n10 += n6;
            }
            assert (n10 == n6 * n4);
        }
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImage_short(int n2, int n3, int n4, ByteBuffer byteBuffer, ShortBuffer shortBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = 0;
        short s = 0;
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_short(n2, n3, n4, byteBuffer, shortBuffer, n5, n6, n7, bl);
            return;
        }
        int n9 = n3 / 2;
        int n10 = n4 / 2;
        if (!bl) {
            for (int i2 = 0; i2 < n10; ++i2) {
                for (int i3 = 0; i3 < n9; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        byteBuffer.position(n8);
                        s = byteBuffer.getShort();
                        byteBuffer.position(n8 + n7);
                        s = (short)(s + byteBuffer.getShort());
                        byteBuffer.position(n8 + n6);
                        s = (short)(s + byteBuffer.getShort());
                        byteBuffer.position(n8 + n6 + n7);
                        s = (short)(s + byteBuffer.getShort());
                        s = (short)(s + 2);
                        s = (short)(s / 4);
                        shortBuffer.put(s);
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        } else {
            for (int i5 = 0; i5 < n10; ++i5) {
                for (int i6 = 0; i6 < n9; ++i6) {
                    for (int i7 = 0; i7 < n2; ++i7) {
                        byteBuffer.position(n8);
                        s = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n8 + n7);
                        s = (short)(s + Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort()));
                        byteBuffer.position(n8 + n6);
                        s = (short)(s + Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort()));
                        byteBuffer.position(n8 + n6 + n7);
                        s = (short)(s + Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort()));
                        s = (short)(s + 2);
                        s = (short)(s / 4);
                        shortBuffer.put(s);
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        }
    }

    public static void halve1Dimage_short(int n2, int n3, int n4, ByteBuffer byteBuffer, ShortBuffer shortBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = 0;
        int n11 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n12;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n12 = 0; n12 < n2; ++n12) {
                    short[] sArray = new short[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        sArray[0] = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n10 + n7);
                        sArray[1] = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                    } else {
                        byteBuffer.position(n10);
                        sArray[0] = byteBuffer.getShort();
                        byteBuffer.position(n10 + n7);
                        sArray[1] = byteBuffer.getShort();
                    }
                    shortBuffer.put((short)((sArray[0] + sArray[1]) / 2));
                    n10 += n5;
                    n11 += 2;
                }
                n10 += n7;
            }
            n12 = n6 - n3 * n7;
            n10 += n12;
        } else if (n3 == 1) {
            int n13 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    short[] sArray = new short[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        sArray[0] = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                        byteBuffer.position(n10 + n6);
                        sArray[1] = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                    } else {
                        byteBuffer.position(n10);
                        sArray[0] = byteBuffer.getShort();
                        byteBuffer.position(n10 + n6);
                        sArray[1] = byteBuffer.getShort();
                    }
                    shortBuffer.put((short)((sArray[0] + sArray[1]) / 2));
                    n10 += n5;
                    n11 += 2;
                }
                n10 += n13;
                n10 += n6;
            }
            assert (n10 == n6 * n4);
        }
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImage_uint(int n2, int n3, int n4, ByteBuffer byteBuffer, IntBuffer intBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = 0;
        double d2 = 0.0;
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_uint(n2, n3, n4, byteBuffer, intBuffer, n5, n6, n7, bl);
            return;
        }
        int n9 = n3 / 2;
        int n10 = n4 / 2;
        if (!bl) {
            for (int i2 = 0; i2 < n10; ++i2) {
                for (int i3 = 0; i3 < n9; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        byteBuffer.position(n8);
                        d2 = Integer.MAX_VALUE & (long)byteBuffer.getInt();
                        byteBuffer.position(n8 + n7);
                        d2 += (double)(Integer.MAX_VALUE & (long)byteBuffer.getInt());
                        byteBuffer.position(n8 + n6);
                        d2 += (double)(Integer.MAX_VALUE & (long)byteBuffer.getInt());
                        byteBuffer.position(n8 + n6 + n7);
                        intBuffer.put((int)((d2 += (double)(Integer.MAX_VALUE & (long)byteBuffer.getInt())) / 4.0 + 0.5));
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        } else {
            for (int i5 = 0; i5 < n10; ++i5) {
                for (int i6 = 0; i6 < n9; ++i6) {
                    for (int i7 = 0; i7 < n2; ++i7) {
                        byteBuffer.position(n8);
                        double d3 = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        byteBuffer.position(n8 + n7);
                        d3 += (double)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt()));
                        byteBuffer.position(n8 + n6);
                        d3 += (double)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt()));
                        byteBuffer.position(n8 + n6 + n7);
                        d3 += (double)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt()));
                        d2 /= 4.0;
                        intBuffer.put((int)(d2 += 0.5));
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        }
    }

    public static void halve1Dimage_uint(int n2, int n3, int n4, ByteBuffer byteBuffer, IntBuffer intBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = 0;
        int n11 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n12;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n12 = 0; n12 < n9; ++n12) {
                    long[] lArray = new long[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        byteBuffer.position(n10 + n7);
                        lArray[1] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                    } else {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & byteBuffer.getInt();
                        byteBuffer.position(n10 + n7);
                        lArray[1] = 0xFFFFFFFF & byteBuffer.getInt();
                    }
                    intBuffer.put((int)((double)(lArray[0] + lArray[1]) / 2.0));
                    n10 += n5;
                    n11 += 4;
                }
                n10 += n7;
            }
            n12 = n6 - n3 * n7;
            n10 += n12;
        } else if (n3 == 1) {
            int n13 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    long[] lArray = new long[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        byteBuffer.position(n10 + n7);
                        lArray[0] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                    } else {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & byteBuffer.getInt();
                        byteBuffer.position(n10 + n6);
                        lArray[1] = 0xFFFFFFFF & byteBuffer.getInt();
                    }
                    intBuffer.put((int)((double)(lArray[0] + lArray[1]) / 2.0));
                    n10 += n5;
                    n11 += 4;
                }
                n10 += n13;
                n10 += n6;
            }
            assert (n10 == n6 * n4);
        }
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImage_int(int n2, int n3, int n4, ByteBuffer byteBuffer, IntBuffer intBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = 0;
        int n9 = 0;
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_int(n2, n3, n4, byteBuffer, intBuffer, n5, n6, n7, bl);
            return;
        }
        int n10 = n3 / 2;
        int n11 = n4 / 2;
        if (!bl) {
            for (int i2 = 0; i2 < n11; ++i2) {
                for (int i3 = 0; i3 < n10; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        byteBuffer.position(n8);
                        n9 = byteBuffer.getInt();
                        byteBuffer.position(n8 + n7);
                        n9 += byteBuffer.getInt();
                        byteBuffer.position(n8 + n6);
                        n9 += byteBuffer.getInt();
                        byteBuffer.position(n8 + n6 + n7);
                        n9 += byteBuffer.getInt();
                        n9 = (int)((float)n9 / 4.0f + 0.5f);
                        intBuffer.put(n9);
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        } else {
            for (int i5 = 0; i5 < n11; ++i5) {
                for (int i6 = 0; i6 < n10; ++i6) {
                    for (int i7 = 0; i7 < n2; ++i7) {
                        byteBuffer.position(n8);
                        long l2 = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        float f2 = l2;
                        byteBuffer.position(n8 + n7);
                        l2 = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        f2 += (float)l2;
                        byteBuffer.position(n8 + n6);
                        l2 = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        f2 += (float)l2;
                        byteBuffer.position(n8 + n6 + n7);
                        l2 = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        intBuffer.put((int)((f2 += (float)l2) / 4.0f + 0.5f));
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        }
    }

    public static void halve1Dimage_int(int n2, int n3, int n4, ByteBuffer byteBuffer, IntBuffer intBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = 0;
        int n11 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n12;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n12 = 0; n12 < n2; ++n12) {
                    long[] lArray = new long[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        byteBuffer.position(n10 + n7);
                        lArray[1] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                    } else {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & byteBuffer.getInt();
                        byteBuffer.position(n10 + n7);
                        lArray[1] = 0xFFFFFFFF & byteBuffer.getInt();
                    }
                    intBuffer.put((int)(((float)lArray[0] + (float)lArray[1]) / 2.0f));
                    n10 += n5;
                    n11 += 4;
                }
                n10 += n7;
            }
            n12 = n6 - n3 * n7;
            n10 += n12;
        } else if (n3 == 1) {
            int n13 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    long[] lArray = new long[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                        byteBuffer.position(n10 + n6);
                        lArray[1] = 0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                    } else {
                        byteBuffer.position(n10);
                        lArray[0] = 0xFFFFFFFF & byteBuffer.getInt();
                        byteBuffer.position(n10 + n6);
                        lArray[1] = 0xFFFFFFFF & byteBuffer.getInt();
                    }
                    intBuffer.put((int)(((float)lArray[0] + (float)lArray[1]) / 2.0f));
                    n10 += n5;
                    n11 += 4;
                }
                n10 += n13;
                n10 += n6;
            }
            assert (n10 == n6 * n4);
        }
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImage_float(int n2, int n3, int n4, ByteBuffer byteBuffer, FloatBuffer floatBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = 0;
        float f2 = 0.0f;
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1Dimage_float(n2, n3, n4, byteBuffer, floatBuffer, n5, n6, n7, bl);
            return;
        }
        int n9 = n3 / 2;
        int n10 = n4 / 2;
        if (!bl) {
            for (int i2 = 0; i2 < n10; ++i2) {
                for (int i3 = 0; i3 < n9; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        byteBuffer.position(n8);
                        f2 = byteBuffer.getFloat();
                        byteBuffer.position(n8 + n7);
                        f2 += byteBuffer.getFloat();
                        byteBuffer.position(n8 + n6);
                        f2 += byteBuffer.getFloat();
                        byteBuffer.position(n8 + n6 + n7);
                        floatBuffer.put(f2 /= 4.0f);
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        } else {
            for (int i5 = 0; i5 < n10; ++i5) {
                for (int i6 = 0; i6 < n9; ++i6) {
                    for (int i7 = 0; i7 < n2; ++i7) {
                        byteBuffer.position(n8);
                        float f3 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                        byteBuffer.position(n8 + n7);
                        f3 += Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                        byteBuffer.position(n8 + n6);
                        f3 += Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                        byteBuffer.position(n8 + n6 + n7);
                        floatBuffer.put((f3 += Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat())) / 4.0f);
                        n8 += n5;
                    }
                    n8 += n7;
                }
                n8 += n6;
            }
        }
    }

    public static void halve1Dimage_float(int n2, int n3, int n4, ByteBuffer byteBuffer, FloatBuffer floatBuffer, int n5, int n6, int n7, boolean bl) {
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = 0;
        int n11 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n12;
            assert (n3 != 1);
            n9 = 1;
            for (int i2 = 0; i2 < n8; ++i2) {
                for (n12 = 0; n12 < n2; ++n12) {
                    float[] fArray = new float[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        fArray[0] = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                        byteBuffer.position(n10 + n7);
                        fArray[1] = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                    } else {
                        byteBuffer.position(n10);
                        fArray[0] = byteBuffer.getFloat();
                        byteBuffer.position(n10 + n7);
                        fArray[1] = byteBuffer.getFloat();
                    }
                    floatBuffer.put((fArray[0] + fArray[1]) / 2.0f);
                    n10 += n5;
                    n11 += 4;
                }
                n10 += n7;
            }
            n12 = n6 - n3 * n7;
            n10 += n12;
        } else if (n3 == 1) {
            int n13 = n6 - n3 * n7;
            assert (n4 != 1);
            n8 = 1;
            for (int i3 = 0; i3 < n9; ++i3) {
                for (int i4 = 0; i4 < n2; ++i4) {
                    float[] fArray = new float[2];
                    if (bl) {
                        byteBuffer.position(n10);
                        fArray[0] = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                        byteBuffer.position(n10 + n6);
                        fArray[1] = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                    } else {
                        byteBuffer.position(n10);
                        fArray[0] = byteBuffer.getFloat();
                        byteBuffer.position(n10 + n6);
                        fArray[1] = byteBuffer.getFloat();
                    }
                    floatBuffer.put((fArray[0] + fArray[1]) / 2.0f);
                    n10 += n5;
                    n11 += 4;
                }
                n10 += n13;
                n10 += n6;
            }
            assert (n10 == n6 * n4);
        }
        assert (n11 == n2 * n5 * n8 * n9);
    }

    public static void halveImagePackedPixel(int n2, Extract extract, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n5, int n6, boolean bl) {
        if (n3 == 1 || n4 == 1) {
            assert (n3 != 1 || n4 != 1);
            HalveImage.halve1DimagePackedPixel(n2, extract, n3, n4, byteBuffer, byteBuffer2, n5, n6, bl);
            return;
        }
        int n7 = n3 / 2;
        int n8 = n4 / 2;
        int n9 = 0;
        int n10 = n6 - n3 * n5;
        int n11 = 0;
        for (int i2 = 0; i2 < n8; ++i2) {
            for (int i3 = 0; i3 < n7; ++i3) {
                float[] fArray = new float[4];
                float[][] fArray2 = new float[4][4];
                byteBuffer.position(n9);
                extract.extract(bl, byteBuffer, fArray2[0]);
                byteBuffer.position(n9 + n5);
                extract.extract(bl, byteBuffer, fArray2[1]);
                byteBuffer.position(n9 + n6);
                extract.extract(bl, byteBuffer, fArray2[2]);
                byteBuffer.position(n9 + n6 + n5);
                extract.extract(bl, byteBuffer, fArray2[3]);
                int n12 = 0;
                while (n12 < n2) {
                    int n13 = 0;
                    fArray[n12] = 0.0f;
                    for (n13 = 0; n13 < 4; ++n13) {
                        int n14 = n12;
                        fArray[n14] = fArray[n14] + fArray2[n13][n12];
                    }
                    int n15 = n12++;
                    fArray[n15] = fArray[n15] / 4.0f;
                }
                extract.shove(fArray, n11, byteBuffer2);
                ++n11;
                n9 += n5 + n5;
            }
            n9 += n10;
            n9 += n6;
        }
        assert (n9 == n6 * n4);
        assert (n11 == n7 * n8);
    }

    public static void halve1DimagePackedPixel(int n2, Extract extract, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n5, int n6, boolean bl) {
        int n7 = n3 / 2;
        int n8 = n4 / 2;
        int n9 = 0;
        assert (n3 == 1 || n4 == 1);
        assert (n3 != n4);
        if (n4 == 1) {
            int n10 = 0;
            assert (n3 != 1);
            n8 = 1;
            for (int i2 = 0; i2 < n7; ++i2) {
                float[] fArray = new float[4];
                float[][] fArray2 = new float[2][4];
                byteBuffer.position(n9);
                extract.extract(bl, byteBuffer, fArray2[0]);
                byteBuffer.position(n9 + n5);
                extract.extract(bl, byteBuffer, fArray2[1]);
                int n11 = 0;
                while (n11 < n2) {
                    int n12 = 0;
                    fArray[n11] = 0.0f;
                    for (n12 = 0; n12 < 2; ++n12) {
                        int n13 = n11;
                        fArray[n13] = fArray[n13] + fArray2[n12][n11];
                    }
                    int n14 = n11++;
                    fArray[n14] = fArray[n14] / 2.0f;
                }
                extract.shove(fArray, n10, byteBuffer2);
                ++n10;
                n9 += n5 + n5;
            }
            int n15 = n6 - n3 * n5;
            assert ((n9 += n15) == n6);
            assert (n10 == n7 * n8);
        } else if (n3 == 1) {
            int n16 = 0;
            assert (n4 != 1);
            n7 = 1;
            for (int i3 = 0; i3 < n8; ++i3) {
                float[] fArray = new float[4];
                float[][] fArray3 = new float[2][4];
                byteBuffer.position(n9);
                extract.extract(bl, byteBuffer, fArray3[0]);
                byteBuffer.position(n9 + n6);
                extract.extract(bl, byteBuffer, fArray3[1]);
                int n17 = 0;
                while (n17 < n2) {
                    int n18 = 0;
                    fArray[n17] = 0.0f;
                    for (n18 = 0; n18 < 2; ++n18) {
                        int n19 = n17;
                        fArray[n19] = fArray[n19] + fArray3[n18][n17];
                    }
                    int n20 = n17++;
                    fArray[n20] = fArray[n20] / 2.0f;
                }
                extract.shove(fArray, n16, byteBuffer2);
                ++n16;
                n9 += n6 + n6;
            }
            assert (n9 == n6);
            assert (n16 == n7 * n8);
        }
    }

    public static void halveImagePackedPixelSlice(int n2, Extract extract, int n3, int n4, int n5, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n6, int n7, int n8, boolean bl) {
        block17: {
            int n9;
            int n10;
            int n11;
            int n12;
            block18: {
                block16: {
                    n12 = n3 / 2;
                    n11 = n5 / 2;
                    n10 = 0;
                    n9 = 0;
                    assert ((n3 == 1 || n4 == 1) && n5 >= 2);
                    if (n3 != n4) break block16;
                    assert (n3 == 1 && n4 == 1);
                    assert (n5 >= 2);
                    for (int i2 = 0; i2 < n11; ++i2) {
                        float[] fArray = new float[4];
                        float[][] fArray2 = new float[2][4];
                        byteBuffer.position(n10);
                        extract.extract(bl, byteBuffer, fArray2[0]);
                        byteBuffer.position(n10 + n8);
                        extract.extract(bl, byteBuffer, fArray2[1]);
                        int n13 = 0;
                        while (n13 < n2) {
                            fArray[n13] = 0.0f;
                            for (int i3 = 0; i3 < 2; ++i3) {
                                int n14 = n13;
                                fArray[n14] = fArray[n14] + fArray2[i3][n13];
                            }
                            int n15 = n13++;
                            fArray[n15] = fArray[n15] / 2.0f;
                        }
                        extract.shove(fArray, n9, byteBuffer2);
                        ++n9;
                        n10 += n8 + n8;
                    }
                    break block17;
                }
                if (n4 != 1) break block18;
                assert (n3 != 1);
                for (int i4 = 0; i4 < n11; ++i4) {
                    for (int i5 = 0; i5 < n12; ++i5) {
                        float[] fArray = new float[4];
                        float[][] fArray3 = new float[4][4];
                        byteBuffer.position(n10);
                        extract.extract(bl, byteBuffer, fArray3[0]);
                        byteBuffer.position(n10 + n6);
                        extract.extract(bl, byteBuffer, fArray3[1]);
                        byteBuffer.position(n10 + n8);
                        extract.extract(bl, byteBuffer, fArray3[2]);
                        byteBuffer.position(n10 + n6 + n8);
                        extract.extract(bl, byteBuffer, fArray3[3]);
                        int n16 = 0;
                        while (n16 < n2) {
                            fArray[n16] = 0.0f;
                            for (int i6 = 0; i6 < 4; ++i6) {
                                int n17 = n16;
                                fArray[n17] = fArray[n17] + fArray3[i6][n16];
                            }
                            int n18 = n16++;
                            fArray[n18] = fArray[n18] / 4.0f;
                        }
                        extract.shove(fArray, n9, byteBuffer2);
                        ++n9;
                        n10 += n8 + n8;
                    }
                }
                break block17;
            }
            if (n3 != 1) break block17;
            assert (n4 != 1);
            for (int i7 = 0; i7 < n11; ++i7) {
                for (int i8 = 0; i8 < n12; ++i8) {
                    float[] fArray = new float[4];
                    float[][] fArray4 = new float[4][4];
                    byteBuffer.position(n10);
                    extract.extract(bl, byteBuffer, fArray4[0]);
                    byteBuffer.position(n10 + n7);
                    extract.extract(bl, byteBuffer, fArray4[1]);
                    byteBuffer.position(n10 + n8);
                    extract.extract(bl, byteBuffer, fArray4[2]);
                    byteBuffer.position(n10 + n7 + n8);
                    extract.extract(bl, byteBuffer, fArray4[3]);
                    int n19 = 0;
                    while (n19 < n2) {
                        fArray[n19] = 0.0f;
                        for (int i9 = 0; i9 < 4; ++i9) {
                            int n20 = n19;
                            fArray[n20] = fArray[n20] + fArray4[i9][n19];
                        }
                        int n21 = n19++;
                        fArray[n21] = fArray[n21] / 4.0f;
                    }
                    extract.shove(fArray, n9, byteBuffer2);
                    ++n9;
                    n10 += n8 + n8;
                }
            }
        }
    }

    public static void halveImageSlice(int n2, ExtractPrimitive extractPrimitive, int n3, int n4, int n5, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n6, int n7, int n8, int n9, boolean bl) {
        int n10 = n3 / 2;
        int n11 = n4 / 2;
        int n12 = n5 / 2;
        int n13 = 0;
        int n14 = n8 - n3 * n7;
        int n15 = 0;
        assert ((n3 == 1 || n4 == 1) && n5 >= 2);
        if (n3 == n4) {
            assert (n3 == 1 && n4 == 1);
            assert (n5 >= 2);
            for (int i2 = 0; i2 < n12; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    double[] dArray = new double[4];
                    double[][] dArray2 = new double[2][4];
                    byteBuffer.position(n13);
                    dArray2[0][i3] = extractPrimitive.extract(bl, byteBuffer);
                    byteBuffer.position(n13 + n9);
                    dArray2[1][i3] = extractPrimitive.extract(bl, byteBuffer);
                    dArray[i3] = 0.0;
                    for (int i4 = 0; i4 < 2; ++i4) {
                        int n16 = i3;
                        dArray[n16] = dArray[n16] + dArray2[i4][i3];
                    }
                    int n17 = i3;
                    dArray[n17] = dArray[n17] / 2.0;
                    extractPrimitive.shove(dArray[i3], n15, byteBuffer2);
                    ++n15;
                    n13 += n6;
                }
                n13 += n8;
            }
            assert (n13 == n8 * n4 * n5);
            assert (n15 == n12 * n2);
        } else if (n4 == 1) {
            assert (n3 != 1);
            for (int i5 = 0; i5 < n12; ++i5) {
                for (int i6 = 0; i6 < n10; ++i6) {
                    for (int i7 = 0; i7 < n2; ++i7) {
                        double[] dArray = new double[4];
                        double[][] dArray3 = new double[4][4];
                        byteBuffer.position(n13);
                        dArray3[0][i7] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n7);
                        dArray3[1][i7] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n9);
                        dArray3[2][i7] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n9 + n7);
                        dArray3[3][i7] = extractPrimitive.extract(bl, byteBuffer);
                        dArray[i7] = 0.0;
                        for (int i8 = 0; i8 < 4; ++i8) {
                            int n18 = i7;
                            dArray[n18] = dArray[n18] + dArray3[i8][i7];
                        }
                        int n19 = i7;
                        dArray[n19] = dArray[n19] / 4.0;
                        extractPrimitive.shove(dArray[i7], n15, byteBuffer2);
                        ++n15;
                        n13 += n6;
                    }
                    n13 += n6;
                }
                n13 += n14;
                n13 += n8;
            }
            assert (n13 == n8 * n4 * n5);
            assert (n15 == n10 * n12 * n2);
        } else if (n3 == 1) {
            assert (n4 != 1);
            for (int i9 = 0; i9 < n12; ++i9) {
                for (int i10 = 0; i10 < n11; ++i10) {
                    for (int i11 = 0; i11 < n2; ++i11) {
                        double[] dArray = new double[4];
                        double[][] dArray4 = new double[4][4];
                        byteBuffer.position(n13);
                        dArray4[0][i11] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n8);
                        dArray4[1][i11] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n9);
                        dArray4[2][i11] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n9 + n7);
                        dArray4[3][i11] = extractPrimitive.extract(bl, byteBuffer);
                        dArray[i11] = 0.0;
                        for (int i12 = 0; i12 < 4; ++i12) {
                            int n20 = i11;
                            dArray[n20] = dArray[n20] + dArray4[i12][i11];
                        }
                        int n21 = i11;
                        dArray[n21] = dArray[n21] / 4.0;
                        extractPrimitive.shove(dArray[i11], n15, byteBuffer2);
                        ++n15;
                        n13 += n6;
                    }
                    n13 += n14;
                    n13 += n8;
                }
                n13 += n9;
            }
            assert (n13 == n8 * n4 * n5);
            assert (n15 == n10 * n12 * n2);
        }
    }

    public static void halveImage3D(int n2, ExtractPrimitive extractPrimitive, int n3, int n4, int n5, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n6, int n7, int n8, int n9, boolean bl) {
        assert (n5 > 1);
        if (n3 == 1 || n4 == 1) {
            assert (1 <= n5);
            HalveImage.halveImageSlice(n2, extractPrimitive, n3, n4, n5, byteBuffer, byteBuffer2, n6, n7, n8, n9, bl);
            return;
        }
        int n10 = n3 / 2;
        int n11 = n4 / 2;
        int n12 = n5 / 2;
        int n13 = 0;
        int n14 = n8 - n3 * n7;
        int n15 = 0;
        for (int i2 = 0; i2 < n12; ++i2) {
            for (int i3 = 0; i3 < n11; ++i3) {
                for (int i4 = 0; i4 < n10; ++i4) {
                    for (int i5 = 0; i5 < n2; ++i5) {
                        double[] dArray = new double[4];
                        double[][] dArray2 = new double[8][4];
                        byteBuffer.position(n13);
                        dArray2[0][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n7);
                        dArray2[1][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n8);
                        dArray2[2][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n8 + n7);
                        dArray2[3][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n9);
                        dArray2[4][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n7 + n9);
                        dArray2[5][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n8 + n9);
                        dArray2[6][i5] = extractPrimitive.extract(bl, byteBuffer);
                        byteBuffer.position(n13 + n8 + n9 + n7);
                        dArray2[7][i5] = extractPrimitive.extract(bl, byteBuffer);
                        dArray[i5] = 0.0;
                        for (int i6 = 0; i6 < 8; ++i6) {
                            int n16 = i5;
                            dArray[n16] = dArray[n16] + dArray2[i6][i5];
                        }
                        int n17 = i5;
                        dArray[n17] = dArray[n17] / 8.0;
                        extractPrimitive.shove(dArray[i5], n15, byteBuffer2);
                        ++n15;
                        n13 += n6;
                    }
                    n13 += n7;
                }
                n13 += n14;
                n13 += n8;
            }
            n13 += n9;
        }
        assert (n13 == n8 * n4 * n5);
        assert (n15 == n10 * n11 * n12 * n2);
    }

    public static void halveImagePackedPixel3D(int n2, Extract extract, int n3, int n4, int n5, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n6, int n7, int n8, boolean bl) {
        if (n5 == 1) {
            assert (1 <= n3 && 1 <= n4);
            HalveImage.halveImagePackedPixel(n2, extract, n3, n4, byteBuffer, byteBuffer2, n6, n7, bl);
            return;
        }
        if (n3 == 1 || n4 == 1) {
            assert (1 <= n5);
            HalveImage.halveImagePackedPixelSlice(n2, extract, n3, n4, n5, byteBuffer, byteBuffer2, n6, n7, n8, bl);
            return;
        }
        int n9 = n3 / 2;
        int n10 = n4 / 2;
        int n11 = n5 / 2;
        int n12 = 0;
        int n13 = n7 - n3 * n6;
        int n14 = 0;
        for (int i2 = 0; i2 < n11; ++i2) {
            for (int i3 = 0; i3 < n10; ++i3) {
                for (int i4 = 0; i4 < n9; ++i4) {
                    float[] fArray = new float[4];
                    float[][] fArray2 = new float[8][4];
                    byteBuffer.position(n12);
                    extract.extract(bl, byteBuffer, fArray2[0]);
                    byteBuffer.position(n12 + n6);
                    extract.extract(bl, byteBuffer, fArray2[1]);
                    byteBuffer.position(n12 + n7);
                    extract.extract(bl, byteBuffer, fArray2[2]);
                    byteBuffer.position(n12 + n7 + n6);
                    extract.extract(bl, byteBuffer, fArray2[3]);
                    byteBuffer.position(n12 + n8);
                    extract.extract(bl, byteBuffer, fArray2[4]);
                    byteBuffer.position(n12 + n6 + n8);
                    extract.extract(bl, byteBuffer, fArray2[5]);
                    byteBuffer.position(n12 + n7 + n8);
                    extract.extract(bl, byteBuffer, fArray2[6]);
                    byteBuffer.position(n12 + n7 + n6 + n8);
                    extract.extract(bl, byteBuffer, fArray2[7]);
                    int n15 = 0;
                    while (n15 < n2) {
                        fArray[n15] = 0.0f;
                        for (int i5 = 0; i5 < 8; ++i5) {
                            int n16 = n15;
                            fArray[n16] = fArray[n16] + fArray2[i5][n15];
                        }
                        int n17 = n15++;
                        fArray[n17] = fArray[n17] / 8.0f;
                    }
                    extract.shove(fArray, n14, byteBuffer2);
                    ++n14;
                    n12 += n6 + n6;
                }
                n12 += n13;
                n12 += n7;
            }
            n12 += n8;
        }
        assert (n12 == n7 * n4 * n5);
        assert (n14 == n9 * n10 * n11);
    }
}

