/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory;

public class MacOSXCGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    static final IntBuffer cglInternalAttributeToken = Buffers.newDirectIntBuffer(new int[]{99, 73, 72, 58, 90, 5, 6, 8, 11, 12, 14, 13, 55, 56});

    MacOSXCGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2) {
        super(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(MacOSXCGLDrawableFactory macOSXCGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        MacOSXCGLDrawableFactory.SharedResource sharedResource = macOSXCGLDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    static IntBuffer GLCapabilities2NSAttribList(AbstractGraphicsDevice abstractGraphicsDevice, IntBuffer intBuffer, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2, int n3, int n4) {
        int n5 = intBuffer.remaining();
        int n6 = intBuffer.position();
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(n5);
        block15: for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = intBuffer.get(i2 + n6);
            switch (n7) {
                case 99: {
                    intBuffer2.put(i2, MacOSXCGLContext.GLProfile2CGLOGLProfileValue(abstractGraphicsDevice, n2, n3, n4));
                    continue block15;
                }
                case 72: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getHardwareAccelerated() ? 1 : 0);
                    continue block15;
                }
                case 58: {
                    intBuffer2.put(i2, 0);
                    continue block15;
                }
                case 90: {
                    intBuffer2.put(i2, !gLCapabilitiesImmutable.isOnscreen() && gLCapabilitiesImmutable.isPBuffer() ? 1 : 0);
                    continue block15;
                }
                case 5: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0);
                    continue block15;
                }
                case 6: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getStereo() ? 1 : 0);
                    continue block15;
                }
                case 8: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits());
                    continue block15;
                }
                case 11: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getAlphaBits());
                    continue block15;
                }
                case 12: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getDepthBits());
                    continue block15;
                }
                case 14: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits());
                    continue block15;
                }
                case 13: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getStencilBits());
                    continue block15;
                }
                case 55: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getSampleBuffers() ? 1 : 0);
                    continue block15;
                }
                case 56: {
                    intBuffer2.put(i2, gLCapabilitiesImmutable.getNumSamples());
                    continue block15;
                }
            }
        }
        return intBuffer2;
    }

    static long GLCapabilities2NSPixelFormat(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2, int n3, int n4) {
        IntBuffer intBuffer = cglInternalAttributeToken.duplicate();
        if (!MacOSXCGLContext.isLionOrLater) {
            intBuffer.position(1);
        }
        IntBuffer intBuffer2 = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSAttribList(abstractGraphicsDevice, intBuffer, gLCapabilitiesImmutable, n2, n3, n4);
        return CGL.createPixelFormat(intBuffer, intBuffer.remaining(), intBuffer2);
    }

    static GLCapabilities NSPixelFormat2GLCapabilities(GLProfile gLProfile, long l2) {
        return MacOSXCGLGraphicsConfiguration.PixelFormat2GLCapabilities(gLProfile, l2, true);
    }

    static long GLCapabilities2CGLPixelFormat(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2, int n3, int n4) {
        IntBuffer intBuffer;
        PointerBuffer pointerBuffer;
        int n5;
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(256);
        int n6 = 0;
        if (MacOSXCGLContext.isLionOrLater) {
            intBuffer2.put(n6++, 99);
            intBuffer2.put(n6++, MacOSXCGLContext.GLProfile2CGLOGLProfileValue(abstractGraphicsDevice, n2, n3, n4));
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            intBuffer2.put(n6++, 5);
        }
        if (gLCapabilitiesImmutable.getStereo()) {
            intBuffer2.put(n6++, 6);
        }
        intBuffer2.put(n6++, 8);
        intBuffer2.put(n6++, gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits());
        intBuffer2.put(n6++, 11);
        intBuffer2.put(n6++, gLCapabilitiesImmutable.getAlphaBits());
        intBuffer2.put(n6++, 12);
        intBuffer2.put(n6++, gLCapabilitiesImmutable.getDepthBits());
        intBuffer2.put(n6++, 13);
        intBuffer2.put(n6++, gLCapabilitiesImmutable.getStencilBits());
        intBuffer2.put(n6++, 14);
        intBuffer2.put(n6++, gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits());
        if (gLCapabilitiesImmutable.getSampleBuffers()) {
            intBuffer2.put(n6++, 55);
            intBuffer2.put(n6++, 1);
            intBuffer2.put(n6++, 56);
            intBuffer2.put(n6++, gLCapabilitiesImmutable.getNumSamples());
        }
        if ((n5 = CGL.CGLChoosePixelFormat(intBuffer2, pointerBuffer = PointerBuffer.allocateDirect(1), intBuffer = Buffers.newDirectIntBuffer(1))) != 0) {
            throw new GLException("Error code " + n5 + " while choosing pixel format");
        }
        return pointerBuffer.get(0);
    }

    static GLCapabilities CGLPixelFormat2GLCapabilities(long l2) {
        return MacOSXCGLGraphicsConfiguration.PixelFormat2GLCapabilities(null, l2, false);
    }

    private static GLCapabilities PixelFormat2GLCapabilities(GLProfile gLProfile, long l2, boolean bl) {
        int n2;
        IntBuffer intBuffer = cglInternalAttributeToken.duplicate();
        int n3 = !MacOSXCGLContext.isLionOrLater ? 1 : 0;
        intBuffer.position(n3);
        int n4 = intBuffer.remaining();
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(n4);
        if (bl) {
            CGL.queryPixelFormat(l2, intBuffer, n4, intBuffer2);
        } else {
            CGL.CGLQueryPixelFormat(l2, intBuffer, n4, intBuffer2);
        }
        if (null == gLProfile && MacOSXCGLContext.isLionOrLater) {
            block19: for (int i2 = 0; i2 < n4; ++i2) {
                n2 = intBuffer2.get(i2);
                if (99 != intBuffer.get(i2 + n3)) continue;
                switch (n2) {
                    case 16640: {
                        gLProfile = GLProfile.get("GL4");
                        continue block19;
                    }
                    case 12800: {
                        gLProfile = GLProfile.get("GL3");
                        continue block19;
                    }
                    case 4096: {
                        gLProfile = GLProfile.get("GL2");
                        continue block19;
                    }
                    default: {
                        throw new RuntimeException("Unhandled OSX OpenGL Profile: 0x" + Integer.toHexString(n2));
                    }
                }
            }
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.get("GL2");
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        n2 = 0;
        block20: for (int i3 = 0; i3 < n4; ++i3) {
            int n5 = intBuffer.get(i3 + n3);
            int n6 = intBuffer2.get(i3);
            switch (n5) {
                case 73: {
                    gLCapabilities.setHardwareAccelerated(n6 != 0);
                    continue block20;
                }
                case 58: {
                    continue block20;
                }
                case 90: {
                    gLCapabilities.setPBuffer(n6 != 0);
                    continue block20;
                }
                case 5: {
                    gLCapabilities.setDoubleBuffered(n6 != 0);
                    continue block20;
                }
                case 6: {
                    gLCapabilities.setStereo(n6 != 0);
                    continue block20;
                }
                case 8: {
                    int n7 = (32 == n6 ? 24 : n6) / 3;
                    gLCapabilities.setRedBits(n7);
                    gLCapabilities.setGreenBits(n7);
                    gLCapabilities.setBlueBits(n7);
                    continue block20;
                }
                case 11: {
                    n2 = n6;
                    continue block20;
                }
                case 12: {
                    gLCapabilities.setDepthBits(n6);
                    continue block20;
                }
                case 14: {
                    int n7 = n6 / 4;
                    gLCapabilities.setAccumRedBits(n7);
                    gLCapabilities.setAccumGreenBits(n7);
                    gLCapabilities.setAccumBlueBits(n7);
                    gLCapabilities.setAccumAlphaBits(n7);
                    continue block20;
                }
                case 13: {
                    gLCapabilities.setStencilBits(n6);
                    continue block20;
                }
                case 55: {
                    gLCapabilities.setSampleBuffers(n6 != 0);
                    continue block20;
                }
                case 56: {
                    gLCapabilities.setNumSamples(n6);
                    continue block20;
                }
            }
        }
        gLCapabilities.setAlphaBits(n2);
        return gLCapabilities;
    }
}

